/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources;

import java.util.HashMap;
import org.apache.commons.configuration.Configuration;
import pt.lsts.s57.S57Factory;
import pt.lsts.s57.resources.CSVType;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.Agencies;
import pt.lsts.s57.resources.entities.Attributes;
import pt.lsts.s57.resources.entities.Inputs;
import pt.lsts.s57.resources.entities.ObjectClasses;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.LookupTable;
import pt.lsts.s57.resources.entities.s52.LookupTableType;
import pt.lsts.s57.resources.entities.s52.symbol.Symbols;

public class ResourcesFactory {
    private ResourcesFactory() {
    }

    public static Resources build(Configuration configuration) {
        long l = System.nanoTime();
        ObjectClasses objectClasses = ObjectClasses.forge(configuration);
        ObjectClasses objectClasses2 = ObjectClasses.forge(configuration, CSVType.AML);
        ObjectClasses objectClasses3 = ObjectClasses.forge(configuration, CSVType.IW);
        HashMap<CSVType, ObjectClasses> hashMap = new HashMap<CSVType, ObjectClasses>();
        hashMap.put(CSVType.STANDARD, objectClasses);
        hashMap.put(CSVType.AML, objectClasses2);
        hashMap.put(CSVType.IW, objectClasses3);
        Attributes attributes = Attributes.forge(configuration);
        Attributes attributes2 = Attributes.forge(configuration, CSVType.AML);
        Attributes attributes3 = Attributes.forge(configuration, CSVType.IW);
        HashMap<CSVType, Attributes> hashMap2 = new HashMap<CSVType, Attributes>();
        hashMap2.put(CSVType.STANDARD, attributes);
        hashMap2.put(CSVType.AML, attributes2);
        hashMap2.put(CSVType.IW, attributes3);
        Agencies agencies = Agencies.forge(configuration);
        Inputs inputs = Inputs.forge(configuration);
        LookupTable lookupTable = LookupTable.forge(configuration, LookupTableType.PAPER_CHART);
        LookupTable lookupTable2 = LookupTable.forge(configuration, LookupTableType.LINES);
        LookupTable lookupTable3 = LookupTable.forge(configuration, LookupTableType.PLAIN_BOUNDARIES);
        LookupTable lookupTable4 = LookupTable.forge(configuration, LookupTableType.SIMPLIFIED);
        LookupTable lookupTable5 = LookupTable.forge(configuration, LookupTableType.SYMBOLIZED_BOUNDARIES);
        HashMap<LookupTableType, LookupTable> hashMap3 = new HashMap<LookupTableType, LookupTable>();
        hashMap3.put(LookupTableType.PAPER_CHART, lookupTable);
        hashMap3.put(LookupTableType.LINES, lookupTable2);
        hashMap3.put(LookupTableType.PLAIN_BOUNDARIES, lookupTable3);
        hashMap3.put(LookupTableType.SIMPLIFIED, lookupTable4);
        hashMap3.put(LookupTableType.SYMBOLIZED_BOUNDARIES, lookupTable5);
        ColorTable colorTable = ColorTable.forge(configuration);
        Symbols symbols = Symbols.forge(configuration, colorTable);
        if (S57Factory.DEBUG) {
            System.out.println("Resources finished in " + (double)(System.nanoTime() - l) / 1.0E9 + "s");
        }
        Resources resources = Resources.forge(configuration, hashMap, hashMap2, agencies, inputs, hashMap3, colorTable, symbols);
        return resources;
    }
}

