/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities;

import com.csvreader.CsvReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import pt.lsts.s57.resources.entities.Agency;

public class Agencies
implements Serializable {
    private static final long serialVersionUID = 6342359091955138765L;
    private final Map<Integer, Agency> instances = new HashMap<Integer, Agency>();

    public static Agencies forge(Configuration configuration) {
        try {
            return new Agencies(configuration);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            return null;
        }
    }

    private Agencies(Configuration configuration) throws Exception {
        String string = configuration.getString("s57.agencies");
        this.read(string);
    }

    private void read(String string) throws Exception {
        try (CsvReader csvReader = new CsvReader(string);){
            csvReader.readHeaders();
            while (csvReader.readRecord()) {
                Agency agency = new Agency(new Integer(csvReader.get(0)), csvReader.get(1), new Integer(csvReader.get(2)), csvReader.get(3), csvReader.get(4));
                this.instances.put(agency.code, agency);
            }
        }
    }

    public Agency get(Integer n) {
        return this.instances.get(n);
    }

    public Agency get(String string) {
        return this.instances.get(Integer.valueOf(string));
    }

    public int getSize() {
        return this.instances.size();
    }

    public String toString() {
        String string = new String();
        for (Agency agency : this.instances.values()) {
            string = string + agency.toString() + "\n";
        }
        return "Agencies [instances=" + string + "]";
    }
}

