/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities;

import com.csvreader.CsvReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import pt.lsts.s57.resources.CSVType;
import pt.lsts.s57.resources.entities.Attribute;

public final class Attributes
implements Serializable {
    private static final long serialVersionUID = -2023427511433612419L;
    private final CSVType type;
    private final String filePath;
    private final Map<Integer, Attribute> instances = new HashMap<Integer, Attribute>();
    private final Map<String, Integer> acronymToCode = new HashMap<String, Integer>();

    public static Attributes forge(Configuration configuration) {
        try {
            return new Attributes(CSVType.STANDARD, configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static Attributes forge(Configuration configuration, CSVType cSVType) {
        try {
            return new Attributes(cSVType, configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private Attributes(CSVType cSVType, Configuration configuration) throws Exception {
        this.type = cSVType;
        switch (cSVType) {
            case STANDARD: {
                this.filePath = configuration.getString("s57.attributes");
                break;
            }
            case AML: {
                this.filePath = configuration.getString("s57.attributes_aml");
                break;
            }
            case IW: {
                this.filePath = configuration.getString("s57.attributes_iw");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Object Class table type");
            }
        }
        this.read(this.filePath);
    }

    private void read(String string) throws Exception {
        try (CsvReader csvReader = new CsvReader(string);){
            csvReader.readHeaders();
            while (csvReader.readRecord()) {
                Attribute attribute = new Attribute(new Integer(csvReader.get(0)), csvReader.get(1), csvReader.get(2), csvReader.get(3), csvReader.get(4));
                this.instances.put(attribute.code, attribute);
                this.acronymToCode.put(attribute.acronym, attribute.code);
            }
        }
    }

    public Attribute get(String string) {
        if (this.instances == null || this.instances.isEmpty()) {
            return null;
        }
        return this.instances.get(this.getcode(string));
    }

    public Attribute get(Integer n) {
        if (this.instances == null || this.instances.isEmpty()) {
            return null;
        }
        return this.instances.get(n);
    }

    public Integer getcode(String string) {
        return this.acronymToCode.get(string);
    }

    public int getSize() {
        return this.instances.size();
    }

    public CSVType getType() {
        return this.type;
    }
}

