/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities;

import com.csvreader.CsvReader;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import pt.lsts.s57.resources.CSVType;
import pt.lsts.s57.resources.entities.ObjectClass;

public final class ObjectClasses
implements Serializable {
    private static final long serialVersionUID = 7957702892300635364L;
    private final CSVType type;
    private final String filePath;
    private final Map<String, ObjectClass> instances = new HashMap<String, ObjectClass>();

    public static ObjectClasses forge(Configuration configuration) {
        try {
            return new ObjectClasses(CSVType.STANDARD, configuration);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return null;
        }
    }

    public static ObjectClasses forge(Configuration configuration, CSVType cSVType) {
        try {
            return new ObjectClasses(cSVType, configuration);
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
            return null;
        }
    }

    private ObjectClasses(CSVType cSVType, Configuration configuration) throws Exception {
        this.type = cSVType;
        switch (cSVType) {
            case STANDARD: {
                this.filePath = configuration.getString("s57.objects");
                break;
            }
            case AML: {
                this.filePath = configuration.getString("s57.objects_aml");
                break;
            }
            case IW: {
                this.filePath = configuration.getString("s57.objects_iw");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Object Class table type");
            }
        }
        this.read(this.filePath);
    }

    private void read(String string) throws Exception {
        try (CsvReader csvReader = new CsvReader(string);){
            csvReader.readHeaders();
            while (csvReader.readRecord()) {
                ObjectClass objectClass = new ObjectClass(new Integer(csvReader.get(0)), csvReader.get(1), csvReader.get(2), csvReader.get(3), csvReader.get(4), csvReader.get(5), csvReader.get(6), csvReader.get(7));
                this.instances.put(objectClass.acronym, objectClass);
            }
        }
    }

    public ObjectClass get(String string) {
        if (this.instances == null || this.instances.isEmpty()) {
            return null;
        }
        return this.instances.get(string);
    }

    public int getSize() {
        return this.instances.size();
    }

    public CSVType getType() {
        return this.type;
    }

    public String toString() {
        if (this.instances == null || this.instances.isEmpty()) {
            return null;
        }
        String string = new String();
        for (ObjectClass objectClass : this.instances.values()) {
            string = string + objectClass.toString() + "\n";
        }
        return string;
    }
}

