/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.S52Color;

public class ColorTable
implements Serializable {
    private static final long serialVersionUID = -6124952754662032293L;
    private final Map<String, S52Color> records = new LinkedHashMap<String, S52Color>();

    public static ColorTable forge(Configuration configuration) {
        return new ColorTable(configuration);
    }

    private ColorTable(Configuration configuration) {
        String string = configuration.getString("s52.colors");
        try {
            this.read(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String string) throws IOException {
        File file = new File(string);
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ColorScheme colorScheme = null;
        LineIterator lineIterator = FileUtils.lineIterator(file, "UTF-8");
        try {
            while (lineIterator.hasNext()) {
                Object object;
                Object object2;
                Object object3 = lineIterator.nextLine();
                if ((object3 = this.prepare((String)object3)) == null) {
                    break;
                }
                if (Character.isDigit(((String)object3).charAt(0)) || ((String)object3).contains("*")) continue;
                if (((String)object3).substring(0, 4).equals("COLS")) {
                    String[] stringArray = ((String)object3).split(" ");
                    object2 = Pattern.compile("([0-9A-Za-z]*)NIL([A-Z_]*)");
                    object = ((Pattern)object2).matcher(stringArray[1]);
                    ((Matcher)object).find();
                    colorScheme = ColorScheme.valueOf(((Matcher)object).group(2));
                    continue;
                }
                Pattern pattern = Pattern.compile("[A-Z]{4}\\s[0-9]*([A-Z0-9]{5})([0-9\\.]*)\\s([0-9\\.]*)\\s([0-9\\.]*)\\s([a-z]*)");
                object2 = pattern.matcher((CharSequence)object3);
                ((Matcher)object2).find();
                object = ((Matcher)object2).group(1);
                String[] stringArray = new String[]{((Matcher)object2).group(2), ((Matcher)object2).group(3), ((Matcher)object2).group(4), ((Matcher)object2).group(5)};
                if (linkedHashMap.containsKey(object)) {
                    ((Map)linkedHashMap.get(object)).put(colorScheme, stringArray);
                    continue;
                }
                HashMap<ColorScheme, String[]> hashMap = new HashMap<ColorScheme, String[]>();
                hashMap.put(colorScheme, stringArray);
                linkedHashMap.put(object, hashMap);
            }
        }
        finally {
            LineIterator.closeQuietly(lineIterator);
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            this.records.put((String)entry.getKey(), S52Color.forge((String)entry.getKey(), (Map)entry.getValue()));
        }
    }

    private String prepare(String string) {
        string = string.replace(String.valueOf('\u001f'), " ");
        string = string.replace("   ", " ");
        return string;
    }

    public S52Color get(String string) {
        return this.records.get(string);
    }

    public Map<String, S52Color> getRecords() {
        return this.records;
    }
}

