/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.S52Color;

public class ColorTest
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JButton b1;
    protected JButton b2;
    protected JButton b3;

    public ColorTest() {
        PropertiesConfiguration propertiesConfiguration = null;
        try {
            propertiesConfiguration = new PropertiesConfiguration("resources/config.properties");
        }
        catch (ConfigurationException configurationException) {
            configurationException.printStackTrace();
        }
        ColorTable colorTable = ColorTable.forge(propertiesConfiguration);
        Map<String, S52Color> map = colorTable.getRecords();
        for (Map.Entry<String, S52Color> entry : map.entrySet()) {
            Color color = entry.getValue().get(ColorScheme.DAY_BRIGHT);
            JButton jButton = new JButton(entry.getValue().getName() + "\n " + entry.getValue().getCode());
            jButton.setBackground(color);
            this.add(jButton);
        }
    }

    private static void createAndShowGUI() {
        JFrame jFrame = new JFrame("ButtonDemo");
        jFrame.setDefaultCloseOperation(3);
        ColorTest colorTest = new ColorTest();
        colorTest.setOpaque(true);
        colorTest.setSize(400, 400);
        jFrame.setContentPane(colorTest);
        jFrame.setSize(400, 400);
        jFrame.pack();
        jFrame.setVisible(true);
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ColorTest.createAndShowGUI();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }
}

