/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import pt.lsts.s57.resources.entities.s52.InstructionType;

public class Instruction
implements Serializable {
    private static final long serialVersionUID = 2581432604148279260L;
    private final InstructionType type;
    private final List<String> params;

    private Instruction(InstructionType instructionType, String string) {
        this.type = instructionType;
        this.params = Arrays.asList(string.split(","));
    }

    public static Instruction forge(InstructionType instructionType, String string) {
        return new Instruction(instructionType, string);
    }

    public boolean isConditional() {
        return this.type.equals((Object)InstructionType.CS);
    }

    public InstructionType getType() {
        return this.type;
    }

    public List<String> getParams() {
        return this.params;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.params == null ? 0 : this.params.hashCode());
        n = 31 * n + (this.type == null ? 0 : this.type.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Instruction instruction = (Instruction)object;
        if (this.params == null ? instruction.params != null : !this.params.equals(instruction.params)) {
            return false;
        }
        return this.type == instruction.type;
    }

    public String toString() {
        return "Instruction [type=" + (Object)((Object)this.type) + ", params=" + this.params + "]";
    }
}

