/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import pt.lsts.s57.entities.S57Attribute;
import pt.lsts.s57.resources.entities.s52.LookupTableRecord;
import pt.lsts.s57.resources.entities.s52.LookupTableType;

public class LookupTable
implements Serializable {
    private static final long serialVersionUID = -9164912560494526779L;
    private final LookupTableType type;
    private final List<LookupTableRecord> records = new ArrayList<LookupTableRecord>();

    public static LookupTable forge(Configuration configuration, LookupTableType lookupTableType) {
        return new LookupTable(configuration, lookupTableType);
    }

    private LookupTable(Configuration configuration, LookupTableType lookupTableType) {
        String string;
        this.type = lookupTableType;
        switch (lookupTableType) {
            case LINES: {
                string = configuration.getString("s52.lines");
                break;
            }
            case PAPER_CHART: {
                string = configuration.getString("s52.paper_chart");
                break;
            }
            case SIMPLIFIED: {
                string = configuration.getString("s52.simplified");
                break;
            }
            case PLAIN_BOUNDARIES: {
                string = configuration.getString("s52.plain_boundaries");
                break;
            }
            case SYMBOLIZED_BOUNDARIES: {
                string = configuration.getString("s52.symbolized_boundaries");
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid lup type");
            }
        }
        try {
            this.read(string);
        }
        catch (IOException iOException) {
            System.out.println("cant open file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String string) throws IOException {
        File file = new File(string);
        LineIterator lineIterator = FileUtils.lineIterator(file, "UTF-8");
        try {
            while (lineIterator.hasNext()) {
                String string2 = lineIterator.nextLine();
                string2 = string2.substring(1);
                int n = string2.length();
                string2 = string2.substring(0, n - 1);
                List<String> list = Arrays.asList(string2.split("\",\"", -1));
                this.records.add(LookupTableRecord.forge(list));
            }
        }
        finally {
            LineIterator.closeQuietly(lineIterator);
        }
    }

    public LookupTableType getType() {
        return this.type;
    }

    public List<LookupTableRecord> getRecords() {
        return this.records;
    }

    public LookupTableRecord get(String string, Map<String, S57Attribute> map) {
        Integer[] integerArray;
        ArrayList<Integer[]> arrayList = new ArrayList<Integer[]>();
        ListIterator<LookupTableRecord> listIterator = this.records.listIterator();
        while (listIterator.hasNext()) {
            integerArray = (Integer[])listIterator.next();
            if (!integerArray.getAcronym().equals(string)) continue;
            arrayList.add(integerArray);
        }
        if (!arrayList.isEmpty()) {
            int n;
            int n2;
            if (arrayList.size() == 1) {
                if (!((LookupTableRecord)arrayList.get(0)).getAttributes().isEmpty()) {
                    throw new IllegalStateException("When only 1 match is found that line must have the attributes fields empty");
                }
                return (LookupTableRecord)arrayList.get(0);
            }
            integerArray = new Integer[arrayList.size() - 1];
            for (n2 = 0; n2 < arrayList.size() - 1; ++n2) {
                LookupTableRecord lookupTableRecord = (LookupTableRecord)arrayList.get(n2);
                n = 0;
                boolean bl = true;
                for (Map.Entry<String, List<String>> entry : lookupTableRecord.getAttributes().entrySet()) {
                    ArrayList arrayList2 = map.get(entry.getKey()) == null ? new ArrayList() : map.get(entry.getKey()).getValue();
                    List<String> list = entry.getValue();
                    if (lookupTableRecord.getAttributes().size() > 1) {
                        if (list.equals(arrayList2) && bl) {
                            integerArray[n2] = n += list.size();
                            continue;
                        }
                        bl = false;
                        integerArray[n2] = 0;
                        continue;
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        if (i >= arrayList2.size()) {
                            integerArray[n2] = n;
                            continue;
                        }
                        if (list.get(i).equals(arrayList2.get(i)) || list.get(i).equals(" ")) {
                            if (i == 0) {
                                integerArray[n2] = ++n;
                                continue;
                            }
                            if (integerArray[n2] != i) continue;
                            integerArray[n2] = ++n;
                            continue;
                        }
                        integerArray[n2] = n;
                    }
                }
            }
            n2 = 0;
            int n3 = 0;
            for (n = 0; n < integerArray.length; ++n) {
                if (integerArray[n] <= n2 || ((LookupTableRecord)arrayList.get(n)).getAttributes().size() > 1 && integerArray[n] == 1) continue;
                n2 = integerArray[n];
                n3 = n;
            }
            return n2 == 0 ? (LookupTableRecord)arrayList.get(arrayList.size() - 1) : (LookupTableRecord)arrayList.get(n3);
        }
        return this.records.get(0);
    }
}

