/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import pt.lsts.s57.resources.entities.s52.DisplayCategory;
import pt.lsts.s57.resources.entities.s52.Instruction;
import pt.lsts.s57.resources.entities.s52.InstructionType;

public class LookupTableRecord
implements Serializable {
    private static final long serialVersionUID = -7304729963342211315L;
    private final String acronym;
    private final Map<String, List<String>> attributes = new HashMap<String, List<String>>();
    private final List<Instruction> intructions = new ArrayList<Instruction>();
    private final int priority;
    private final boolean radarFlag;
    private final DisplayCategory category;
    private final String group;
    private final boolean conditional;
    private final boolean empty;

    private LookupTableRecord(List<String> list) {
        Object object;
        String string;
        this.acronym = list.get(0);
        if (!list.get(1).isEmpty()) {
            List<String> list2 = Arrays.asList(list.get(1).split("[|]"));
            for (String object2 : list2) {
                if (object2.isEmpty()) continue;
                string = object2.substring(0, 6);
                object = Arrays.asList(object2.substring(6).split(",", -1));
                this.attributes.put(string, (List<String>)object);
            }
        }
        boolean bl = false;
        if (!list.get(2).isEmpty()) {
            List<String> list3 = Arrays.asList(list.get(2).split(";"));
            Iterator iterator = list3.iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                if (string.isEmpty()) continue;
                try {
                    object = InstructionType.valueOf(string.substring(0, 2));
                    if (!bl) {
                        bl = ((Enum)object).equals((Object)InstructionType.CS);
                    }
                    String exception = string.substring(2).replace("(", "");
                    exception = exception.replace(")", "");
                    this.intructions.add(Instruction.forge((InstructionType)((Object)object), exception));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            this.empty = false;
        } else {
            this.empty = true;
        }
        this.conditional = bl;
        this.priority = Integer.valueOf(list.get(3));
        this.radarFlag = list.get(4).equals("O");
        this.category = list.get(5).isEmpty() ? null : DisplayCategory.valueOf(list.get(5).replace(" ", "_"));
        this.group = list.size() == 7 ? list.get(6) : "";
    }

    public static LookupTableRecord forge(List<String> list) {
        return new LookupTableRecord(list);
    }

    public List<String> getAttributeValues(String string) {
        return this.attributes.get(string);
    }

    public String getAcronym() {
        return this.acronym;
    }

    public Map<String, List<String>> getAttributes() {
        return this.attributes;
    }

    public List<Instruction> getIntructions() {
        return this.intructions;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean getRadarFlag() {
        return this.radarFlag;
    }

    public DisplayCategory getCategory() {
        return this.category;
    }

    public String getCategoryString() {
        if (this.category != null) {
            return this.category.toString();
        }
        return "";
    }

    public String getGroup() {
        return this.group;
    }

    public boolean hasConditional() {
        return this.conditional;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String toString() {
        return "LookupTableRecord [acronym=" + this.acronym + ", attributes=" + this.attributes + ", intructions=" + this.intructions + ", priority=" + this.priority + ", radarFlag=" + this.radarFlag + ", category=" + (Object)((Object)this.category) + ", group=" + this.group + "]";
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.acronym == null ? 0 : this.acronym.hashCode());
        n = 31 * n + (this.attributes == null ? 0 : this.attributes.hashCode());
        n = 31 * n + (this.category == null ? 0 : this.category.hashCode());
        n = 31 * n + (this.conditional ? 1231 : 1237);
        n = 31 * n + (this.group == null ? 0 : this.group.hashCode());
        n = 31 * n + (this.intructions == null ? 0 : this.intructions.hashCode());
        n = 31 * n + this.priority;
        n = 31 * n + (this.radarFlag ? 1231 : 1237);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LookupTableRecord lookupTableRecord = (LookupTableRecord)object;
        if (this.acronym == null ? lookupTableRecord.acronym != null : !this.acronym.equals(lookupTableRecord.acronym)) {
            return false;
        }
        if (this.attributes == null ? lookupTableRecord.attributes != null : !this.attributes.equals(lookupTableRecord.attributes)) {
            return false;
        }
        if (this.category != lookupTableRecord.category) {
            return false;
        }
        if (this.conditional != lookupTableRecord.conditional) {
            return false;
        }
        if (this.group == null ? lookupTableRecord.group != null : !this.group.equals(lookupTableRecord.group)) {
            return false;
        }
        if (this.intructions == null ? lookupTableRecord.intructions != null : !this.intructions.equals(lookupTableRecord.intructions)) {
            return false;
        }
        if (this.priority != lookupTableRecord.priority) {
            return false;
        }
        return this.radarFlag == lookupTableRecord.radarFlag;
    }
}

