/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52.symbol;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.S52Color;
import pt.lsts.s57.resources.entities.s52.symbol.S52Pattern;

public class RasterPattern
extends S52Pattern
implements Serializable {
    private static final long serialVersionUID = 3236674722864911893L;
    private BufferedImage image;

    public static RasterPattern forge(String string, ColorTable colorTable) {
        return new RasterPattern(string, colorTable);
    }

    private RasterPattern(String string, ColorTable colorTable) {
        String[] stringArray;
        this.colortable = colorTable;
        for (String string2 : stringArray = string.split(System.getProperty("line.separator"))) {
            if (string2.startsWith("****")) continue;
            String string3 = string2.substring(0, 4).trim();
            String string4 = string2.substring(9).trim();
            if (string3.equals("PATT")) {
                // empty if block
            }
            if (string3.equals("PATD")) {
                this.code = string4.substring(0, 8);
                this.symbolType = string4.charAt(8);
                this.fill = string4.substring(9, 12);
                this.spacing = string4.substring(12, 15);
                this.minDistance = Integer.parseInt(string4.substring(15, 20));
                this.maxDistance = Integer.parseInt(string4.substring(20, 25));
                this.offsetX = Integer.parseInt(string4.substring(25, 30));
                this.offsetY = Integer.parseInt(string4.substring(30, 35));
                this.width = Integer.parseInt(string4.substring(35, 40));
                this.height = Integer.parseInt(string4.substring(40, 45));
                this.hotspotX = Integer.parseInt(string4.substring(45, 50));
                this.hotspotY = Integer.parseInt(string4.substring(50, 55));
            }
            if (string3.equals("PXPO")) {
                this.description = string4;
            }
            if (string3.equals("PCRF")) {
                while (string4.length() > 0) {
                    try {
                        this.colors.put(Character.valueOf(string4.charAt(0)), this.colortable.get(string4.substring(1, 6)));
                    }
                    catch (Exception exception) {
                        System.out.println("Symbol " + this.code + ". The color " + string4.substring(1, 6) + " doesnt exist.");
                    }
                    string4 = string4.substring(6);
                }
            }
            if (!string3.equals("PBTM")) continue;
            this.addLine(string4);
        }
    }

    @Override
    public BufferedImage get(StateRenderer2D stateRenderer2D, MarinerControls marinerControls) {
        ColorScheme colorScheme = marinerControls.getColorScheme();
        if (colorScheme != this.lastColorScheme) {
            this.lastColorScheme = colorScheme;
            this.image = new BufferedImage(this.width, this.height, 2);
            Color color = new Color(0, 0, 0, 0);
            int n = 0;
            for (char c : this.symbolData.toString().replaceAll("[\\r\\n]", "").toCharArray()) {
                if (c == '@') {
                    this.image.setRGB(n % this.width, n / this.width, color.getRGB());
                } else {
                    this.image.setRGB(n % this.width, n / this.width, ((S52Color)this.colors.get(Character.valueOf(c))).get(marinerControls.getColorScheme()).getRGB());
                }
                ++n;
            }
        }
        return this.image;
    }
}

