/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52.symbol;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.S52Color;
import pt.lsts.s57.resources.entities.s52.symbol.S52Symbol;

public class RasterSymbol
extends S52Symbol
implements Serializable {
    private static final long serialVersionUID = -8056279790704240873L;
    private BufferedImage image;

    public static RasterSymbol forge(String string, ColorTable colorTable) {
        return new RasterSymbol(string, colorTable);
    }

    private RasterSymbol(String string, ColorTable colorTable) {
        String[] stringArray;
        this.colortable = colorTable;
        for (String string2 : stringArray = string.split(System.getProperty("line.separator"))) {
            if (string2.startsWith("****")) continue;
            String string3 = string2.substring(0, 4).trim();
            String string4 = string2.substring(9).trim();
            if (string3.equals("SYMB")) {
                // empty if block
            }
            if (string3.equals("SYMD")) {
                this.code = string4.substring(0, 8);
                this.symbolType = string4.charAt(8);
                this.offsetX = Integer.parseInt(string4.substring(9, 14));
                this.offsetY = Integer.parseInt(string4.substring(14, 19));
                this.width = Integer.parseInt(string4.substring(19, 24));
                this.height = Integer.parseInt(string4.substring(24, 29));
                this.hotspotX = Integer.parseInt(string4.substring(29, 34));
                this.hotspotY = Integer.parseInt(string4.substring(34, 39));
            }
            if (string3.equals("SXPO")) {
                this.description = string4;
            }
            if (string3.equals("SCRF")) {
                while (string4.length() > 0) {
                    try {
                        this.colors.put(Character.valueOf(string4.charAt(0)), this.colortable.get(string4.substring(1, 6)));
                    }
                    catch (Exception exception) {
                        System.out.println("Symbol " + this.code + ". The color " + string4.substring(1, 6) + " doesnt exist.");
                    }
                    string4 = string4.substring(6);
                }
            }
            if (!string3.equals("SBTM")) continue;
            this.addLine(string4);
        }
    }

    @Override
    public BufferedImage get(StateRenderer2D stateRenderer2D, MarinerControls marinerControls, float f) {
        ColorScheme colorScheme = marinerControls.getColorScheme();
        if (colorScheme != this.lastColorScheme) {
            this.lastColorScheme = colorScheme;
            this.image = new BufferedImage(this.width, this.height, 2);
            Color color = new Color(0, 0, 0, 0);
            int n = 0;
            for (char c : this.symbolData.toString().replaceAll("[\\r\\n]", "").toCharArray()) {
                if (c == '@') {
                    this.image.setRGB(n % this.width, n / this.width, color.getRGB());
                } else {
                    this.image.setRGB(n % this.width, n / this.width, ((S52Color)this.colors.get(Character.valueOf(c))).get(marinerControls.getColorScheme()).getRGB());
                }
                ++n;
            }
        }
        return this.image;
    }
}

