/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52.symbol;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import org.apache.commons.lang.text.StrBuilder;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.symbol.RasterPattern;
import pt.lsts.s57.resources.entities.s52.symbol.RasterSymbol;
import pt.lsts.s57.resources.entities.s52.symbol.S52Pattern;
import pt.lsts.s57.resources.entities.s52.symbol.S52Symbol;
import pt.lsts.s57.resources.entities.s52.symbol.VectorLine;
import pt.lsts.s57.resources.entities.s52.symbol.VectorPattern;
import pt.lsts.s57.resources.entities.s52.symbol.VectorSymbol;

public class Symbols
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, S52Pattern> pattern = new HashMap<String, S52Pattern>();
    private final Map<String, S52Pattern> vPattern = new HashMap<String, S52Pattern>();
    private final Map<String, S52Symbol> raster = new HashMap<String, S52Symbol>();
    private final Map<String, S52Symbol> symbol = new HashMap<String, S52Symbol>();
    private final Map<String, S52Symbol> lines = new HashMap<String, S52Symbol>();
    private final ColorTable colorTable;

    public static Symbols forge(Configuration configuration, ColorTable colorTable) {
        return new Symbols(configuration, colorTable);
    }

    private Symbols(Configuration configuration, ColorTable colorTable) {
        this.colorTable = colorTable;
        String string = configuration.getString("s52.symbols.raster");
        String string2 = configuration.getString("s52.symbols.vector");
        String[] stringArray = new String[]{string, string2};
        try {
            this.read(stringArray);
        }
        catch (IOException iOException) {
            System.out.println("IOException : " + iOException.getMessage());
        }
    }

    public S52Symbol getSymbol(String string) {
        if (this.raster.get(string) != null) {
            return this.raster.get(string);
        }
        if (this.symbol.get(string) != null) {
            return this.symbol.get(string);
        }
        throw new IllegalArgumentException("Symbol with code " + string + " doesnt exist!");
    }

    public S52Pattern getPattern(String string) {
        if (this.pattern.get(string) != null) {
            return this.pattern.get(string);
        }
        if (this.vPattern.get(string) != null) {
            return this.vPattern.get(string);
        }
        throw new IllegalArgumentException("Pattern with code " + string + " doesnt exist!");
    }

    public S52Symbol getLine(String string) {
        S52Symbol s52Symbol = this.lines.get(string);
        if (s52Symbol != null) {
            return s52Symbol;
        }
        throw new IllegalArgumentException("Line with code " + string + " doesnt exist!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String[] stringArray) throws IOException {
        for (String string : stringArray) {
            File file = new File(string);
            LineIterator lineIterator = FileUtils.lineIterator(file, "UTF-8");
            StrBuilder strBuilder = new StrBuilder();
            try {
                while (lineIterator.hasNext()) {
                    String string2 = lineIterator.nextLine();
                    if ((string2 = this.prepare(string2)).trim().isEmpty()) continue;
                    if (string2.startsWith("0001")) {
                        strBuilder.clear();
                    }
                    strBuilder.appendln(string2);
                    if (!string2.startsWith("****")) continue;
                    if (this.IsBitmap(strBuilder.toString())) {
                        this.mergeBimaps(strBuilder.toString());
                    }
                    if (!this.IsVector(strBuilder.toString())) continue;
                    this.mergeVectors(strBuilder.toString());
                }
            }
            finally {
                LineIterator.closeQuietly(lineIterator);
            }
        }
    }

    private void mergeBimaps(String string) {
        Serializable serializable;
        String[] stringArray = string.split("0001" + System.getProperty("line.separator"));
        String string2 = stringArray[1].trim();
        if (this.IsBitmapSymbol(string2)) {
            serializable = RasterSymbol.forge(string2, this.colorTable);
            this.raster.put(((S52Symbol)((Object)serializable)).getCode(), (S52Symbol)((Object)serializable));
        }
        if (this.IsBitmapPattern(string2)) {
            serializable = RasterPattern.forge(string2, this.colorTable);
            this.pattern.put(((S52Pattern)((Object)serializable)).getCode(), (S52Pattern)((Object)serializable));
        }
    }

    private void mergeVectors(String string) {
        Serializable serializable;
        String[] stringArray = string.split("0001" + System.getProperty("line.separator"));
        String string2 = stringArray[1].trim();
        if (this.IsVectorSymbol(string2) && ((VectorSymbol)(serializable = VectorSymbol.forge(string2, this.colorTable))).isValid()) {
            this.symbol.put(((S52Symbol)((Object)serializable)).getCode(), (S52Symbol)((Object)serializable));
        }
        if (this.IsVectorPattern(string2) && ((VectorPattern)(serializable = VectorPattern.forge(string2, this.colorTable))).isValid()) {
            this.vPattern.put(((S52Pattern)((Object)serializable)).getCode(), (S52Pattern)((Object)serializable));
        }
        if (this.IsVectorLine(string2) && ((VectorLine)(serializable = VectorLine.forge(string2, this.colorTable))).isValid()) {
            this.lines.put(((S52Symbol)((Object)serializable)).getCode(), (S52Symbol)((Object)serializable));
        }
    }

    private String prepare(String string) {
        string = string.replace(String.valueOf('\u001f'), " ");
        return string;
    }

    private boolean IsBitmap(String string) {
        return string.contains("SBTM") || string.contains("PBTM");
    }

    private boolean IsBitmapSymbol(String string) {
        return string.contains("SBTM");
    }

    private boolean IsBitmapPattern(String string) {
        return string.contains("PBTM");
    }

    private boolean IsVector(String string) {
        return string.contains("LVCT") || string.contains("PVCT") || string.contains("SVCT");
    }

    private boolean IsVectorSymbol(String string) {
        return string.contains("SVCT");
    }

    private boolean IsVectorPattern(String string) {
        return string.contains("PVCT");
    }

    private boolean IsVectorLine(String string) {
        return string.contains("LVCT");
    }
}

