/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.resources.entities.s52.symbol;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.entities.s52.ColorTable;
import pt.lsts.s57.resources.entities.s52.S52Color;
import pt.lsts.s57.resources.entities.s52.symbol.S52Symbol;
import pt.lsts.s57.s52.SymbologyProcess;

public class VectorLine
extends S52Symbol
implements Serializable {
    private static final long serialVersionUID = 6670436344973452718L;
    private boolean valid = true;
    private double reduction = 1.0;

    public static VectorLine forge(String string, ColorTable colorTable) {
        return new VectorLine(string, colorTable);
    }

    private VectorLine(String string, ColorTable colorTable) {
        String[] stringArray;
        this.colortable = colorTable;
        for (String string2 : stringArray = string.split(System.getProperty("line.separator"))) {
            if (string2.startsWith("****")) continue;
            String string3 = string2.substring(0, 4).trim();
            String string4 = string2.substring(9).trim();
            if (string3.equals("LNST")) {
                // empty if block
            }
            if (string3.equals("LIND")) {
                this.code = string4.substring(0, 8);
                this.symbolType = string4.charAt(8);
                this.offsetX = Integer.parseInt(string4.substring(8, 13));
                this.offsetY = Integer.parseInt(string4.substring(13, 18));
                this.width = Integer.parseInt(string4.substring(18, 23));
                this.height = Integer.parseInt(string4.substring(23, 28));
                this.hotspotX = Integer.parseInt(string4.substring(28, 33));
                this.hotspotY = Integer.parseInt(string4.substring(33, 38));
                this.offsetX = (int)SymbologyProcess.units2px(this.offsetX, null);
                this.offsetY = (int)SymbologyProcess.units2px(this.offsetY, null);
                this.width = (int)(SymbologyProcess.units2px(this.width, null) + 1.0);
                this.height = (int)(SymbologyProcess.units2px(this.height, null) + 1.0);
                this.hotspotX = (int)SymbologyProcess.units2px(this.hotspotX, null);
                this.hotspotY = (int)SymbologyProcess.units2px(this.hotspotY, null);
                this.offsetX = this.offsetX < 0 ? this.offsetX + this.hotspotX : this.offsetX - this.hotspotX;
                int n = this.offsetY = this.offsetY < 0 ? this.offsetY + this.hotspotY : this.offsetY - this.hotspotY;
            }
            if (string3.equals("LXPO")) {
                this.description = string4;
            }
            if (string3.equals("LCRF")) {
                while (string4.length() > 0) {
                    try {
                        this.colors.put(Character.valueOf(string4.charAt(0)), this.colortable.get(string4.substring(1, 6)));
                    }
                    catch (Exception exception) {
                        this.valid = false;
                        System.out.println("Symbol " + this.code + ". The color " + string4.substring(1, 6) + " doesnt exist.");
                    }
                    string4 = string4.substring(6);
                }
            }
            if (!string3.equals("LVCT")) continue;
            this.addLine(string4);
        }
    }

    @Override
    public BufferedImage get(StateRenderer2D stateRenderer2D, MarinerControls marinerControls, float f) {
        String[] stringArray = this.symbolData.toString().replaceAll("[\\r\\n]", "").split(";");
        BufferedImage bufferedImage = new BufferedImage(this.width, this.height, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        Color color = new Color(0, 0, 0);
        double d = 0.0;
        Polygon polygon = new Polygon();
        boolean bl = false;
        for (String string : stringArray) {
            double d2;
            double d3;
            int n;
            String[] stringArray2;
            if (string.length() < 2) continue;
            String string2 = string.substring(0, 2);
            if (string2.equals("SP")) {
                color = ((S52Color)this.colors.get(Character.valueOf(string.charAt(2)))).get(marinerControls.getColorScheme());
                continue;
            }
            if (string2.equals("SW")) {
                d = (double)Integer.valueOf(String.valueOf(string.charAt(2))).intValue() * 0.3;
                d = d / (double)25.4f * (double)Toolkit.getDefaultToolkit().getScreenResolution();
                d /= this.reduction;
                continue;
            }
            if (string2.equals("ST")) continue;
            if (string2.equals("PU")) {
                stringArray2 = string.substring(2).split(",");
                for (n = 0; n < stringArray2.length / 2; ++n) {
                    d3 = SymbologyProcess.units2px(Integer.valueOf(stringArray2[2 * n]).intValue(), stateRenderer2D) - (double)this.hotspotX;
                    d2 = SymbologyProcess.units2px(Integer.valueOf(stringArray2[2 * n + 1]).intValue(), stateRenderer2D) - (double)this.hotspotY;
                    ((Point2D)double_).setLocation(d3 / this.reduction, d2 / this.reduction);
                    if (!bl) continue;
                    polygon.addPoint((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
                }
                continue;
            }
            if (string2.equals("PD")) {
                if (string.length() > 2) {
                    stringArray2 = string.substring(2).split(",");
                    for (n = 0; n < stringArray2.length / 2; ++n) {
                        d3 = SymbologyProcess.units2px(Integer.valueOf(stringArray2[2 * n]).intValue(), stateRenderer2D) - (double)this.hotspotX;
                        d2 = SymbologyProcess.units2px(Integer.valueOf(stringArray2[2 * n + 1]).intValue(), stateRenderer2D) - (double)this.hotspotY;
                        ((Point2D)double_2).setLocation(d3 / this.reduction, d2 / this.reduction);
                        graphics2D.setColor(color);
                        graphics2D.setStroke(new BasicStroke((float)d, 1, 1));
                        graphics2D.draw(new Line2D.Double(double_, double_2));
                        graphics2D.fill(new Line2D.Double(double_, double_2));
                        double_.setLocation(double_2);
                        if (!bl) continue;
                        polygon.addPoint((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
                    }
                    continue;
                }
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke((float)d));
                graphics2D.drawOval((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY(), 1, 1);
                continue;
            }
            if (string2.equals("CI")) {
                n = (int)SymbologyProcess.units2px(Integer.valueOf(string.substring(2)).intValue(), stateRenderer2D);
                n = (int)((double)n / this.reduction);
                if (bl) {
                    graphics2D.setColor(color);
                    graphics2D.fill(new Ellipse2D.Double(((Point2D)double_).getX() - (double)n, ((Point2D)double_).getY() - (double)n, n * 2, n * 2));
                    continue;
                }
                graphics2D.setColor(color);
                graphics2D.setStroke(new BasicStroke((float)d));
                graphics2D.draw(new Ellipse2D.Double(((Point2D)double_).getX() - (double)n, ((Point2D)double_).getY() - (double)n, n * 2, n * 2));
                continue;
            }
            if (string2.equals("PM")) {
                boolean bl2 = bl = !bl;
                if (!bl) continue;
                polygon.addPoint((int)((Point2D)double_).getX(), (int)((Point2D)double_).getY());
                continue;
            }
            if (string2.equals("FP")) {
                if (polygon.npoints <= 0) continue;
                graphics2D.setColor(color);
                graphics2D.fill(polygon);
                polygon.reset();
                continue;
            }
            System.out.println("command " + string2 + " unknown- > " + string);
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    protected boolean isValid() {
        if (this.code.length() != 8) {
            this.valid = false;
            System.out.println("vector discarded code invalid " + this.toString());
        }
        if (this.colors.size() < 1) {
            this.valid = false;
            System.out.println("vector discarded no color " + this.toString());
        }
        if (this.height < 1 || this.width < 1) {
            this.valid = false;
            System.out.println("vector discarded height or width <1  " + this.toString());
        }
        return this.valid;
    }
}

