/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.s52;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedString;
import java.util.List;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.s57.entities.S57Attribute;
import pt.lsts.s57.entities.S57Object;
import pt.lsts.s57.entities.S57ObjectPainter;
import pt.lsts.s57.entities.geometry.S57GeometryType;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.Resources;
import pt.lsts.s57.resources.entities.s52.Instruction;
import pt.lsts.s57.resources.entities.s52.symbol.S52Pattern;
import pt.lsts.s57.resources.entities.s52.symbol.S52Symbol;

public class SymbologyProcess {
    public static double CONV_INCH_2_MILIMETERS = 25.4;
    public static double DPI = Toolkit.getDefaultToolkit().getScreenResolution();
    private static final float DASH_LENGTH = (float)(0.1417322855931723 * DPI);
    private static final float DOTT_LENGTH = (float)(0.023622047598862047 * DPI);
    private static final float DASH_SPACE = (float)(0.07086614279658615 * DPI);
    private static final float DOTT_SPACE = (float)(0.047244095197724094 * DPI);

    public static double units2px(double d, StateRenderer2D stateRenderer2D) {
        return d * 0.01 / (double)25.4f * DPI;
    }

    public static double mm2px(double d, StateRenderer2D stateRenderer2D) {
        return d / (double)25.4f * DPI;
    }

    public static void process(List<Instruction> list, S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Resources resources, MarinerControls marinerControls) {
        for (Instruction instruction : list) {
            SymbologyProcess.process(instruction, s57ObjectPainter, graphics2D, stateRenderer2D, resources, marinerControls);
        }
    }

    public static void process(Instruction instruction, S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Resources resources, MarinerControls marinerControls) {
        switch (instruction.getType()) {
            case TX: {
                SymbologyProcess.TX(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
            case TE: {
                SymbologyProcess.TE(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
            case SY: {
                SymbologyProcess.SY(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
            case LS: {
                SymbologyProcess.LS(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
            case LC: {
                SymbologyProcess.LC(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
            case AC: {
                SymbologyProcess.AC(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
            case AP: {
                SymbologyProcess.AP(s57ObjectPainter, graphics2D, stateRenderer2D, instruction, resources, marinerControls);
                return;
            }
        }
        System.out.println(s57ObjectPainter.getObject().toStringLup(marinerControls));
        throw new IllegalArgumentException("Invalid symbology " + (Object)((Object)instruction.getType()));
    }

    private static void TX(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        List<String> list = instruction.getParams();
        String string = list.get(0);
        String string2 = list.get(4).replace("'", "");
        int n = Integer.parseInt(string2.substring(1, 2));
        double d = Integer.parseInt(string2.substring(3));
        double d2 = d * 0.01 / (double)25.4f * DPI;
        float f = (float)((double)Integer.valueOf(list.get(5)).intValue() * d2);
        float f2 = (float)((double)Integer.parseInt(list.get(6)) * d2);
        Color color = resources.getColor(list.get(7), marinerControls.getColorScheme());
        int n2 = Integer.parseInt(list.get(8));
        if (n2 != 10 && n2 != 20 && n2 != 21 && n2 != 25) {
            return;
        }
        if (n2 == 10 && !marinerControls.isShowImportantText()) {
            return;
        }
        if (n2 == 20 && !marinerControls.isShowOtherText()) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        S57Object s57Object = s57ObjectPainter.getObject();
        Point2D point2D = stateRenderer2D.getScreenPosition(s57Object.getGeometry().getCenter());
        graphics2D2.translate(point2D.getX(), point2D.getY() - 15.0);
        S57Attribute s57Attribute = s57ObjectPainter.getAttribute(string);
        String string3 = s57Attribute.getAttributeType();
        String string4 = string3.equals("L") || string3.equals("E") ? s57Attribute.getMeaning() : s57Attribute.getValue().get(0);
        if (string4 != null && !"".equalsIgnoreCase(string4)) {
            AttributedString attributedString = new AttributedString(string4);
            attributedString.addAttribute(TextAttribute.SIZE, d);
            attributedString.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
            if (n == 4) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            }
            if (n == 5) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM);
            }
            if (n == 6) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D2.getFontRenderContext());
            graphics2D2.setColor(color);
            textLayout.draw(graphics2D2, 0.0f + f, 0.0f + f2);
        }
        graphics2D2.dispose();
    }

    private static void TE(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        List<String> list = instruction.getParams();
        String string = list.get(0).replace("'", "");
        String string2 = list.get(1).replace("'", "");
        String string3 = list.get(5).replace("'", "");
        int n = Integer.parseInt(string3.substring(1, 2));
        double d = Integer.parseInt(string3.substring(3, 5));
        double d2 = d * 0.351 / (double)25.4f * DPI;
        float f = (float)((double)Integer.valueOf(list.get(6)).intValue() * d2);
        float f2 = (float)((double)Integer.parseInt(list.get(7)) * d2);
        Color color = resources.getColor(list.get(8), marinerControls.getColorScheme());
        int n2 = Integer.parseInt(list.get(9));
        if (n2 != 10 && n2 != 20 && n2 != 21 && n2 != 25) {
            return;
        }
        if (n2 == 10 && !marinerControls.isShowImportantText()) {
            return;
        }
        if (n2 == 20 && !marinerControls.isShowOtherText()) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        S57Object s57Object = s57ObjectPainter.getObject();
        Point2D point2D = stateRenderer2D.getScreenPosition(s57Object.getGeometry().getCenter());
        graphics2D2.translate(point2D.getX(), point2D.getY() - 15.0);
        S57Attribute s57Attribute = s57ObjectPainter.getAttribute(string2);
        String string4 = s57Attribute.getAttributeType();
        string2 = string4.equals("L") || string4.equals("E") ? s57Attribute.getMeaning() : s57Attribute.getValue().get(0);
        int n3 = string.indexOf("%");
        String string5 = string.substring(0, n3).concat(string2);
        if (string2 != null && !"".equalsIgnoreCase(string2)) {
            AttributedString attributedString = new AttributedString(string5);
            attributedString.addAttribute(TextAttribute.SIZE, d);
            attributedString.addAttribute(TextAttribute.WIDTH, TextAttribute.WIDTH_REGULAR);
            if (n == 4) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_LIGHT);
            }
            if (n == 5) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_MEDIUM);
            }
            if (n == 6) {
                attributedString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
            }
            TextLayout textLayout = new TextLayout(attributedString.getIterator(), graphics2D2.getFontRenderContext());
            graphics2D2.setColor(color);
            textLayout.draw(graphics2D2, 0.0f + f, 0.0f + f2);
        }
        graphics2D2.dispose();
    }

    private static void AC(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        Color color;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Point2D point2D = stateRenderer2D.getScreenPosition(s57ObjectPainter.getObject().getGeometry().getLocation());
        graphics2D2.translate(point2D.getX(), point2D.getY());
        double d = Math.pow(2.0, stateRenderer2D.getLevelOfDetail() - 22);
        graphics2D2.scale(d, d);
        List<String> list = instruction.getParams();
        Color color2 = resources.getColor(instruction.getParams().get(0), marinerControls.getColorScheme());
        if (list.size() == 2 && !list.get(1).isEmpty()) {
            double d2 = Double.valueOf(list.get(1)) * 0.25;
            color = new Color(color2.getRed(), color2.getGreen(), color2.getBlue(), (int)(255.0 * d2));
        } else {
            color = color2;
        }
        Shape shape = s57ObjectPainter.getObject().getShape();
        graphics2D2.setColor(color);
        graphics2D2.rotate(-stateRenderer2D.getRotation());
        graphics2D2.fill(shape);
        graphics2D2.dispose();
    }

    private static void LS(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        Object object;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Point2D point2D = stateRenderer2D.getScreenPosition(s57ObjectPainter.getObject().getGeometry().getLocation());
        graphics2D2.translate(point2D.getX(), point2D.getY());
        float f = (float)Math.pow(2.0, stateRenderer2D.getLevelOfDetail() - 22);
        graphics2D2.scale(f, f);
        List<String> list = instruction.getParams();
        Stroke stroke = null;
        String string = list.get(0);
        float f2 = (float)((double)Float.parseFloat(list.get(1)) * 0.32 / (double)25.4f * DPI);
        LocationType locationType = stateRenderer2D.getRealWorldLocation((Point2D)new Point2D.Double(0.0, 0.0));
        LocationType locationType2 = stateRenderer2D.getRealWorldLocation((Point2D)new Point2D.Double(stateRenderer2D.getWidth() - 1, stateRenderer2D.getHeight() - 1));
        if (s57ObjectPainter.getObject().getGeoType() == S57GeometryType.AREA && string.equals("DASH")) {
            object = new Path2D.Double();
            Point2D.Double double_ = s57ObjectPainter.getObject().getGeometry().getList().get(0).get(0);
            ((Path2D.Double)object).moveTo(double_.getX(), double_.getY());
            for (Point2D.Double double_2 : s57ObjectPainter.getObject().getGeometry().getList().get(0)) {
                ((Path2D.Double)object).lineTo(double_2.getX(), double_2.getY());
            }
            Rectangle2D rectangle2D = ((Path2D.Double)object).getBounds2D();
            if (rectangle2D.contains(locationType.getLatitudeDegs(), locationType.getLongitudeDegs()) && rectangle2D.contains(locationType2.getLatitudeDegs(), locationType2.getLongitudeDegs())) {
                return;
            }
        }
        if (string.equals("SOLD")) {
            stroke = new BasicStroke(f2, 1, 1);
        } else if (string.equals("DASH")) {
            object = new float[]{DASH_LENGTH / f, DASH_SPACE / f};
            stroke = new BasicStroke(f2, 1, 1, 10.0f, (float[])object, 0.0f);
        } else if (string.equals("DOTT")) {
            object = new float[]{DOTT_LENGTH / f, DOTT_SPACE / f};
            stroke = new BasicStroke(f2, 1, 1, 10.0f, (float[])object, 0.0f);
        } else {
            System.out.println("Unexpected stroke option: " + instruction.getParams().get(0));
            stroke = graphics2D2.getStroke();
        }
        graphics2D2.setStroke(stroke);
        graphics2D2.setColor(resources.getColor(list.get(2), marinerControls.getColorScheme()));
        graphics2D2.rotate(-stateRenderer2D.getRotation());
        graphics2D2.draw(s57ObjectPainter.getObject().getShape());
        graphics2D2.dispose();
    }

    private static void AP(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        Object object;
        S52Pattern s52Pattern;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        Point2D point2D = stateRenderer2D.getScreenPosition(s57ObjectPainter.getObject().getGeometry().getLocation());
        graphics2D2.translate(point2D.getX(), point2D.getY());
        double d = Math.pow(2.0, stateRenderer2D.getLevelOfDetail() - 22);
        graphics2D2.scale(d, d);
        List<String> list = instruction.getParams();
        String string = list.get(0);
        try {
            s52Pattern = resources.getPattern(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
        BufferedImage bufferedImage = s52Pattern.get(stateRenderer2D, marinerControls);
        String string2 = s52Pattern.getFill();
        String string3 = s52Pattern.getSpacing();
        int n = (int)SymbologyProcess.units2px(s52Pattern.getMinDistance(), stateRenderer2D);
        int n2 = (int)SymbologyProcess.units2px(s52Pattern.getMaxDistance(), stateRenderer2D);
        int n3 = 0;
        if (string3.equals("CON")) {
            n3 = (int)SymbologyProcess.units2px(s52Pattern.getMinDistance(), stateRenderer2D);
        }
        if (string3.equals("SCL")) {
            n3 = n2 - n;
            if (n3 < n) {
                n3 = n;
            }
            if (n3 > n2) {
                n3 = n2;
            }
        }
        BufferedImage bufferedImage2 = null;
        if (string2.equals("LIN")) {
            bufferedImage2 = new BufferedImage(s52Pattern.getWidth() + n3, s52Pattern.getHeight() + n3, 2);
            object = bufferedImage2.createGraphics();
            ((Graphics2D)object).drawImage(bufferedImage, null, n3 / 2, n3 / 2);
            ((Graphics)object).dispose();
        }
        if (string2.equals("STG")) {
            bufferedImage2 = new BufferedImage(s52Pattern.getWidth() + n3, s52Pattern.getHeight() + n3, 2);
            object = bufferedImage2.createGraphics();
            ((Graphics2D)object).drawImage(bufferedImage, null, n3 / 2, n3 / 2);
            ((Graphics)object).dispose();
        }
        object = new TexturePaint(bufferedImage2, new Rectangle(0, 0, (int)((double)bufferedImage2.getWidth() / d), (int)((double)bufferedImage2.getHeight() / d)));
        graphics2D2.setPaint((Paint)object);
        graphics2D2.rotate(-stateRenderer2D.getRotation());
        graphics2D2.fill(s57ObjectPainter.getObject().getShape());
        graphics2D2.dispose();
    }

    private static void SY(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        Point2D point2D;
        S52Symbol s52Symbol;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        S57Object s57Object = s57ObjectPainter.getObject();
        List<String> list = instruction.getParams();
        String string = list.get(0);
        try {
            s52Symbol = resources.getSymbol(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
        if (s57Object.getGeoType() == S57GeometryType.AREA) {
            point2D = stateRenderer2D.getScreenPosition(s57Object.getGeometry().getCenter());
            graphics2D2.translate(point2D.getX(), point2D.getY());
        } else {
            point2D = stateRenderer2D.getScreenPosition(s57Object.getGeometry().getLocation());
            graphics2D2.translate(point2D.getX(), point2D.getY());
        }
        double d = 0.0;
        if (list.size() == 2 && !list.get(1).isEmpty()) {
            String string2 = list.get(1).replace("ORIENT", "");
            if (s57Object.getAttribute("ORIENT").isEmpty() || s57Object.getAttribute("ORIENT") == null) {
                if (!string2.isEmpty()) {
                    d = Double.valueOf(string2);
                }
            } else {
                d = Double.valueOf(s57ObjectPainter.getAttribute("ORIENT").getValue().get(0));
            }
            try {
                graphics2D2.rotate(Math.toRadians(d));
            }
            catch (Exception exception) {
                System.out.println("SY intruction rotation error");
            }
        }
        graphics2D2.drawImage(s52Symbol.get(stateRenderer2D, marinerControls, 0.0f), -s52Symbol.getOffsetX(), -s52Symbol.getOffsetY(), s52Symbol.getWidth(), s52Symbol.getHeight(), null);
        graphics2D2.dispose();
    }

    private static void LC(S57ObjectPainter s57ObjectPainter, Graphics2D graphics2D, StateRenderer2D stateRenderer2D, Instruction instruction, Resources resources, MarinerControls marinerControls) {
        S52Symbol s52Symbol;
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create();
        S57Object s57Object = s57ObjectPainter.getObject();
        Shape shape = s57Object.getShape();
        Point2D point2D = stateRenderer2D.getScreenPosition(s57Object.getGeometry().getLocation());
        graphics2D2.translate(point2D.getX(), point2D.getY());
        graphics2D2.rotate(-stateRenderer2D.getRotation());
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        graphics2D2.addRenderingHints(renderingHints);
        double d = Math.pow(2.0, stateRenderer2D.getLevelOfDetail() - 22);
        String string = instruction.getParams().get(0);
        try {
            s52Symbol = resources.getLine(string);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            return;
        }
        BufferedImage bufferedImage = s52Symbol.get(stateRenderer2D, marinerControls, 0.0f);
        float f = s52Symbol.getWidth();
        Color color = s52Symbol.getColor(marinerControls);
        FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(null), 1.0);
        float[] fArray = new float[6];
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n = 0;
        float f6 = 0.0f;
        int n2 = 0;
        int n3 = 1;
        while (n2 < n3 && !flatteningPathIterator.isDone()) {
            n = flatteningPathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    f2 = (float)((double)fArray[0] * d);
                    f3 = (float)((double)fArray[1] * d);
                    f6 = 0.0f;
                    break;
                }
                case 4: {
                    break;
                }
                case 1: {
                    float f7;
                    float f8;
                    float f9;
                    f4 = (float)((double)fArray[0] * d);
                    f5 = (float)((double)fArray[1] * d);
                    if (f4 == f2 && f5 == f3) break;
                    float f10 = f4 - f2;
                    float f11 = f5 - f3;
                    float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
                    if (f12 >= f) {
                        f9 = 1.0f / f12;
                        f8 = (float)Math.atan2(f11, f10);
                        f8 = (float)(Math.PI + (double)f8);
                        while (n2 < n3 && f12 >= f6) {
                            f7 = f2 + f6 * f10 * f9;
                            float f13 = f3 + f6 * f11 * f9;
                            if (f12 >= f6 + f) {
                                Graphics2D graphics2D3 = (Graphics2D)graphics2D2.create();
                                graphics2D3.translate(f7, f13);
                                graphics2D3.rotate(f8);
                                graphics2D3.drawImage(bufferedImage, null, -s52Symbol.getWidth() - s52Symbol.getOffsetX(), -s52Symbol.getOffsetY());
                                graphics2D3.dispose();
                            } else {
                                graphics2D2.setColor(color);
                                graphics2D2.drawLine((int)f4, (int)f5, (int)f7, (int)f13);
                            }
                            f6 += f;
                            ++n2;
                            n2 %= n3;
                        }
                    } else {
                        f9 = 1.0f / f12;
                        f8 = f2 + f6 * f10 * f9;
                        f7 = f3 + f6 * f11 * f9;
                        graphics2D2.setColor(color);
                        graphics2D2.drawLine((int)f4, (int)f5, (int)f8, (int)f7);
                    }
                    f6 = 0.0f;
                    f2 = f4;
                    f3 = f5;
                }
            }
            flatteningPathIterator.next();
        }
        graphics2D2.dispose();
    }
}

