/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import pt.lsts.s57.mc.MarinerControls;
import pt.lsts.s57.resources.entities.s52.ColorScheme;
import pt.lsts.s57.resources.entities.s52.DisplayCategory;
import pt.lsts.s57.resources.entities.s52.LookupTableType;
import pt.lsts.s57.ui.OptionsDialog;
import pt.lsts.s57.ui.OptionsPanel;

public class MarinerControlsOptionsPanel
extends JPanel
implements ItemListener,
OptionsPanel {
    private static final long serialVersionUID = 6304636551721739773L;
    private MarinerControls mc;
    private OptionsDialog parent;
    private JComboBox<String> pointStyle;
    private JTextField safety;
    private JTextField deep;
    private JTextField shallow;
    private JComboBox<String> areaStyle;
    private JComboBox<String> colorScheme;
    private JComboBox<String> displayCat;
    private JCheckBox scaleFilter;
    private JCheckBox showText;
    private JCheckBox soundings;
    private JCheckBox otherText;

    public MarinerControlsOptionsPanel(final MarinerControls marinerControls, final OptionsDialog optionsDialog) {
        this.mc = marinerControls;
        this.parent = optionsDialog;
        this.setLayout(new BorderLayout(0, 0));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new MigLayout("", "[100px,left][100px,fill]", "[20px][20px][20px][20px][20px][20px][][20px][][23px][23px][23px][][23px][][]"));
        this.add((Component)jPanel, "Center");
        this.pointStyle = new JComboBox();
        this.pointStyle.addItemListener(this);
        this.pointStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"PAPER_CHART", "SIMPLIFIED"}));
        this.pointStyle.setSelectedItem(marinerControls.getPointStyle().toString());
        jPanel.add(this.pointStyle, "cell 1 0,alignx left");
        JLabel jLabel = new JLabel("Point Style");
        jLabel.setLabelFor(this.pointStyle);
        jPanel.add((Component)jLabel, "cell 0 0,alignx left,aligny center");
        this.areaStyle = new JComboBox();
        this.areaStyle.setModel(new DefaultComboBoxModel<String>(new String[]{LookupTableType.PLAIN_BOUNDARIES.toString(), LookupTableType.SYMBOLIZED_BOUNDARIES.toString()}));
        this.areaStyle.setSelectedItem(marinerControls.getAreaStyle().toString());
        this.areaStyle.addItemListener(this);
        jPanel.add(this.areaStyle, "cell 1 1");
        JLabel jLabel2 = new JLabel("Area Style");
        jLabel2.setLabelFor(this.areaStyle);
        jPanel.add((Component)jLabel2, "cell 0 1,alignx left,aligny center");
        this.colorScheme = new JComboBox();
        this.colorScheme.setModel(new DefaultComboBoxModel<String>(new String[]{"DUSK", "NIGHT", "DAY_BRIGHT", "DAY_BLACKBACK", "DAY_WHITEBACK"}));
        this.colorScheme.setSelectedItem(marinerControls.getColorScheme().toString());
        this.colorScheme.addItemListener(this);
        jPanel.add(this.colorScheme, "cell 1 2,growx,aligny center");
        JLabel jLabel3 = new JLabel("Color Scheme");
        jLabel3.setLabelFor(this.colorScheme);
        jPanel.add((Component)jLabel3, "cell 0 2,alignx left,aligny center");
        this.displayCat = new JComboBox();
        this.displayCat.setModel(new DefaultComboBoxModel<String>(new String[]{"DISPLAYBASE", "STANDARD", "OTHER", "MARINERS_OTHER", "MARINERS_STANDARD"}));
        this.displayCat.setSelectedItem(marinerControls.getDisplayCategory().toString());
        this.displayCat.addItemListener(this);
        jPanel.add(this.displayCat, "cell 1 3,growx,aligny center");
        JLabel jLabel4 = new JLabel("Display Category");
        jLabel4.setLabelFor(this.displayCat);
        jPanel.add((Component)jLabel4, "cell 0 3,alignx left,aligny center");
        this.safety = new JTextField();
        this.safety.setText(Double.toString(marinerControls.getSafetyContour()));
        this.safety.setColumns(5);
        this.safety.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                double d = Double.valueOf(MarinerControlsOptionsPanel.this.safety.getText());
                marinerControls.setSafetyContour(d);
                optionsDialog.refreshRenderer();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jPanel.add((Component)this.safety, "cell 1 5,alignx left,aligny center");
        this.deep = new JTextField();
        this.deep.setText(Double.toString(marinerControls.getDeepContour()));
        this.deep.setColumns(5);
        this.deep.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                double d = Double.valueOf(MarinerControlsOptionsPanel.this.deep.getText());
                marinerControls.setDeepContour(d);
                optionsDialog.refreshRenderer();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jPanel.add((Component)this.deep, "cell 1 6,alignx left,aligny center");
        this.shallow = new JTextField();
        this.shallow.setText(Double.toString(marinerControls.getShallowContour()));
        this.shallow.setColumns(5);
        this.shallow.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                double d = Double.valueOf(MarinerControlsOptionsPanel.this.shallow.getText());
                marinerControls.setShallowContour(d);
                optionsDialog.refreshRenderer();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        jPanel.add((Component)this.shallow, "cell 1 4,alignx left,aligny center");
        JLabel jLabel5 = new JLabel("Shallow (meters)");
        jLabel5.setLabelFor(this.shallow);
        jPanel.add((Component)jLabel5, "cell 0 4,alignx left,aligny center");
        JLabel jLabel6 = new JLabel("Safety (meters)");
        jLabel6.setLabelFor(this.safety);
        jPanel.add((Component)jLabel6, "cell 0 5,alignx left,aligny center");
        JLabel jLabel7 = new JLabel("Deep (meters)");
        jLabel7.setLabelFor(this.deep);
        jPanel.add((Component)jLabel7, "cell 0 6,alignx left,aligny center");
        this.showText = new JCheckBox("Show Text");
        this.showText.setSelected(marinerControls.isShowImportantText());
        this.showText.addItemListener(this);
        jPanel.add((Component)this.showText, "cell 0 7,alignx left,aligny center");
        this.otherText = new JCheckBox("Other Text");
        this.otherText.setSelected(marinerControls.isShowOtherText());
        this.otherText.addItemListener(this);
        this.scaleFilter = new JCheckBox("Scale Filter");
        this.scaleFilter.setSelected(marinerControls.isScaleFilter());
        this.scaleFilter.addItemListener(this);
        jPanel.add((Component)this.scaleFilter, "cell 1 7,alignx left,aligny center");
        jPanel.add((Component)this.otherText, "cell 0 8,alignx left,aligny center");
        this.soundings = new JCheckBox("Soundings");
        this.soundings.setSelected(marinerControls.isSoundings());
        this.soundings.addItemListener(this);
        jPanel.add((Component)this.soundings, "cell 1 8,alignx left,aligny center");
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemEvent.getStateChange() == 2) {
            if (itemSelectable == this.scaleFilter) {
                this.mc.setScaleFilter(false);
            }
            if (itemSelectable == this.showText) {
                this.mc.setShowImportantText(false);
            }
            if (itemSelectable == this.soundings) {
                this.mc.setSoundings(false);
            }
            if (itemSelectable == this.otherText) {
                this.mc.setShowOtherText(false);
            }
            this.parent.refreshRenderer();
            return;
        }
        if (itemSelectable == this.areaStyle) {
            if (((String)itemEvent.getItem()).equals(LookupTableType.SYMBOLIZED_BOUNDARIES.toString())) {
                this.mc.setAreaStyle(LookupTableType.SYMBOLIZED_BOUNDARIES);
            }
            if (((String)itemEvent.getItem()).equals(LookupTableType.PLAIN_BOUNDARIES.toString())) {
                this.mc.setAreaStyle(LookupTableType.PLAIN_BOUNDARIES);
            }
        }
        if (itemSelectable == this.pointStyle) {
            if (((String)itemEvent.getItem()).equals("PAPER_CHART")) {
                this.mc.setPointStyle(LookupTableType.PAPER_CHART);
            }
            if (((String)itemEvent.getItem()).equals("SIMPLIFIED")) {
                this.mc.setPointStyle(LookupTableType.SIMPLIFIED);
            }
        }
        if (itemSelectable == this.colorScheme) {
            this.mc.setColorScheme(ColorScheme.valueOf((String)itemEvent.getItem()));
        }
        if (itemSelectable == this.displayCat) {
            if (((String)itemEvent.getItem()).equals("DISPLAYBASE")) {
                this.mc.setDisplayCategory(DisplayCategory.DISPLAYBASE);
            }
            if (((String)itemEvent.getItem()).equals("STANDARD")) {
                this.mc.setDisplayCategory(DisplayCategory.STANDARD);
            }
            if (((String)itemEvent.getItem()).equals("OTHER")) {
                this.mc.setDisplayCategory(DisplayCategory.OTHER);
            }
            if (((String)itemEvent.getItem()).equals("MARINERS_OTHER")) {
                this.mc.setDisplayCategory(DisplayCategory.MARINERS_OTHER);
            }
            if (((String)itemEvent.getItem()).equals("MARINERS_STANDARD")) {
                this.mc.setDisplayCategory(DisplayCategory.MARINERS_STANDARD);
            }
        }
        if (itemSelectable == this.scaleFilter) {
            this.mc.setScaleFilter(true);
        }
        if (itemSelectable == this.showText) {
            this.mc.setShowImportantText(true);
        }
        if (itemSelectable == this.soundings) {
            this.mc.setSoundings(true);
        }
        if (itemSelectable == this.otherText) {
            this.mc.setShowOtherText(true);
        }
        this.parent.refreshRenderer();
    }

    @Override
    public void refresh() {
        this.pointStyle.setSelectedItem(this.mc.getPointStyle().toString());
        this.areaStyle.setSelectedItem(this.mc.getAreaStyle().toString());
        this.colorScheme.setSelectedItem(this.mc.getColorScheme().toString());
        this.displayCat.setSelectedItem(this.mc.getDisplayCategory().toString());
        this.safety.setText(Double.toString(this.mc.getSafetyContour()));
        this.deep.setText(Double.toString(this.mc.getDeepContour()));
        this.shallow.setText(Double.toString(this.mc.getShallowContour()));
        this.showText.setSelected(this.mc.isShowImportantText());
        this.scaleFilter.setSelected(this.mc.isScaleFilter());
        this.otherText.setSelected(this.mc.isShowOtherText());
        this.soundings.setSelected(this.mc.isSoundings());
    }
}

