/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTabbedPane;
import javax.swing.Timer;
import pt.lsts.neptus.renderer2d.StateRenderer2D;
import pt.lsts.s57.ui.OptionsPanel;

public class OptionsDialog
extends JDialog
implements WindowListener {
    private static final long serialVersionUID = -2895143026604070400L;
    private static final int messageTimeout = 5000;
    private StateRenderer2D srend = null;
    protected Timer timer;
    private final JTabbedPane tabsPanel = new JTabbedPane(1);
    protected JProgressBar statusProgress;
    protected JLabel statusText;
    private List<OptionsPanel> tabs = new ArrayList<OptionsPanel>();

    public OptionsDialog() {
        this((Window)null);
    }

    public OptionsDialog(JDialog jDialog) {
        this((Window)jDialog);
    }

    public OptionsDialog(JFrame jFrame) {
        this((Window)jFrame);
    }

    private OptionsDialog(Window window) {
        super((Window)(window != null && !(window instanceof Frame) && !(window instanceof Dialog) ? null : window));
        this.setTitle("S57 Settings");
        this.setBounds(100, 100, 600, 600);
        this.getContentPane().setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.tabsPanel, "Center");
        this.addWindowListener(this);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        this.getContentPane().add((Component)jPanel, "South");
        JButton jButton = new JButton("OK");
        jButton.setActionCommand("OK");
        jPanel.add(jButton);
        jButton.setAction(new Ok(this));
        this.getRootPane().setDefaultButton(jButton);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setActionCommand("Cancel");
        jButton2.setAction(new Cancel(this));
        jPanel.add(jButton2);
    }

    public void addTab(String string, Icon icon, OptionsPanel optionsPanel, String string2) {
        this.tabsPanel.addTab(string, icon, (Component)((Object)optionsPanel), string2);
        this.tabs.add(optionsPanel);
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
        this.refresh();
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
        this.refresh();
    }

    public void refresh() {
        this.refreshRenderer();
        for (OptionsPanel optionsPanel : this.tabs) {
            optionsPanel.refresh();
        }
    }

    public StateRenderer2D getRenderer() {
        return this.srend;
    }

    public void setRenderer(StateRenderer2D stateRenderer2D) {
        this.srend = stateRenderer2D;
    }

    public void refreshRenderer() {
        if (this.srend != null) {
            this.srend.invalidate();
            this.srend.validate();
            this.srend.repaint();
        }
    }

    protected void setMessage(String string) {
        this.statusText.setText(this.statusText.getText() + " " + string);
        this.timer = new Timer(5000, new MessageListener());
        this.timer.restart();
    }

    public ImageIcon getIcon(String string, int n) {
        URL uRL = OptionsDialog.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(n, n, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    public ImageIcon getIconSmall(String string) {
        URL uRL = OptionsDialog.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(11, 11, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    public ImageIcon getIconMedium(String string) {
        URL uRL = OptionsDialog.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(14, 14, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    class MessageListener
    implements ActionListener {
        MessageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            OptionsDialog.this.statusText.setText("");
            OptionsDialog.this.timer.stop();
        }
    }

    private class Cancel
    extends AbstractAction {
        private static final long serialVersionUID = -5559433311567315453L;
        JDialog dialog;

        public Cancel(JDialog jDialog) {
            this.dialog = jDialog;
            this.putValue("Name", "Cancel");
            this.putValue("ShortDescription", "Some short description");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.setVisible(false);
        }
    }

    private class Ok
    extends AbstractAction {
        private static final long serialVersionUID = -5559433311567315453L;
        JDialog dialog;

        public Ok(JDialog jDialog) {
            this.dialog = jDialog;
            this.putValue("Name", "OK");
            this.putValue("ShortDescription", "Some short description");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.dialog.setVisible(false);
        }
    }
}

