/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s57.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;
import pt.lsts.s57.S57;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.ui.LoadS57FolderTask;
import pt.lsts.s57.ui.OptionsDialog;
import pt.lsts.s57.ui.OptionsPanel;

public class S57OptionsPanel
extends JPanel
implements OptionsPanel {
    private static final long serialVersionUID = 1L;
    private static final int messageTimeout = 5000;
    private S57 s57;
    private JList<String> folderList;
    private JList<String> mapsList;
    private JPanel mapInfo;
    protected OptionsDialog parent;
    protected JProgressBar statusProgress;
    protected JLabel statusText;
    protected JButton btnAddFolder;
    protected JButton btnDelFolder;
    protected Timer timer;
    MouseListener folderListMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = S57OptionsPanel.this.folderList.locationToIndex(mouseEvent.getPoint());
                String string = (String)S57OptionsPanel.this.folderList.getSelectedValue();
                if (n > -1) {
                    S57OptionsPanel.this.mapsList.setListData(S57OptionsPanel.this.s57.getMapsFromFolder(string).toArray(new String[0]));
                }
            }
        }
    };
    MouseListener mapsListMouseListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = S57OptionsPanel.this.mapsList.locationToIndex(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                S57OptionsPanel.this.mapInfo.removeAll();
                JLabel jLabel = new JLabel();
                jLabel.setText("<html><body style='margin:0;padding:0'>");
                String string = (String)S57OptionsPanel.this.mapsList.getSelectedValue();
                try {
                    Map<String, String> map = S57OptionsPanel.this.s57.getMapMeta(string);
                    for (Map.Entry<String, String> entry : map.entrySet()) {
                        jLabel.setText(jLabel.getText() + "<b>" + entry.getKey() + "</b> : " + entry.getValue() + "<br/>");
                    }
                }
                catch (Exception exception) {
                    jLabel.setText(jLabel.getText() + exception.getMessage() + "<br/>");
                }
                jLabel.setText(jLabel.getText() + "</body></html>");
                S57OptionsPanel.this.mapInfo.add((Component)jLabel, "top, left");
                S57OptionsPanel.this.mapInfo.invalidate();
                S57OptionsPanel.this.mapInfo.validate();
                S57OptionsPanel.this.mapInfo.repaint();
            }
        }
    };

    public S57OptionsPanel(S57 s57, OptionsDialog optionsDialog) {
        this.s57 = s57;
        this.parent = optionsDialog;
        S57Utils.loadSession(s57);
        this.setLayout(new MigLayout());
        this.createComponents();
    }

    private void createComponents() {
        this.btnAddFolder = new JButton();
        this.btnAddFolder.setAction(new LoadFolder(this));
        this.btnAddFolder.setIcon(this.getIconMedium("icons/folder-download.png"));
        this.add((Component)this.btnAddFolder, "split");
        this.btnDelFolder = new JButton();
        this.btnDelFolder.setAction(new RemoveFolder());
        this.btnDelFolder.setIcon(this.getIconMedium("icons/cancel2.png"));
        this.add((Component)this.btnDelFolder, "wrap");
        JScrollPane jScrollPane = new JScrollPane();
        this.folderList = new JList();
        this.folderList.addMouseListener(this.folderListMouseListener);
        jScrollPane.setViewportView(this.folderList);
        this.add((Component)jScrollPane, "h 25%, span, w 100%");
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(10, 20));
        jPanel.setName("Status Bar");
        jPanel.setLayout(new BorderLayout(0, 0));
        this.add((Component)jPanel, "h 6%, span, w 100%");
        this.statusText = new JLabel();
        jPanel.add((Component)this.statusText, "West");
        this.statusProgress = new JProgressBar(0, 100);
        this.statusProgress.setValue(0);
        this.statusProgress.setEnabled(false);
        this.statusProgress.setStringPainted(true);
        this.statusProgress.setVisible(false);
        jPanel.add((Component)this.statusProgress, "East");
        JScrollPane jScrollPane2 = new JScrollPane();
        this.mapsList = new JList();
        jScrollPane2.setViewportView(this.mapsList);
        this.mapsList.addMouseListener(this.mapsListMouseListener);
        this.mapsList.setCellRenderer(new MapsListRenderer());
        this.add((Component)jScrollPane2, "w 35%, h 69%, split");
        this.mapInfo = new JPanel(new MigLayout());
        JScrollPane jScrollPane3 = new JScrollPane(this.mapInfo, 20, 30);
        this.add((Component)jScrollPane3, "w 80%, h 69%, wrap");
    }

    @Override
    public void refresh() {
        List<String> list = this.s57.getFolders();
        this.folderList.setListData((String[])list.toArray(new String[list.size()]));
        this.mapsList.setListData((String[])new String[0]);
        this.mapInfo.removeAll();
    }

    private JFileChooser createFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setName(string);
        jFileChooser.setMultiSelectionEnabled(true);
        return jFileChooser;
    }

    protected void setMessage(String string) {
        this.statusText.setText(string);
        this.timer = new Timer(5000, new MessageListener());
        this.timer.restart();
    }

    public ImageIcon getIcon(String string, int n) {
        URL uRL = S57OptionsPanel.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(n, n, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    public ImageIcon getIconSmall(String string) {
        URL uRL = S57OptionsPanel.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(11, 11, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    public ImageIcon getIconMedium(String string) {
        URL uRL = S57OptionsPanel.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(14, 14, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    class MapsListRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -5340963297390020776L;

        public MapsListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            if (S57OptionsPanel.this.s57.getMap(string) != null) {
                this.setText(string);
                this.setFont(jList.getFont());
                this.setIcon(S57OptionsPanel.this.getIconSmall("icons/location.png"));
                return this;
            }
            this.setText(string);
            this.setFont(jList.getFont());
            this.setIcon(S57OptionsPanel.this.getIconSmall("icons/warning.png"));
            return this;
        }
    }

    private class MessageListener
    implements ActionListener {
        private MessageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            S57OptionsPanel.this.statusText.setText("");
            S57OptionsPanel.this.timer.stop();
        }
    }

    private class RemoveFolder
    extends AbstractAction {
        private static final long serialVersionUID = -5559433311567315453L;

        public RemoveFolder() {
            this.putValue("Name", "Remove Folder");
            this.putValue("ShortDescription", "Remove selected folder.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            List<String> list = S57OptionsPanel.this.folderList.getSelectedValuesList();
            if (list != null) {
                S57OptionsPanel.this.s57.removeFolders(list, true);
            }
            S57OptionsPanel.this.refresh();
            S57OptionsPanel.this.parent.refreshRenderer();
        }
    }

    private class LoadFolder
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = 7862292957980519987L;
        private LoadS57FolderTask loadTask;
        private File[] dir;
        private S57OptionsPanel container;

        public LoadFolder(S57OptionsPanel s57OptionsPanel2) {
            this.putValue("Name", "Add Folder");
            this.putValue("ShortDescription", "Add a folder containing S57 maps");
            this.container = s57OptionsPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            JFileChooser jFileChooser = S57OptionsPanel.this.createFileChooser("openFileChooser");
            jFileChooser.setFileSelectionMode(1);
            String string = S57Utils.sessionGet(S57OptionsPanel.this.s57, "lastS57Folder");
            if (string != null) {
                jFileChooser.setCurrentDirectory(new File(string));
            }
            if (0 == (n = jFileChooser.showOpenDialog(S57OptionsPanel.this.parent.getContentPane()))) {
                this.dir = jFileChooser.getSelectedFiles();
                S57Utils.sessionSaveProperty(S57OptionsPanel.this.s57, "lastS57Folder", this.dir[0].toString());
                this.loadTask = new LoadS57FolderTask(this.dir, S57OptionsPanel.this.s57, this.container);
                this.loadTask.addPropertyChangeListener(this);
                this.loadTask.execute();
                S57OptionsPanel.this.statusProgress.setVisible(true);
                S57OptionsPanel.this.statusProgress.setEnabled(true);
                S57OptionsPanel.this.statusProgress.setIndeterminate(true);
                S57OptionsPanel.this.btnAddFolder.setEnabled(false);
                S57OptionsPanel.this.btnDelFolder.setEnabled(false);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("progress" == string) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                S57OptionsPanel.this.statusProgress.setEnabled(true);
                S57OptionsPanel.this.statusProgress.setIndeterminate(false);
                S57OptionsPanel.this.statusProgress.setValue(n);
            } else if ("state" == string && (this.loadTask.isDone() || this.loadTask.isCancelled())) {
                if (this.loadTask.isCancelled()) {
                    S57OptionsPanel.this.setMessage("Error loading maps");
                } else if (this.loadTask.isDone() && S57OptionsPanel.this.statusProgress.getValue() == 100) {
                    S57OptionsPanel.this.setMessage("Loading maps complete!");
                }
                S57OptionsPanel.this.refresh();
                S57OptionsPanel.this.parent.refreshRenderer();
                S57OptionsPanel.this.statusProgress.setEnabled(false);
                S57OptionsPanel.this.statusProgress.setIndeterminate(false);
                S57OptionsPanel.this.statusProgress.setValue(0);
                S57OptionsPanel.this.statusProgress.setVisible(false);
                S57OptionsPanel.this.btnAddFolder.setEnabled(true);
                S57OptionsPanel.this.btnDelFolder.setEnabled(true);
            }
        }
    }
}

