/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s63;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import pt.lsts.s57.S57;
import pt.lsts.s57.S57Listener;
import pt.lsts.s57.S57Utils;
import pt.lsts.s63.S63CellPermit;
import pt.lsts.s63.S63Permit;

public class S63 {
    private S57 s57;
    private Map<String, List<File>> folders = Collections.synchronizedMap(new LinkedHashMap());
    private Map<String, S63Permit> folderPermit = Collections.synchronizedMap(new HashMap());

    public static S63 forge(S57 s57) {
        return new S63(s57);
    }

    private S63(S57 s57) {
        this.s57 = s57;
    }

    public void addFolder(File file, S57Listener s57Listener) throws IllegalArgumentException {
        List list = null;
        if (file.exists() && file.isDirectory() && !this.folders.containsKey(file.toString())) {
            List<String> list2 = Arrays.asList(file.list());
            if (!(list2.contains("ENC_ROOT") && list2.contains("INFO") && list2.contains("SERIAL.ENC"))) {
                throw new IllegalArgumentException("Invalid S63 exchange set folder.");
            }
            list = (List)FileUtils.listFiles(file, new String[]{"000"}, true);
            if (list.isEmpty() || list == null) {
                throw new IllegalArgumentException("No S63 files found.");
            }
        } else {
            throw new IllegalArgumentException("Not a folder or already loaded.");
        }
        this.folders.put(file.toString(), list);
        S57Utils.sessionSaveProperty(this.s57, "s63Folders", new ArrayList<String>(this.folders.keySet()));
    }

    public void removeFolder(File file) {
        String string = file.toString();
        if (this.folders.containsKey(string)) {
            List<File> list = this.folders.remove(string);
            this.folderPermit.remove(string);
            this.s57.removeMaps(list, true);
            S57Utils.sessionSaveProperty(this.s57, "s63Folders", new ArrayList<String>(this.folders.keySet()));
        }
        if (this.folders.isEmpty()) {
            S57Utils.cleanS63TempFiles(this.s57);
        }
    }

    public void loadPermit(String string, String string2, S57Listener s57Listener) throws Exception {
        if (!this.folders.containsKey(string2)) {
            throw new IllegalArgumentException("Folder has not been loaded yet.");
        }
        S63Permit s63Permit = S63Permit.forge(string);
        this.folderPermit.put(string2, s63Permit);
        String string3 = this.s57.getConfig().getString("s63.cache.folder");
        File file = new File(string3);
        int n = 0;
        List<File> list = this.folders.get(string2);
        int n2 = list.size();
        for (File file2 : list) {
            S63CellPermit s63CellPermit = s63Permit.getCellPermit(file2.getName());
            if (s63CellPermit != null) {
                byte[] byArray = new byte[4];
                InputStream inputStream = S57Utils.decryptBlowfish(file2, s63CellPermit.getCk1());
                inputStream.read(byArray);
                inputStream.close();
                if (S57Utils.byteArrayToHexString(byArray).equals("504B0304")) {
                    S57Utils.unzipToFile(S57Utils.decryptBlowfish(file2, s63CellPermit.getCk1()), string3);
                    continue;
                }
                inputStream = S57Utils.decryptBlowfish(file2, s63CellPermit.getCk2());
                inputStream.read(byArray);
                inputStream.close();
                if (S57Utils.byteArrayToHexString(byArray).equals("504B0304")) {
                    S57Utils.unzipToFile(S57Utils.decryptBlowfish(file2, s63CellPermit.getCk2()), string3);
                }
            }
            if (s57Listener != null) {
                s57Listener.publishResult((n + 1) * 100 / n2);
            }
            ++n;
        }
        this.s57.preloadMaps(Arrays.asList(file.listFiles()), s57Listener);
    }

    public List<String> getFolders() {
        return new ArrayList<String>(this.folders.keySet());
    }

    public List<String> getFoldersWithPermit() {
        return Arrays.asList(this.folderPermit.keySet().toArray(new String[0]));
    }

    public List<String> getMapsFromFolder(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<File> list = this.folders.get(string);
        for (File file : list) {
            arrayList.add(file.getName());
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public S63Permit getPermitFromFolder(String string) {
        return this.folderPermit.get(string);
    }
}

