/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s63;

import pt.lsts.s57.S57Utils;

public class S63CellPermit {
    private static final String HW_ID6 = "5AFA85";
    private static final String HW_ID = "5AFA8";
    private StatusType status;
    private final String cellName;
    private final String expireData;
    private final String eck1;
    private final byte[] ck1;
    private final String eck2;
    private final byte[] ck2;
    private final String crc;
    private final int serviceLevelIndicator;
    private final int editionNumber;
    private final String dataServerID;
    private final String comment;

    public static S63CellPermit forge(String string, String string2, String string3, String string4, String string5) {
        return new S63CellPermit(string, string2, string3, string4, string5);
    }

    private S63CellPermit(String string, String string2, String string3, String string4, String string5) {
        this.cellName = string.substring(0, 8);
        this.expireData = string.substring(8, 16);
        this.eck1 = string.substring(16, 32);
        this.eck2 = string.substring(32, 48);
        this.crc = string.substring(48, 64);
        this.serviceLevelIndicator = this.serviceLevelIndicator;
        this.editionNumber = Integer.valueOf(string3);
        this.dataServerID = string4;
        this.comment = string5;
        this.ck1 = S57Utils.decryptBlowfish(this.eck1, HW_ID6);
        this.ck2 = S57Utils.decryptBlowfish(this.eck2, HW_ID6);
        String string6 = string.substring(0, 48);
        int n = S57Utils.checksum(string6);
        String string7 = S57Utils.encryptBlowfish(n, HW_ID6);
        this.status = string7.equals(this.crc) ? StatusType.VALID : StatusType.INVALID;
    }

    public String getCellName() {
        return this.cellName;
    }

    public String getExpireData() {
        return this.expireData;
    }

    public String getEck1() {
        return this.eck1;
    }

    public String getEck2() {
        return this.eck2;
    }

    public String getCrc() {
        return this.crc;
    }

    public int getServiceLevelIndicator() {
        return this.serviceLevelIndicator;
    }

    public int getEditionNumber() {
        return this.editionNumber;
    }

    public String getDataServerID() {
        return this.dataServerID;
    }

    public String getComment() {
        return this.comment;
    }

    public StatusType getStatus() {
        return this.status;
    }

    public void setStatus(StatusType statusType) {
        this.status = statusType;
    }

    public String toString() {
        return "S63Permit [cellName=" + this.cellName + ", expireData=" + this.expireData + ", eck1=" + this.eck1 + ", eck2=" + this.eck2 + ", crc=" + this.crc + ", serviceLevelIndicator=" + this.serviceLevelIndicator + ", editionNumber=" + this.editionNumber + ", dataServerID=" + this.dataServerID + ", comment=" + this.comment + "]";
    }

    public byte[] getCk1() {
        return this.ck1;
    }

    public byte[] getCk2() {
        return this.ck2;
    }

    public static enum StatusType {
        VALID,
        INVALID,
        EXPIRED;

    }
}

