/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s63;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.LineIterator;
import pt.lsts.s63.S63CellPermit;

public class S63Permit {
    private final File path;
    private final Map<String, S63CellPermit> cellpermits = new HashMap<String, S63CellPermit>();

    public static S63Permit forge(String string) throws Exception {
        File file = new File(string);
        return new S63Permit(file);
    }

    public static S63Permit forge(File file) throws Exception {
        if (!file.getName().equals("PERMIT.TXT")) {
            throw new IllegalArgumentException("Cell permit not found.");
        }
        return new S63Permit(file);
    }

    private S63Permit(File file) throws Exception {
        this.path = file;
        try {
            this.readFile(file);
        }
        catch (IOException iOException) {
            System.out.println("error reading permit file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(File file) throws Exception {
        LineIterator lineIterator = FileUtils.lineIterator(file, "UTF-8");
        int n = 0;
        try {
            block8: while (lineIterator.hasNext()) {
                String string = lineIterator.nextLine().trim();
                if (string.isEmpty()) continue;
                switch (n) {
                    case 0: {
                        if (!string.startsWith(":DATE")) {
                            throw new Exception("Cell permit not valid.");
                        }
                        ++n;
                        continue block8;
                    }
                    case 1: {
                        if (!string.startsWith(":VERSION")) {
                            throw new Exception("Cell permit not valid.");
                        }
                        ++n;
                        continue block8;
                    }
                    case 2: {
                        if (!string.startsWith(":ENC")) {
                            throw new Exception("Cell permit not valid.");
                        }
                        ++n;
                        continue block8;
                    }
                }
                if (string.startsWith(":") && !string.startsWith(":ECS")) {
                    throw new Exception("Cell permit not valid.");
                }
                if (string.startsWith(":ECS")) continue;
                String[] stringArray = string.split(",");
                if (stringArray.length < 4 || stringArray.length > 5) {
                    throw new Exception("Cell permit not valid.");
                }
                S63CellPermit s63CellPermit = S63CellPermit.forge(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray.length > 4 ? stringArray[4] : "");
                this.cellpermits.put(s63CellPermit.getCellName(), s63CellPermit);
                ++n;
            }
        }
        finally {
            LineIterator.closeQuietly(lineIterator);
        }
    }

    public S63CellPermit getCellPermit(String string) {
        S63CellPermit s63CellPermit = this.cellpermits.get(string.replace(".000", ""));
        return s63CellPermit;
    }

    public List<String> getMaps() {
        return new ArrayList<String>(this.cellpermits.keySet());
    }

    public File getPath() {
        return this.path;
    }
}

