/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.s63.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;
import net.miginfocom.swing.MigLayout;
import pt.lsts.s57.S57;
import pt.lsts.s57.S57Utils;
import pt.lsts.s57.ui.OptionsDialog;
import pt.lsts.s57.ui.OptionsPanel;
import pt.lsts.s63.S63;
import pt.lsts.s63.S63CellPermit;
import pt.lsts.s63.S63Permit;
import pt.lsts.s63.ui.LoadS63FolderTask;
import pt.lsts.s63.ui.LoadS63PermitTask;

public class S63OptionsPanel
extends JPanel
implements OptionsPanel {
    private static final long serialVersionUID = -1511116937385781823L;
    private static final int messageTimeout = 5000;
    private S63 s63;
    private S57 s57;
    private JList folderList;
    private JList mapsList;
    private JPanel mapInfo;
    protected OptionsDialog parent;
    protected JProgressBar statusProgress;
    protected JLabel statusText;
    protected JButton btnAddFolder;
    protected JButton btnDelFolder;
    protected JButton btnAddPermit;
    protected Timer timer;
    MouseListener folderListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = S63OptionsPanel.this.folderList.locationToIndex(mouseEvent.getPoint());
                String string = (String)S63OptionsPanel.this.folderList.getSelectedValue();
                if (n > -1) {
                    S63OptionsPanel.this.btnAddPermit.setEnabled(true);
                    S63OptionsPanel.this.mapsList.setListData(S63OptionsPanel.this.s63.getMapsFromFolder(string).toArray(new String[0]));
                }
            }
        }
    };
    MouseListener mapsListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 1) {
                int n = S63OptionsPanel.this.mapsList.locationToIndex(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                String string = (String)S63OptionsPanel.this.mapsList.getSelectedValue();
                String string2 = (String)S63OptionsPanel.this.folderList.getSelectedValue();
                S63Permit s63Permit = S63OptionsPanel.this.s63.getPermitFromFolder(string2);
                S63OptionsPanel.this.mapInfo.removeAll();
                JLabel jLabel = new JLabel();
                jLabel.setText("<html><body style='margin:0;padding:0'>");
                if (s63Permit == null) {
                    jLabel.setText(jLabel.getText() + "No permit loaded.");
                } else {
                    try {
                        S63CellPermit s63CellPermit = s63Permit.getCellPermit(string);
                        if (s63CellPermit == null) {
                            jLabel.setText(jLabel.getText() + "No permit for the selected cell <br/>");
                        } else {
                            jLabel.setText(jLabel.getText() + "<b> Permit Status </b> : " + (Object)((Object)s63CellPermit.getStatus()) + "<br/>");
                            jLabel.setText(jLabel.getText() + "<b> Expire Date </b> : " + s63CellPermit.getExpireData() + "<br/>");
                            jLabel.setText(jLabel.getText() + "<b> DataServer ID </b> : " + s63CellPermit.getDataServerID() + "<br/>");
                            jLabel.setText(jLabel.getText() + "<br/>");
                            Map<String, String> map = S63OptionsPanel.this.s57.getMapMeta(string);
                            for (Map.Entry<String, String> entry : map.entrySet()) {
                                jLabel.setText(jLabel.getText() + "<b>" + entry.getKey() + "</b> : " + entry.getValue() + "<br/>");
                            }
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        jLabel.setText(jLabel.getText() + "No permit for this map.");
                    }
                }
                jLabel.setText(jLabel.getText() + "</body></html>");
                S63OptionsPanel.this.mapInfo.add((Component)jLabel, "top, left");
                S63OptionsPanel.this.mapInfo.invalidate();
                S63OptionsPanel.this.mapInfo.validate();
                S63OptionsPanel.this.mapInfo.repaint();
            }
        }
    };

    public S63OptionsPanel(S57 s57, S63 s63, OptionsDialog optionsDialog) {
        this.s57 = s57;
        this.s63 = s63;
        this.parent = optionsDialog;
        this.setLayout(new MigLayout());
        this.createComponents();
    }

    private void createComponents() {
        this.btnAddFolder = new JButton();
        this.btnAddFolder.setAction(new LoadFolder(this));
        this.btnAddFolder.setIcon(this.getIconMedium("icons/folder-download.png"));
        this.add((Component)this.btnAddFolder, "split");
        this.btnDelFolder = new JButton();
        this.btnDelFolder.setAction(new RemoveFolder());
        this.btnDelFolder.setIcon(this.getIconMedium("icons/cancel2.png"));
        this.add((Component)this.btnDelFolder, "split");
        this.btnAddPermit = new JButton();
        this.btnAddPermit.setAction(new LoadPermit(this));
        this.btnAddPermit.setEnabled(false);
        this.btnAddPermit.setIcon(this.getIconMedium("icons/lock2.png"));
        this.add((Component)this.btnAddPermit, "wrap");
        JScrollPane jScrollPane = new JScrollPane();
        this.folderList = new JList();
        this.folderList.addMouseListener(this.folderListener);
        this.folderList.setCellRenderer(new ListRenderer());
        jScrollPane.setViewportView(this.folderList);
        this.add((Component)jScrollPane, "h 25%, span, w 100%");
        JPanel jPanel = new JPanel();
        jPanel.setPreferredSize(new Dimension(10, 20));
        jPanel.setName("Status Bar");
        jPanel.setLayout(new BorderLayout(0, 0));
        this.add((Component)jPanel, "h 6%, span, w 100%");
        this.statusText = new JLabel();
        jPanel.add((Component)this.statusText, "West");
        this.statusProgress = new JProgressBar(0, 100);
        this.statusProgress.setValue(0);
        this.statusProgress.setEnabled(false);
        this.statusProgress.setStringPainted(true);
        this.statusProgress.setVisible(false);
        jPanel.add((Component)this.statusProgress, "East");
        JScrollPane jScrollPane2 = new JScrollPane();
        this.mapsList = new JList();
        jScrollPane2.setViewportView(this.mapsList);
        this.mapsList.addMouseListener(this.mapsListener);
        this.mapsList.setCellRenderer(new MapsListRenderer());
        this.add((Component)jScrollPane2, "w 35%, h 69%, split");
        this.mapInfo = new JPanel(new MigLayout());
        JScrollPane jScrollPane3 = new JScrollPane(this.mapInfo, 20, 30);
        this.add((Component)jScrollPane3, "w 80%, h 69%, wrap");
    }

    @Override
    public void refresh() {
        List<String> list = this.s63.getFolders();
        this.folderList.setListData(list.toArray(new String[list.size()]));
        this.mapsList.setListData(new String[0]);
        this.mapInfo.removeAll();
        this.btnAddPermit.setEnabled(false);
    }

    private JFileChooser createFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setName(string);
        String string2 = S57Utils.sessionGet(this.s57, "lastS63Folder");
        if (string2 != null) {
            jFileChooser.setCurrentDirectory(new File(string2));
        }
        return jFileChooser;
    }

    protected void setMessage(String string) {
        this.statusText.setText(string);
        this.timer = new Timer(5000, new MessageListener());
        this.timer.restart();
    }

    public OptionsDialog getParent2() {
        return this.parent;
    }

    public ImageIcon getIcon(String string, int n) {
        URL uRL = S63OptionsPanel.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(n, n, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    public ImageIcon getIconSmall(String string) {
        URL uRL = S63OptionsPanel.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(11, 11, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    public ImageIcon getIconMedium(String string) {
        URL uRL = S63OptionsPanel.class.getResource(string);
        if (uRL != null) {
            ImageIcon imageIcon = new ImageIcon(uRL);
            Image image = imageIcon.getImage().getScaledInstance(14, 14, 4);
            imageIcon.setImage(image);
            return imageIcon;
        }
        return null;
    }

    class MapsListRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -5340963297390020776L;

        public MapsListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string;
            String string2 = (String)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            String string3 = (String)S63OptionsPanel.this.folderList.getSelectedValue();
            S63Permit s63Permit = S63OptionsPanel.this.s63.getPermitFromFolder(string3);
            if (s63Permit == null) {
                this.setText(object.toString());
                this.setFont(jList.getFont());
                this.setIcon(S63OptionsPanel.this.getIconSmall("icons/lock2.png"));
                return this;
            }
            String string4 = S63OptionsPanel.this.s57.getConfig().getString("s57.cache.folder");
            List<String> list = Arrays.asList(new File(string4).list(new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return string.endsWith("dat");
                }
            }));
            List<String> list2 = s63Permit.getMaps();
            if (list2.contains(string = string2.replace(".000", ""))) {
                if (list.contains(string2 + ".dat")) {
                    this.setText(string2);
                    this.setFont(jList.getFont());
                    this.setIcon(S63OptionsPanel.this.getIconSmall("icons/location.png"));
                    return this;
                }
                this.setText(string2);
                this.setFont(jList.getFont());
                this.setIcon(S63OptionsPanel.this.getIconSmall("icons/warning.png"));
                return this;
            }
            this.setText(string2);
            this.setFont(jList.getFont());
            this.setIcon(S63OptionsPanel.this.getIconSmall("icons/lock2.png"));
            return this;
        }
    }

    class ListRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -5340963297390020776L;

        public ListRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            List<String> list = S63OptionsPanel.this.s63.getFoldersWithPermit();
            for (String string2 : list) {
                if (!string2.equals(string)) continue;
                this.setText("(Permit Loaded) " + string);
                this.setFont(jList.getFont());
                return this;
            }
            this.setText(object.toString());
            this.setFont(jList.getFont());
            return this;
        }
    }

    private class MessageListener
    implements ActionListener {
        private MessageListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            S63OptionsPanel.this.statusText.setText("");
            S63OptionsPanel.this.timer.stop();
        }
    }

    private class PermitFilter
    extends FileFilter {
        private PermitFilter() {
        }

        @Override
        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            return file.getName().equals("PERMIT.TXT");
        }

        @Override
        public String getDescription() {
            return "S63 Permit file";
        }
    }

    private class LoadPermit
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = 8558882767506473609L;
        private LoadS63PermitTask loadTask;
        private S63OptionsPanel container;

        public LoadPermit(S63OptionsPanel s63OptionsPanel2) {
            this.putValue("Name", "Load Permit");
            this.putValue("ShortDescription", "Load permit for the selected folder");
            this.container = s63OptionsPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            String string = (String)S63OptionsPanel.this.folderList.getSelectedValue();
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setName("Choose Permit File");
            jFileChooser.setMultiSelectionEnabled(false);
            jFileChooser.setFileFilter(new PermitFilter());
            String string2 = S57Utils.sessionGet(S63OptionsPanel.this.s57, "lastS63Folder");
            if (string2 != null) {
                jFileChooser.setCurrentDirectory(new File(string2));
            }
            if ((string2 = S57Utils.sessionGet(S63OptionsPanel.this.s57, "lastPermitFolder")) != null) {
                jFileChooser.setCurrentDirectory(new File(string2));
            }
            if (0 == (n = jFileChooser.showOpenDialog(S63OptionsPanel.this.parent.getContentPane()))) {
                File file = jFileChooser.getSelectedFile();
                S57Utils.sessionSaveProperty(S63OptionsPanel.this.s57, "lastPermitFolder", file.getParent().toString());
                this.loadTask = new LoadS63PermitTask(S63OptionsPanel.this.s63, file, string, this.container);
                this.loadTask.addPropertyChangeListener(this);
                this.loadTask.execute();
                S63OptionsPanel.this.statusProgress.setVisible(true);
                S63OptionsPanel.this.statusProgress.setEnabled(true);
                S63OptionsPanel.this.statusProgress.setIndeterminate(true);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("progress" == string) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                S63OptionsPanel.this.statusProgress.setEnabled(true);
                S63OptionsPanel.this.statusProgress.setIndeterminate(false);
                S63OptionsPanel.this.statusProgress.setValue(n);
            }
            if ("state" == string && (this.loadTask.isDone() || this.loadTask.isCancelled())) {
                if (this.loadTask.isCancelled()) {
                    S63OptionsPanel.this.setMessage("Permit load cancelled");
                } else if (this.loadTask.isDone() && S63OptionsPanel.this.statusProgress.getValue() == 100) {
                    S63OptionsPanel.this.setMessage("Permit loaded.");
                }
                S63OptionsPanel.this.refresh();
                this.container.getParent2().refreshRenderer();
                S63OptionsPanel.this.statusProgress.setEnabled(false);
                S63OptionsPanel.this.statusProgress.setIndeterminate(false);
                S63OptionsPanel.this.statusProgress.setValue(0);
                S63OptionsPanel.this.statusProgress.setVisible(false);
            }
        }
    }

    private class RemoveFolder
    extends AbstractAction {
        private static final long serialVersionUID = 9202014470108665775L;

        public RemoveFolder() {
            this.putValue("Name", "Remove Folder");
            this.putValue("ShortDescription", "Remove selected folder.");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            System.out.println("dd");
            Object e = S63OptionsPanel.this.folderList.getSelectedValue();
            if (e != null) {
                S63OptionsPanel.this.s63.removeFolder(new File((String)S63OptionsPanel.this.folderList.getSelectedValue()));
            }
            S63OptionsPanel.this.refresh();
            S63OptionsPanel.this.parent.refreshRenderer();
        }
    }

    private class LoadFolder
    extends AbstractAction
    implements PropertyChangeListener {
        private static final long serialVersionUID = -2364269674599620429L;
        private LoadS63FolderTask loadTask;
        private S63OptionsPanel container;

        public LoadFolder(S63OptionsPanel s63OptionsPanel2) {
            this.putValue("Name", "Add Folder");
            this.putValue("ShortDescription", "Add a folder containing S63 maps");
            this.container = s63OptionsPanel2;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = S63OptionsPanel.this.createFileChooser("openFileChooser");
            jFileChooser.setFileSelectionMode(1);
            int n = jFileChooser.showOpenDialog(S63OptionsPanel.this.parent.getContentPane());
            if (0 == n) {
                File file = jFileChooser.getSelectedFile();
                S57Utils.sessionSaveProperty(S63OptionsPanel.this.s57, "lastS63Folder", file.toString());
                this.loadTask = new LoadS63FolderTask(file, S63OptionsPanel.this.s63, this.container);
                this.loadTask.addPropertyChangeListener(this);
                this.loadTask.execute();
                S63OptionsPanel.this.statusProgress.setVisible(true);
                S63OptionsPanel.this.statusProgress.setEnabled(true);
                S63OptionsPanel.this.statusProgress.setIndeterminate(true);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("progress" == string) {
                int n = (Integer)propertyChangeEvent.getNewValue();
                S63OptionsPanel.this.statusProgress.setEnabled(true);
                S63OptionsPanel.this.statusProgress.setIndeterminate(false);
                S63OptionsPanel.this.statusProgress.setValue(n);
            }
            if ("state" == string && (this.loadTask.isDone() || this.loadTask.isCancelled())) {
                if (this.loadTask.isCancelled()) {
                    S63OptionsPanel.this.setMessage("Folder load cancelled");
                } else if (this.loadTask.isDone()) {
                    // empty if block
                }
                S63OptionsPanel.this.refresh();
                S63OptionsPanel.this.statusProgress.setEnabled(false);
                S63OptionsPanel.this.statusProgress.setIndeterminate(false);
                S63OptionsPanel.this.statusProgress.setValue(0);
                S63OptionsPanel.this.statusProgress.setVisible(false);
            }
        }
    }
}

