/*
 * Decompiled with CFR 0.152.
 */
package pt.lsts.neptus.plugins.alignment;

import com.google.common.eventbus.Subscribe;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import pt.lsts.imc.AlignmentState;
import pt.lsts.imc.EntityActivationState;
import pt.lsts.imc.EntityParameter;
import pt.lsts.imc.EntityState;
import pt.lsts.imc.EstimatedState;
import pt.lsts.imc.IMCMessage;
import pt.lsts.imc.QueryEntityActivationState;
import pt.lsts.imc.SetEntityParameters;
import pt.lsts.neptus.comm.manager.imc.EntitiesResolver;
import pt.lsts.neptus.console.ConsoleLayout;
import pt.lsts.neptus.console.ConsolePanel;
import pt.lsts.neptus.console.events.ConsoleEventMainSystemChange;
import pt.lsts.neptus.console.notifications.Notification;
import pt.lsts.neptus.i18n.I18n;
import pt.lsts.neptus.mp.Maneuver;
import pt.lsts.neptus.mp.ManeuverLocation;
import pt.lsts.neptus.mp.templates.PlanCreator;
import pt.lsts.neptus.plugins.NeptusProperty;
import pt.lsts.neptus.plugins.PluginDescription;
import pt.lsts.neptus.plugins.Popup;
import pt.lsts.neptus.plugins.update.IPeriodicUpdates;
import pt.lsts.neptus.types.coord.LocationType;
import pt.lsts.neptus.types.mission.plan.PlanType;
import pt.lsts.neptus.util.GuiUtils;
import pt.lsts.neptus.util.ImageUtils;
import pt.lsts.neptus.util.speech.SpeechUtil;

@PluginDescription(author="ZP", name="IMU Alignment")
@Popup(accelerator=73, pos=Popup.POSITION.CENTER, height=300, width=300, name="IMU Alignment")
public class ImuAlignmentPanel
extends ConsolePanel
implements IPeriodicUpdates {
    private static final long serialVersionUID = -1330079540844029305L;
    protected JToggleButton enableImu;
    protected JButton doAlignment;
    protected JEditorPane status;
    @NeptusProperty(name="IMU Entity Label", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public String imuEntity = "IMU";
    @NeptusProperty(name="Navigation Entity Label", userLevel=NeptusProperty.LEVEL.ADVANCED)
    public String navEntity = "Navigation";
    @NeptusProperty(name="Square Side Length", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double squareSideLength = 80.0;
    @NeptusProperty(name="Alignment Speed", userLevel=NeptusProperty.LEVEL.REGULAR)
    public double alignSpeed = 1.25;
    @NeptusProperty(name="Alignment Speed Units", userLevel=NeptusProperty.LEVEL.REGULAR)
    public Maneuver.SPEED_UNITS alignSpeedUnits = Maneuver.SPEED_UNITS.METERS_PS;
    @NeptusProperty(name="Use Error Notifications", userLevel=NeptusProperty.LEVEL.ADVANCED, description="Use an error instead of warning when navigation becomes not aligned")
    public boolean useErrorNotification = false;
    @NeptusProperty(name="Use Audio Alerts", userLevel=NeptusProperty.LEVEL.REGULAR)
    public boolean useAudioAlerts = true;
    private boolean aligned = false;
    protected ImageIcon greenLed = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/alignment/led_green.png");
    protected ImageIcon redLed = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/alignment/led_red.png");
    protected ImageIcon grayLed = ImageUtils.getIcon((String)"pt/lsts/neptus/plugins/alignment/led_none.png");

    public ImuAlignmentPanel(ConsoleLayout console) {
        super(console);
        this.setLayout(new BorderLayout(3, 3));
        this.removeAll();
        JPanel top = new JPanel(new GridLayout(1, 0));
        this.enableImu = new JToggleButton(I18n.text((String)"Enable IMU"), this.grayLed, false);
        this.enableImu.setToolTipText(I18n.text((String)"Waiting for first IMU alignment state"));
        this.enableImu.setEnabled(false);
        top.add(this.enableImu);
        this.enableImu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImuAlignmentPanel.this.toggleImu(ImuAlignmentPanel.this.enableImu.isSelected());
            }
        });
        this.doAlignment = new JButton(I18n.text((String)"Do Alignment"));
        top.add(this.doAlignment);
        this.status = new JEditorPane("text/html", this.updateState());
        this.doAlignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImuAlignmentPanel.this.doAlignment();
            }
        });
        this.add(top, "North");
        this.add(this.status, "Center");
    }

    public long millisBetweenUpdates() {
        return 1000L;
    }

    public boolean update() {
        int imuId = EntitiesResolver.resolveId((String)this.getMainVehicleId(), (String)this.imuEntity);
        if (imuId != -1) {
            QueryEntityActivationState qeas = new QueryEntityActivationState();
            qeas.setDstEnt(imuId);
            this.send((IMCMessage)qeas);
        }
        this.status.setText(this.updateState());
        return true;
    }

    public String updateState() {
        AlignmentState alignState = this.getState().lastAlignmentState();
        EntityState imuState = (EntityState)this.getState().get(1, EntitiesResolver.resolveId((String)this.getMainVehicleId(), (String)this.imuEntity));
        EntityActivationState imuActivationState = (EntityActivationState)this.getState().get(14, EntitiesResolver.resolveId((String)this.getMainVehicleId(), (String)this.imuEntity));
        if (imuState == null) {
            this.enableImu.setEnabled(false);
            this.enableImu.setIcon(this.grayLed);
        } else {
            boolean active = false;
            if (imuActivationState != null) {
                switch (imuActivationState.getState()) {
                    case ACTIVE: {
                        active = true;
                        break;
                    }
                    default: {
                        active = false;
                        break;
                    }
                }
            } else {
                String activeStr = imuState.getDescription();
                if ("active".equalsIgnoreCase(activeStr) || I18n.text((String)"active").equalsIgnoreCase(activeStr)) {
                    active = true;
                }
            }
            if (active) {
                this.enableImu.setSelected(true);
                this.enableImu.setIcon(this.greenLed);
                this.enableImu.setText(I18n.text((String)"IMU Enabled"));
                this.enableImu.setToolTipText(null);
            } else {
                this.enableImu.setSelected(false);
                this.enableImu.setIcon(this.redLed);
                this.enableImu.setText(I18n.text((String)"Enable IMU"));
                this.enableImu.setToolTipText(null);
                this.enableImu.setIcon(this.grayLed);
            }
        }
        if (alignState == null) {
            return "<html><h1>" + I18n.text((String)"Waiting for IMU alignment state") + "</h1></html>";
        }
        switch (alignState.getState()) {
            case ALIGNED: {
                this.enableImu.setToolTipText(I18n.text((String)"IMU aligned. Vehicle can be used in dead-reckoning mode."));
                this.enableImu.setEnabled(true);
                return "<html><h1><font color='green'>" + I18n.text((String)"IMU aligned") + "</font></h1>" + "<p>" + I18n.text((String)"Vehicle can now be used to execute dead reckoning missions.") + "</p>" + "</html>";
            }
            case NOT_ALIGNED: {
                this.enableImu.setEnabled(true);
                this.enableImu.setToolTipText(I18n.text((String)"IMU is not aligned"));
                return "<html><h1><font color='red'>" + I18n.text((String)"IMU not aligned") + "</font></h1>" + "<p>" + I18n.text((String)"In order to execute dead reckoning missions, IMU must first be aligned.") + "</p>" + "</html>";
            }
        }
        this.enableImu.setEnabled(false);
        this.enableImu.setToolTipText(I18n.textf((String)"IMU cannot be aligned on %vehicle", (Object[])new Object[]{alignState.getSourceName()}));
        this.enableImu.setSelected(false);
        return "<html><h1><font color='red'>" + I18n.text((String)"IMU cannot be aligned") + "</font></h1>" + "<p>" + I18n.text((String)"This vehicle does not support IMU alignment.") + "</p>" + "</html>";
    }

    public void doAlignment() {
        int opt = GuiUtils.confirmDialog((Component)this.getConsole(), (String)I18n.text((String)"Alignment Procedure"), (String)("<html><h2>" + I18n.text((String)"Alignment Procedure") + "</h2>" + I18n.text((String)"To do IMU alignment, the vehicle must do straigth segments at the surface.") + "<br>" + "<b>" + I18n.text((String)"Do you want me to create a plan at surface for you?") + "</b>"));
        if (opt == 0) {
            EstimatedState lastState = this.getState().lastEstimatedState();
            PlanCreator pc = new PlanCreator(this.getConsole().getMission());
            if (lastState != null && lastState.getLat() != 0.0) {
                LocationType loc = new LocationType(Math.toDegrees(lastState.getLat()), Math.toDegrees(lastState.getLon()));
                loc.translatePosition(lastState.getX(), lastState.getY(), 0.0);
                pc.setLocation(loc);
            } else {
                pc.setLocation(new LocationType((LocationType)this.getConsole().getMission().getHomeRef()));
            }
            pc.setSpeed(this.alignSpeed, this.alignSpeedUnits);
            pc.setZ(0.0, ManeuverLocation.Z_UNITS.DEPTH);
            pc.addGoto(null);
            pc.move(this.squareSideLength, 0.0);
            pc.addGoto(null);
            pc.move(0.0, -this.squareSideLength);
            pc.addGoto(null);
            pc.move(-this.squareSideLength, 0.0);
            pc.addGoto(null);
            pc.move(0.0, this.squareSideLength);
            pc.addGoto(null);
            PlanType pt = pc.getPlan();
            pt.setId("alignment_template");
            pt.setMissionType(this.getConsole().getMission());
            pt.setVehicle(this.getConsole().getMainSystem());
            this.getConsole().getMission().addPlan(pt);
            this.getConsole().setPlan(pt);
            this.getConsole().warnMissionListeners();
            this.getConsole().getMission().save(true);
        }
    }

    public void toggleImu(boolean newState) {
        Vector<EntityParameter> params = new Vector<EntityParameter>();
        params.add(new EntityParameter("Active", "" + newState));
        SetEntityParameters m = new SetEntityParameters(this.imuEntity, params);
        this.send((IMCMessage)m);
    }

    public void initSubPanel() {
    }

    @Subscribe
    public void on(ConsoleEventMainSystemChange evt) {
        this.update();
    }

    @Subscribe
    public void on(EntityState entityState) {
        if (!entityState.getSourceName().equals(this.getMainVehicleId())) {
            return;
        }
        int eid = EntitiesResolver.resolveId((String)this.getMainVehicleId(), (String)"Navigation");
        if (eid == -1) {
            eid = EntitiesResolver.resolveId((String)this.getMainVehicleId(), (String)I18n.text((String)"Navigation"));
        }
        if (entityState.getSrcEnt() != eid) {
            return;
        }
        boolean wasAligned = this.aligned;
        this.aligned = !entityState.getDescription().equals("not aligned") && !entityState.getDescription().equals(I18n.text((String)"not aligned"));
        if (!this.aligned && wasAligned) {
            if (this.useErrorNotification) {
                this.post(Notification.error((String)I18n.text((String)"Navigation"), (String)I18n.text((String)"IMU is not aligned")));
            } else {
                this.post(Notification.warning((String)I18n.text((String)"Navigation"), (String)I18n.text((String)"IMU is not aligned")));
            }
            if (this.useAudioAlerts) {
                SpeechUtil.readSimpleText((String)"I M U is not aligned");
            }
        }
        if (this.aligned && !wasAligned) {
            this.post(Notification.info((String)I18n.text((String)"Navigation"), (String)I18n.text((String)"IMU is ready")));
            if (this.useAudioAlerts && (entityState.getDescription().equals("aligned") || entityState.getDescription().equals(I18n.text((String)"aligned")))) {
                SpeechUtil.readSimpleText((String)"I M U is ready");
            }
        }
    }

    public void cleanSubPanel() {
    }
}

