/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.BlendAttributes;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.LineAttributes;
import org.j3d.aviatrix3d.Material;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.PointAttributes;
import org.j3d.aviatrix3d.PolygonAttributes;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shader;
import org.j3d.aviatrix3d.TextureUnit;

public class Appearance
extends NodeComponent
implements RenderableObject {
    private static final Integer[] TEX_IDS = new Integer[32];
    private static final Integer SINGLE_TEXTURE;
    private Material material;
    private TextureUnit[] textureUnits;
    private int numTextures;
    private Shader shader;
    private PolygonAttributes polyAttr;
    private LineAttributes lineAttr;
    private PointAttributes pointAttr;
    private BlendAttributes blendAttr;
    private boolean visible = true;

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.material != null) {
            this.material.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.blendAttr != null) {
            this.blendAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.polyAttr != null) {
            this.polyAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.lineAttr != null) {
            this.lineAttr.setUpdateHandler(nodeUpdateHandler);
        }
        if (this.pointAttr != null) {
            this.pointAttr.setUpdateHandler(nodeUpdateHandler);
        }
        for (int i = 0; i < this.numTextures; ++i) {
            this.textureUnits[i].setUpdateHandler(nodeUpdateHandler);
        }
        if (this.shader != null) {
            this.shader.setUpdateHandler(this.updateHandler);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.numTextures != 0) {
                for (int i = 0; i < this.numTextures; ++i) {
                    this.textureUnits[i].setLive(bl);
                }
            }
            if (this.polyAttr != null) {
                this.polyAttr.setLive(bl);
            }
            if (this.lineAttr != null) {
                this.lineAttr.setLive(bl);
            }
            if (this.pointAttr != null) {
                this.pointAttr.setLive(bl);
            }
            if (this.blendAttr != null) {
                this.blendAttr.setLive(bl);
            }
            if (this.material != null) {
                this.material.setLive(bl);
            }
            if (this.shader != null) {
                this.shader.setLive(bl);
            }
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.numTextures; ++i) {
            this.textureUnits[i].checkForCyclicChild(sceneGraphObject);
        }
    }

    public void render(GL gL, GLU gLU) {
        if (this.numTextures == 1) {
            gL.glPushAttrib(262144);
            this.textureUnits[0].render(gL, gLU, SINGLE_TEXTURE);
        } else if (this.numTextures > 1) {
            gL.glPushAttrib(262144);
            for (int i = 0; i < this.numTextures; ++i) {
                this.textureUnits[i].render(gL, gLU, TEX_IDS[i]);
            }
        }
        if (this.blendAttr != null) {
            this.blendAttr.render(gL, gLU);
        }
        if (this.polyAttr != null) {
            this.polyAttr.render(gL, gLU);
        }
        if (this.lineAttr != null) {
            this.lineAttr.render(gL, gLU);
        }
        if (this.pointAttr != null) {
            this.pointAttr.render(gL, gLU);
        }
        if (this.material != null) {
            gL.glPushAttrib(64);
            this.material.render(gL, gLU);
        }
        if (this.shader != null) {
            this.shader.render(gL, gLU);
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (this.shader != null) {
            this.shader.postRender(gL, gLU);
        }
        if (this.material != null) {
            this.material.postRender(gL, gLU);
            gL.glPopAttrib();
        }
        if (this.pointAttr != null) {
            this.pointAttr.postRender(gL, gLU);
        }
        if (this.lineAttr != null) {
            this.lineAttr.postRender(gL, gLU);
        }
        if (this.polyAttr != null) {
            this.polyAttr.postRender(gL, gLU);
        }
        if (this.blendAttr != null) {
            this.blendAttr.postRender(gL, gLU);
        }
        if (this.numTextures == 1) {
            this.textureUnits[0].postRender(gL, gLU, SINGLE_TEXTURE);
            gL.glPopAttrib();
        } else if (this.numTextures > 1) {
            for (int i = this.numTextures - 1; i >= 0; --i) {
                this.textureUnits[i].postRender(gL, gLU, TEX_IDS[i]);
            }
            gL.glPopAttrib();
        }
    }

    public void setVisible(boolean bl) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.visible = bl;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setMaterial(Material material) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.material != null) {
            this.material.setLive(false);
        }
        this.material = material;
        if (this.material != null) {
            this.material.setUpdateHandler(this.updateHandler);
            this.material.setLive(this.alive);
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setPolygonAttributes(PolygonAttributes polygonAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.polyAttr != null) {
            this.polyAttr.setLive(false);
        }
        this.polyAttr = polygonAttributes;
        if (this.polyAttr != null) {
            this.polyAttr.setUpdateHandler(this.updateHandler);
            this.polyAttr.setLive(this.alive);
        }
    }

    public PolygonAttributes getPolygonAttributes() {
        return this.polyAttr;
    }

    public void setLineAttributes(LineAttributes lineAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.lineAttr != null) {
            this.lineAttr.setLive(false);
        }
        this.lineAttr = lineAttributes;
        if (this.lineAttr != null) {
            this.lineAttr.setUpdateHandler(this.updateHandler);
            this.lineAttr.setLive(this.alive);
        }
    }

    public LineAttributes getLineAttributes() {
        return this.lineAttr;
    }

    public void setPointAttributes(PointAttributes pointAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.pointAttr != null) {
            this.pointAttr.setLive(false);
        }
        this.pointAttr = pointAttributes;
        if (this.pointAttr != null) {
            this.pointAttr.setUpdateHandler(this.updateHandler);
            this.pointAttr.setLive(this.alive);
        }
    }

    public PointAttributes getPointAttributes() {
        return this.pointAttr;
    }

    public void setBlendAttributes(BlendAttributes blendAttributes) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.blendAttr != null) {
            this.blendAttr.setLive(false);
        }
        this.blendAttr = blendAttributes;
        if (this.blendAttr != null) {
            this.blendAttr.setUpdateHandler(this.updateHandler);
            this.blendAttr.setLive(this.alive);
        }
    }

    public BlendAttributes getBlendAttributes() {
        return this.blendAttr;
    }

    public void setShader(Shader shader) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.shader != null) {
            this.shader.setLive(false);
        }
        this.shader = shader;
        if (this.shader != null) {
            this.shader.setUpdateHandler(this.updateHandler);
            this.shader.setLive(this.alive);
        }
    }

    public Shader getShader() {
        return this.shader;
    }

    public void setTextureUnits(TextureUnit[] textureUnitArray, int n) throws InvalidWriteTimingException {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.textureUnits == null || this.textureUnits.length < n) {
            this.textureUnits = new TextureUnit[n];
        }
        for (n2 = this.numTextures; n2 < n; ++n2) {
            this.textureUnits[n2] = null;
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.textureUnits[n2] = textureUnitArray[n2];
            this.textureUnits[n2].setUpdateHandler(this.updateHandler);
        }
        this.numTextures = n;
    }

    public int numTextureUnits() {
        return this.numTextures;
    }

    public void getTextureUnits(TextureUnit[] textureUnitArray) {
        if (textureUnitArray.length < this.numTextures) {
            throw new IllegalArgumentException("Array size is too small");
        }
        for (int i = 0; i < this.numTextures; ++i) {
            textureUnitArray[i] = this.textureUnits[i];
        }
    }

    static {
        for (int i = 0; i < 32; ++i) {
            Appearance.TEX_IDS[i] = new Integer(33984 + i);
        }
        SINGLE_TEXTURE = new Integer(-1);
    }
}

