/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.AudioSource;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.iutil.AudioUpdateListener;

public abstract class AudioComponent
extends NodeComponent
implements AudioSource {
    private static final int LISTENER_SIZE = 1;
    private static final int LISTENER_INC = 2;
    protected ByteBuffer data;
    private int bufferId = -1;
    private AudioUpdateListener[] listeners = new AudioUpdateListener[1];
    private int numListeners;
    protected int format;
    protected int frequency;
    protected float pitch = 1.0f;
    protected boolean loop;

    public int getFormat() {
        return this.format;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public boolean getLoop() {
        return this.loop;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
        this.sendParamUpdate();
    }

    public void setPitch(float f) {
        this.pitch = f;
        this.sendParamUpdate();
    }

    public int getBufferId(AL aL, int n) {
        if (this.bufferId != -1) {
            return this.bufferId;
        }
        int[] nArray = new int[1];
        aL.alGenBuffers(1, nArray);
        if (aL.alGetError() != 0) {
            System.out.println("Error creating OpenAL Buffer");
            return -1;
        }
        aL.alBufferData(nArray[0], this.format, this.data, this.data.limit(), this.frequency);
        this.bufferId = nArray[0];
        return this.bufferId;
    }

    public void addUpdateListener(AudioUpdateListener audioUpdateListener) {
        if (this.numListeners == this.listeners.length) {
            int n = this.listeners.length;
            int n2 = n + 2;
            AudioUpdateListener[] audioUpdateListenerArray = new AudioUpdateListener[n2];
            System.arraycopy(this.listeners, 0, audioUpdateListenerArray, 0, n);
            this.listeners = audioUpdateListenerArray;
        }
        this.listeners[this.numListeners++] = audioUpdateListener;
    }

    public void removeUpdateListener(AudioUpdateListener audioUpdateListener) {
        block2: {
            block1: {
                if (this.numListeners != 1) break block1;
                if (this.listeners[0] != audioUpdateListener) break block2;
                this.listeners[0] = null;
                --this.numListeners;
                break block2;
            }
            for (int i = 0; i < this.numListeners; ++i) {
                if (this.listeners[i] != audioUpdateListener) continue;
                System.arraycopy(this.listeners, i + 1, this.listeners, i, this.numListeners - i - 1);
                break;
            }
        }
    }

    public abstract void clearLocalData();

    protected void sendAudioUpdate(int n) {
        for (int i = 0; i < this.numListeners; ++i) {
            try {
                this.listeners[i].audioUpdated(this.format, this.frequency, n);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending update " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    protected void sendParamUpdate() {
        for (int i = 0; i < this.numListeners; ++i) {
            try {
                this.listeners[i].paramsUpdated(this.loop, this.pitch);
                continue;
            }
            catch (Exception exception) {
                System.out.println("Error sending update " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }
}

