/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.Sound;

public class BackgroundSound
extends Sound {
    int source;
    private Point3f position = new Point3f();
    private Point3f tmpPoint = new Point3f();

    public void render(AL aL, Matrix4f matrix4f) {
        int n;
        if (this.dataChanged) {
            this.buffer = this.soundSource.getBufferId(aL, this.seq);
            if (this.buffer == -1) {
                return;
            }
            this.dataChanged = false;
            this.playChanged = true;
            int[] nArray = new int[1];
            aL.alGenSources(1, nArray);
            this.source = nArray[0];
            if (aL.alGetError() != 0) {
                System.out.println("Error creating OpenAL Source");
            }
            aL.alSourcei(this.source, 4105, this.buffer);
            aL.alSourcef(this.source, 4106, 1.0f);
            aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
            aL.alSourcei(this.source, 514, 1);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            aL.alSourcef(this.source, 4099, this.pitch);
            if (aL.alGetError() != 0) {
                System.out.println("Error setting OpenAL Source params");
            }
        }
        if (this.paramsChanged) {
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            this.paramsChanged = false;
        }
        if (this.playChanged) {
            if (this.playing && this.paused) {
                aL.alSourcePlay(this.source);
            }
            if (this.playing) {
                if (this.paused) {
                    aL.alSourcePause(this.source);
                } else {
                    aL.alSourcePlay(this.source);
                }
            } else {
                aL.alSourceStop(this.source);
            }
            this.playChanged = false;
        } else if (this.playing && (n = aL.alGetSourcei(this.source, 4112)) == 4116) {
            this.playing = false;
        }
    }

    public void postRender(AL aL) {
    }

    public boolean isEnabled() {
        return true;
    }
}

