/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.io.Serializable;
import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.RenderableObject;

public class BlendAttributes
extends NodeComponent
implements Comparable,
RenderableObject {
    private static final String DEST_ALPHA_MSG = "BLEND_SRC_ALPHA_SATURATE is not permitted as a destination mode";
    private static final String INVALID_BLEND_MSG = "The provided blend factor ID is not recognised by the system.";
    public static final int BLEND_ZERO = 0;
    public static final int BLEND_ONE = 1;
    public static final int BLEND_SRC_COLOR = 768;
    public static final int BLEND_ONE_MINUS_SRC_COLOR = 769;
    public static final int BLEND_DEST_COLOR = 774;
    public static final int BLEND_ONE_MINUS_DEST_COLOR = 775;
    public static final int BLEND_SRC_ALPHA = 770;
    public static final int BLEND_ONE_MINUS_SRC_ALPHA = 771;
    public static final int BLEND_DEST_ALPHA = 772;
    public static final int BLEND_ONE_MINUS_DEST_ALPHA = 773;
    public static final int BLEND_CONSTANT_COLOR = 32769;
    public static final int BLEND_ONE_MINUS_CONSTANT_COLOR = 32770;
    public static final int BLEND_CONSTANT_ALPHA = 32771;
    public static final int BLEND_ONE_MINUS_CONSTANT_ALPHA = 32772;
    public static final int BLEND_SRC_ALPHA_SATURATE = 776;
    public static final int EQ_FUNC_ADD = 32774;
    public static final int EQ_FUNC_SUBTRACT = 32778;
    public static final int EQ_FUNC_SUBTRACT_REVERSE = 32779;
    public static final int EQ_FUNC_MIN = 32775;
    public static final int EQ_FUNC_MAX = 32776;
    private static boolean hasImaging = false;
    private static boolean queryComplete;
    private int rgbSourceMode = 768;
    private int rgbDestMode = 769;
    private int blendEquation = 32774;
    private int alphaSourceMode = 770;
    private int alphaDestMode = 771;
    private boolean useSeparatedBlend = false;
    private float[] blendColor;
    private boolean needBlendColor = false;
    private boolean stateChanged = true;
    private HashMap displayListMap = new HashMap(1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL, GLU gLU) {
        Serializable serializable;
        if (!queryComplete) {
            hasImaging = gL.isExtensionAvailable("GL_ARB_imaging");
            queryComplete = true;
            if (!hasImaging) {
                System.out.println("Video card incapable of supporting OpenGL imaging subset. Blending disabled.");
            }
        }
        if (!hasImaging) {
            return;
        }
        if (this.stateChanged) {
            serializable = this.displayListMap;
            synchronized (serializable) {
                this.displayListMap.clear();
                this.stateChanged = false;
            }
        }
        if ((serializable = (Integer)this.displayListMap.get(gL)) == null) {
            serializable = new Integer(gL.glGenLists(1));
            gL.glNewList(((Integer)serializable).intValue(), 4865);
            gL.glEnable(3042);
            gL.glBlendEquation(this.blendEquation);
            if (this.needBlendColor) {
                gL.glBlendColor(this.blendColor[0], this.blendColor[1], this.blendColor[2], this.blendColor[3]);
            }
            if (this.useSeparatedBlend) {
                gL.glBlendFuncSeparate(this.rgbSourceMode, this.rgbDestMode, this.alphaSourceMode, this.alphaDestMode);
            } else {
                gL.glBlendFunc(this.rgbSourceMode, this.rgbDestMode);
            }
            gL.glEndList();
            this.displayListMap.put(gL, serializable);
        } else {
            gL.glCallList(((Integer)serializable).intValue());
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (!hasImaging) {
            return;
        }
        gL.glDisable(3042);
    }

    public int compareTo(Object object) throws ClassCastException {
        BlendAttributes blendAttributes = (BlendAttributes)object;
        return this.compareTo(blendAttributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof BlendAttributes)) {
            return false;
        }
        return this.equals((BlendAttributes)object);
    }

    public void setSourceBlendFactor(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 32769: 
            case 32770: 
            case 32771: 
            case 32772: {
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_BLEND_MSG);
            }
        }
        if (this.rgbSourceMode != n) {
            this.rgbSourceMode = n;
            this.stateChanged = true;
            this.needBlendColor = this.rgbSourceMode == 32769 || this.rgbSourceMode == 32770 || this.rgbSourceMode == 32771 || this.rgbSourceMode == 32772 || this.rgbDestMode == 32769 || this.rgbDestMode == 32770 || this.rgbDestMode == 32771 || this.rgbDestMode == 32772 || this.alphaSourceMode == 32769 || this.alphaSourceMode == 32770 || this.alphaSourceMode == 32771 || this.alphaSourceMode == 32772 || this.alphaDestMode == 32769 || this.alphaDestMode == 32770 || this.alphaDestMode == 32771 || this.alphaDestMode == 32772;
        }
    }

    public int getSourceBlendFactor() {
        return this.rgbSourceMode;
    }

    public void setDestinationBlendFactor(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 32769: 
            case 32770: 
            case 32771: 
            case 32772: {
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_BLEND_MSG);
            }
        }
        if (n == 776) {
            throw new IllegalArgumentException(DEST_ALPHA_MSG);
        }
        if (this.rgbDestMode != n) {
            this.rgbDestMode = n;
            this.stateChanged = true;
            this.needBlendColor = this.rgbSourceMode == 32769 || this.rgbSourceMode == 32770 || this.rgbSourceMode == 32771 || this.rgbSourceMode == 32772 || this.rgbDestMode == 32769 || this.rgbDestMode == 32770 || this.rgbDestMode == 32771 || this.rgbDestMode == 32772 || this.alphaSourceMode == 32769 || this.alphaSourceMode == 32770 || this.alphaSourceMode == 32771 || this.alphaSourceMode == 32772 || this.alphaDestMode == 32769 || this.alphaDestMode == 32770 || this.alphaDestMode == 32771 || this.alphaDestMode == 32772;
        }
    }

    public int getDestinationBlendFactor() {
        return this.rgbDestMode;
    }

    public void setAlphaSourceBlendFactor(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 32769: 
            case 32770: 
            case 32771: 
            case 32772: {
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_BLEND_MSG);
            }
        }
        if (this.alphaSourceMode != n) {
            this.alphaSourceMode = n;
            this.stateChanged = true;
            this.needBlendColor = this.rgbSourceMode == 32769 || this.rgbSourceMode == 32770 || this.rgbSourceMode == 32771 || this.rgbSourceMode == 32772 || this.rgbDestMode == 32769 || this.rgbDestMode == 32770 || this.rgbDestMode == 32771 || this.rgbDestMode == 32772 || this.alphaSourceMode == 32769 || this.alphaSourceMode == 32770 || this.alphaSourceMode == 32771 || this.alphaSourceMode == 32772 || this.alphaDestMode == 32769 || this.alphaDestMode == 32770 || this.alphaDestMode == 32771 || this.alphaDestMode == 32772;
        }
    }

    public int getAlphaSourceBlendFactor() {
        return this.rgbSourceMode;
    }

    public void setAlphaDestinationBlendFactor(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 1: 
            case 768: 
            case 769: 
            case 770: 
            case 771: 
            case 772: 
            case 773: 
            case 774: 
            case 775: 
            case 776: 
            case 32769: 
            case 32770: 
            case 32771: 
            case 32772: {
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_BLEND_MSG);
            }
        }
        if (n == 776) {
            throw new IllegalArgumentException(DEST_ALPHA_MSG);
        }
        if (this.alphaDestMode != n) {
            this.alphaDestMode = n;
            this.stateChanged = true;
            this.needBlendColor = this.rgbSourceMode == 32769 || this.rgbSourceMode == 32770 || this.rgbSourceMode == 32771 || this.rgbSourceMode == 32772 || this.rgbDestMode == 32769 || this.rgbDestMode == 32770 || this.rgbDestMode == 32771 || this.rgbDestMode == 32772 || this.alphaSourceMode == 32769 || this.alphaSourceMode == 32770 || this.alphaSourceMode == 32771 || this.alphaSourceMode == 32772 || this.alphaDestMode == 32769 || this.alphaDestMode == 32770 || this.alphaDestMode == 32771 || this.alphaDestMode == 32772;
        }
    }

    public int getAlphaDestinationBlendFactor() {
        return this.alphaDestMode;
    }

    public void setSeparatedBlendFactors(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.useSeparatedBlend != bl) {
            this.useSeparatedBlend = bl;
            this.stateChanged = true;
        }
    }

    public boolean getSeparatedBlendFactors() {
        return this.useSeparatedBlend;
    }

    public void setBlendColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.blendColor == null) {
            this.blendColor = new float[4];
        }
        this.blendColor[0] = f;
        this.blendColor[1] = f2;
        this.blendColor[2] = f3;
        this.blendColor[3] = f4;
        this.stateChanged = true;
    }

    public void getBlendColor(float[] fArray) {
        if (this.blendColor == null) {
            return;
        }
        fArray[0] = this.blendColor[0];
        fArray[1] = this.blendColor[1];
        fArray[2] = this.blendColor[2];
        fArray[3] = this.blendColor[3];
    }

    public int compareTo(BlendAttributes blendAttributes) {
        if (blendAttributes == null) {
            return 1;
        }
        if (blendAttributes == this) {
            return 0;
        }
        if (this.useSeparatedBlend != blendAttributes.useSeparatedBlend) {
            return this.useSeparatedBlend ? 1 : -1;
        }
        if (this.blendEquation != blendAttributes.blendEquation) {
            return this.blendEquation < blendAttributes.blendEquation ? 1 : -1;
        }
        if (this.rgbSourceMode != blendAttributes.rgbSourceMode) {
            return this.rgbSourceMode < blendAttributes.rgbSourceMode ? -1 : 1;
        }
        if (this.rgbDestMode != blendAttributes.rgbDestMode) {
            return this.rgbDestMode < blendAttributes.rgbDestMode ? -1 : 1;
        }
        if (this.alphaSourceMode != blendAttributes.alphaSourceMode) {
            return this.alphaSourceMode < blendAttributes.alphaSourceMode ? -1 : 1;
        }
        if (this.alphaDestMode != blendAttributes.alphaDestMode) {
            return this.alphaDestMode < blendAttributes.alphaDestMode ? -1 : 1;
        }
        if (this.needBlendColor != blendAttributes.needBlendColor) {
            return this.needBlendColor ? 1 : -1;
        }
        if (this.needBlendColor) {
            if (this.blendColor[0] < blendAttributes.blendColor[0]) {
                return -1;
            }
            if (this.blendColor[0] > blendAttributes.blendColor[0]) {
                return 1;
            }
            if (this.blendColor[1] < blendAttributes.blendColor[1]) {
                return -1;
            }
            if (this.blendColor[1] > blendAttributes.blendColor[1]) {
                return 1;
            }
            if (this.blendColor[2] < blendAttributes.blendColor[2]) {
                return -1;
            }
            if (this.blendColor[2] > blendAttributes.blendColor[2]) {
                return 1;
            }
            if (this.blendColor[3] < blendAttributes.blendColor[3]) {
                return -1;
            }
            if (this.blendColor[3] > blendAttributes.blendColor[3]) {
                return 1;
            }
        }
        return 0;
    }

    public boolean equals(BlendAttributes blendAttributes) {
        if (blendAttributes == this) {
            return true;
        }
        if (blendAttributes == null || this.useSeparatedBlend != blendAttributes.useSeparatedBlend || this.blendEquation != blendAttributes.blendEquation || this.rgbSourceMode != blendAttributes.rgbSourceMode || this.rgbDestMode != blendAttributes.rgbDestMode || this.alphaSourceMode != blendAttributes.alphaSourceMode || this.alphaDestMode != blendAttributes.alphaDestMode || this.needBlendColor != blendAttributes.needBlendColor) {
            return false;
        }
        return !this.needBlendColor || this.blendColor[0] == blendAttributes.blendColor[0] && this.blendColor[1] == blendAttributes.blendColor[1] && this.blendColor[2] == blendAttributes.blendColor[2] && this.blendColor[3] == blendAttributes.blendColor[3];
    }

    public boolean isBlendingAvailable() {
        return hasImaging;
    }
}

