/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent2D;

public class BoxBackground
extends Background
implements DeletableSceneGraphObject {
    private static final float[] BOX_TEX_COORDS = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] BACK_BOX_COORDS = new float[]{1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private static final float[] BACK_BOX_NORMALS = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f};
    private static final float[] FRONT_BOX_COORDS = new float[]{-1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f};
    private static final float[] FRONT_BOX_NORMALS = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] LEFT_BOX_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f};
    private static final float[] LEFT_BOX_NORMALS = new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private static final float[] RIGHT_BOX_COORDS = new float[]{1.0f, -1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] RIGHT_BOX_NORMALS = new float[]{-1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f};
    private static final float[] TOP_BOX_COORDS = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] TOP_BOX_NORMALS = new float[]{0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, -1.0f, 0.0f};
    private static final float[] BOTTOM_BOX_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, -1.0f};
    private static final float[] BOTTOM_BOX_NORMALS = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final int POSITIVE_X = 0;
    public static final int NEGATIVE_X = 1;
    public static final int POSITIVE_Y = 2;
    public static final int NEGATIVE_Y = 3;
    public static final int POSITIVE_Z = 4;
    public static final int NEGATIVE_Z = 5;
    private float[] color = new float[4];
    private TextureComponent2D[] texture = new TextureComponent2D[6];
    private FloatBuffer[] vertexBuffer;
    private FloatBuffer[] normalBuffer;
    private FloatBuffer textureBuffer;
    protected boolean stateChanged = false;
    protected HashMap[] textureIdMap = new HashMap[6];

    public BoxBackground() {
        for (int i = 0; i < 6; ++i) {
            this.textureIdMap[i] = new HashMap();
        }
        this.generateBoxGeom();
    }

    public BoxBackground(float[] fArray) {
        this();
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void cleanup(GL gL, GLU gLU) {
        for (int i = 0; i < 6; ++i) {
            Integer n = (Integer)this.textureIdMap[i].remove(gL);
            if (n == null) continue;
            int[] nArray = new int[]{n};
            gL.glDeleteTextures(1, nArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL, GLU gLU) {
        int n;
        gL.glClearColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        gL.glClear(16384);
        if (this.stateChanged) {
            for (n = 0; n < 6; ++n) {
                HashMap hashMap = this.textureIdMap[n];
                synchronized (hashMap) {
                    this.textureIdMap[n].clear();
                    this.stateChanged = false;
                    continue;
                }
            }
        }
        gL.glEnable(3553);
        gL.glActiveTexture(33984);
        gL.glTexEnvi(8960, 8704, 7681);
        for (n = 0; n < 6; ++n) {
            this.renderGeom(gL, n);
        }
    }

    public void postRender(GL gL, GLU gLU) {
        gL.glDisable(3553);
    }

    public void setColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void setColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.color[0];
        fArray[1] = this.color[1];
        fArray[2] = this.color[2];
        fArray[3] = this.color[3];
    }

    public void setTexture(int n, TextureComponent2D textureComponent2D) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.texture[n] = textureComponent2D;
        this.stateChanged = true;
    }

    public TextureComponent2D getTexture(int n) {
        return this.texture[n];
    }

    private void generateBoxGeom() {
        this.textureBuffer = this.createBuffer(BOX_TEX_COORDS.length);
        this.textureBuffer.put(BOX_TEX_COORDS);
        this.vertexBuffer = new FloatBuffer[6];
        this.normalBuffer = new FloatBuffer[6];
        for (int i = 0; i < 6; ++i) {
            this.vertexBuffer[i] = this.createBuffer(12);
            this.normalBuffer[i] = this.createBuffer(12);
        }
        this.vertexBuffer[0].put(RIGHT_BOX_COORDS);
        this.normalBuffer[0].put(RIGHT_BOX_NORMALS);
        this.vertexBuffer[1].put(LEFT_BOX_COORDS);
        this.normalBuffer[1].put(LEFT_BOX_NORMALS);
        this.vertexBuffer[2].put(TOP_BOX_COORDS);
        this.normalBuffer[2].put(TOP_BOX_NORMALS);
        this.vertexBuffer[3].put(BOTTOM_BOX_COORDS);
        this.normalBuffer[3].put(BOTTOM_BOX_NORMALS);
        this.vertexBuffer[4].put(BACK_BOX_COORDS);
        this.normalBuffer[4].put(BACK_BOX_NORMALS);
        this.vertexBuffer[5].put(FRONT_BOX_COORDS);
        this.normalBuffer[5].put(FRONT_BOX_NORMALS);
    }

    private FloatBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }

    private void renderGeom(GL gL, int n) {
        if (this.texture[n] == null) {
            return;
        }
        Integer n2 = (Integer)this.textureIdMap[n].get(gL);
        if (n2 != null) {
            gL.glBindTexture(3553, n2.intValue());
        } else {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray);
            this.textureIdMap[n].put(gL, new Integer(nArray[0]));
            gL.glBindTexture(3553, nArray[0]);
            gL.glPixelStorei(3317, 1);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10241, 9729);
            ByteBuffer byteBuffer = this.texture[n].getData(0);
            int n3 = this.texture[n].getFormat(0);
            int n4 = this.texture[n].getWidth();
            int n5 = this.texture[n].getHeight();
            int n6 = 6407;
            int n7 = 6407;
            switch (n3) {
                case 1: {
                    n6 = 6407;
                    n7 = 6407;
                    break;
                }
                case 2: {
                    n6 = 6408;
                    n7 = 6408;
                    break;
                }
                case 3: {
                    n6 = 32992;
                    n7 = 32992;
                    break;
                }
                case 4: {
                    n6 = 32993;
                    n7 = 32993;
                    break;
                }
                case 5: {
                    n6 = 6410;
                    n7 = 6410;
                    break;
                }
                case 6: {
                    n6 = 6409;
                    n7 = 6409;
                    break;
                }
            }
            gL.glTexImage2D(3553, 0, n6, n4, n5, 0, n7, 5121, (Buffer)byteBuffer);
        }
        gL.glEnableClientState(32884);
        gL.glEnableClientState(32885);
        gL.glEnableClientState(32888);
        gL.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer[n]);
        gL.glNormalPointer(5126, 0, (Buffer)this.normalBuffer[n]);
        gL.glTexCoordPointer(2, 5126, 0, (Buffer)this.textureBuffer);
        gL.glDrawArrays(5, 0, 4);
        gL.glDisableClientState(32888);
        gL.glDisableClientState(32885);
        gL.glDisableClientState(32884);
    }
}

