/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent3D;

public class ByteTextureComponent3D
extends TextureComponent3D {
    private static final String MATCH_FORMAT_MSG = "Not all images have the same format";
    private byte[][] pixels;

    public ByteTextureComponent3D() {
        this(0, 0, 0, 0, null);
    }

    public ByteTextureComponent3D(boolean bl) {
        this(0, 0, 0, 0, null);
        this.invertY = bl;
    }

    public ByteTextureComponent3D(int n, int n2, int n3, int n4, byte[] byArray) {
        super(1);
        this.width = n2;
        this.height = n3;
        this.format = n;
        this.depth = n4;
        int n5 = byArray == null ? 0 : byArray.length;
        this.pixels = new byte[1][n5];
        System.arraycopy(byArray, 0, this.pixels[0], 0, n5);
    }

    public ByteTextureComponent3D(int n, int n2, int n3, int n4, byte[][] byArray, int n5) {
        super(n5);
        this.width = n2;
        this.height = n3;
        this.format = n;
        this.depth = n4;
        this.pixels = new byte[n5][];
        for (int i = 0; i < n5; ++i) {
            int n6 = byArray[i] == null ? 0 : byArray[i].length;
            this.pixels[i] = new byte[n6];
            System.arraycopy(byArray[i], 0, this.pixels[i], 0, n6);
        }
    }

    public ByteTextureComponent3D(int n, int n2, int n3, int n4, byte[][] byArray, int n5, boolean bl) {
        this(n, n2, n3, n4, byArray, n5);
        this.invertY = bl;
    }

    public void updateSubImage(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.sendTextureUpdate(n, n2, n3, n4, n5, n6, n7, byArray);
    }

    public int getDepth() {
        return this.depth;
    }

    public void clearLocalData() {
    }

    protected ByteBuffer convertImage(int n) {
        ByteBuffer byteBuffer = null;
        byteBuffer = ByteBuffer.allocateDirect(this.pixels[n].length);
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.put(this.pixels[n]);
        return byteBuffer;
    }
}

