/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.ClipPlane;

public class ClipDetails {
    private int hash = 0;
    private ClipPlane clipPlane;
    private float[] transform = new float[16];

    public int compareTo(Object object) throws ClassCastException {
        ClipDetails clipDetails = (ClipDetails)object;
        return this.compareTo(clipDetails);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ClipDetails)) {
            return false;
        }
        ClipDetails clipDetails = (ClipDetails)object;
        if (this.clipPlane != clipDetails.clipPlane) {
            return false;
        }
        for (int i = 0; i < 16; ++i) {
            if (this.transform[i] == clipDetails.transform[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public void update(ClipPlane clipPlane, float[] fArray) {
        this.clipPlane = clipPlane;
        System.arraycopy(fArray, 0, this.transform, 0, 16);
        long l = 0L;
        for (int i = 0; i < 16; ++i) {
            l = 31L * l + (long)Float.floatToIntBits(this.transform[i]);
        }
        this.hash = (int)((l += (long)this.clipPlane.hashCode()) & 0xFFFFFFFFFFFFFFFFL);
    }

    public float[] getTransform() {
        return this.transform;
    }

    public ClipPlane getClipPlane() {
        return this.clipPlane;
    }

    public int compareTo(ClipDetails clipDetails) {
        int n;
        if (clipDetails == this) {
            return 0;
        }
        if (clipDetails == null) {
            return 1;
        }
        if (this.clipPlane != clipDetails.clipPlane) {
            if (this.clipPlane == null) {
                return -1;
            }
            if (clipDetails.clipPlane == null) {
                return 1;
            }
            n = this.clipPlane.compareTo(clipDetails.clipPlane);
            if (n != 0) {
                return n;
            }
        }
        for (n = 0; n < 16; ++n) {
            if (this.transform[n] == clipDetails.transform[n]) continue;
            return this.transform[n] < clipDetails.transform[n] ? -1 : 1;
        }
        return 0;
    }
}

