/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.PointSound;

public class ConeSound
extends PointSound {
    private int source;
    private Point3f position = new Point3f();
    private Point3f tmpPoint = new Point3f();
    private Matrix4f tmpMatrix = new Matrix4f();
    private float[] direction;
    private float innerAngle;
    private float outerAngle;

    public ConeSound() {
        this.refDistance = 0.0f;
        this.maxDistance = Float.MAX_VALUE;
        this.innerAngle = 360.0f;
        this.outerAngle = 360.0f;
        this.direction = new float[]{0.0f, 0.0f, 0.0f};
        this.rolloffFactor = 1.0f;
    }

    public void setRefDistance(float[] fArray) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
    }

    public void setInnerAngle(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.innerAngle = f;
    }

    public void setOuterAngle(float f) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.outerAngle = f;
    }

    public void render(AL aL, Matrix4f matrix4f) {
        int n;
        matrix4f.transform(this.position, this.tmpPoint);
        if (this.dataChanged) {
            this.buffer = this.soundSource.getBufferId(aL, this.seq);
            if (this.buffer == -1) {
                return;
            }
            this.dataChanged = false;
            this.playChanged = true;
            int[] nArray = new int[1];
            aL.alGenSources(1, nArray);
            this.source = nArray[0];
            if (aL.alGetError() != 0) {
                System.out.println("Error creating OpenAL Source");
            }
            aL.alSourcei(this.source, 4105, this.buffer);
            aL.alSourcef(this.source, 4128, this.refDistance);
            aL.alSourcef(this.source, 4129, this.rolloffFactor);
            aL.alSourcef(this.source, 4131, this.maxDistance);
            aL.alSourcef(this.source, 4097, this.innerAngle);
            aL.alSourcef(this.source, 4098, this.outerAngle);
            aL.alSourcefv(this.source, 4101, this.direction);
            aL.alSourcef(this.source, 4106, 1.0f);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
            if (aL.alGetError() != 0) {
                System.out.println("Error setting OpenAL Source params");
            }
        }
        if (this.paramsChanged) {
            aL.alSourcef(this.source, 4099, this.pitch);
            aL.alSourcei(this.source, 4103, this.loop ? 1 : 0);
            this.paramsChanged = false;
        }
        aL.alSource3f(this.source, 4100, this.tmpPoint.x, this.tmpPoint.y, this.tmpPoint.z);
        if (this.playChanged) {
            if (this.playing && this.paused) {
                aL.alSourcePlay(this.source);
            }
            if (this.playing) {
                if (this.paused) {
                    aL.alSourcePause(this.source);
                } else {
                    aL.alSourcePlay(this.source);
                }
            } else {
                aL.alSourceStop(this.source);
            }
            this.playChanged = false;
        } else if (this.playing && (n = aL.alGetSourcei(this.source, 4112)) == 4116) {
            this.playing = false;
        }
    }

    public void postRender(AL aL) {
    }

    public boolean isEnabled() {
        return true;
    }
}

