/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.RenderableObject;

public class Fog
extends Leaf
implements RenderableObject {
    private static final String FOG_RANGE_MSG = "The start distance is greater than the end distance";
    public static final int EXPONENTIAL = 2048;
    public static final int EXPONENTIAL_2 = 2049;
    public static final int LINEAR = 9729;
    private int mode;
    private float density;
    private float startDistance;
    private float endDistance;
    private float[] color;
    private boolean globalOnly;
    private boolean enabled;

    public Fog() {
        this(9729, null, true);
    }

    public Fog(int n) {
        this(n, null, true);
    }

    public Fog(int n, boolean bl) {
        this(n, null, bl);
    }

    public Fog(int n, float[] fArray) {
        this(n, fArray, true);
    }

    public Fog(float[] fArray) {
        this(9729, fArray, true);
    }

    public Fog(float[] fArray, boolean bl) {
        this(9729, fArray, bl);
    }

    public Fog(int n, float[] fArray, boolean bl) {
        this.mode = n;
        this.endDistance = 1.0f;
        this.color = new float[4];
        if (fArray == null) {
            this.color[0] = 1.0f;
            this.color[1] = 1.0f;
            this.color[2] = 1.0f;
            this.color[3] = 1.0f;
        } else {
            this.color[0] = fArray[0];
            this.color[1] = fArray[1];
            this.color[2] = fArray[2];
            this.color[3] = 1.0f;
        }
        this.globalOnly = bl;
        this.enabled = false;
    }

    public void render(GL gL, GLU gLU) {
        gL.glFogi(2917, this.mode);
        gL.glFogfv(2918, this.color);
        switch (this.mode) {
            case 9729: {
                gL.glFogf(2915, this.startDistance);
                gL.glFogf(2916, this.endDistance);
                break;
            }
            case 2048: 
            case 2049: {
                gL.glFogf(2914, this.density);
            }
        }
    }

    public void postRender(GL gL, GLU gLU) {
    }

    protected void markBoundsDirty() {
    }

    public int compareTo(Object object) throws ClassCastException {
        Fog fog = (Fog)object;
        return this.compareTo(fog);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Fog)) {
            return false;
        }
        return this.equals((Fog)object);
    }

    public void setEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.color[0];
        fArray[1] = this.color[1];
        fArray[2] = this.color[2];
    }

    public void setLinearDistance(float f, float f2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f > f2) {
            throw new IllegalArgumentException(FOG_RANGE_MSG);
        }
        this.startDistance = f;
        this.endDistance = f2;
    }

    public void getLinearDistance(float[] fArray) {
        fArray[0] = this.startDistance;
        fArray[1] = this.endDistance;
    }

    public void setDensityRate(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.density = f;
    }

    public float getDensityRate() {
        return this.density;
    }

    public void setMode(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.mode = n;
    }

    public int getMode() {
        return this.mode;
    }

    public void setGlobalOnly(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.globalOnly = bl;
    }

    public boolean isGlobalOnly() {
        return this.globalOnly;
    }

    public int compareTo(Fog fog) {
        if (fog == null) {
            return 1;
        }
        if (fog == this) {
            return 0;
        }
        if (this.mode != fog.mode) {
            return this.mode < fog.mode ? -1 : 1;
        }
        if (this.enabled != fog.enabled) {
            return this.enabled ? 1 : -1;
        }
        if (this.globalOnly != fog.globalOnly) {
            return this.globalOnly ? 1 : -1;
        }
        int n = this.compareColor3(this.color, fog.color);
        if (n != 0) {
            return n;
        }
        if (this.density != fog.density) {
            return this.density < fog.density ? -1 : 1;
        }
        if (this.endDistance != fog.endDistance) {
            return this.endDistance < fog.endDistance ? -1 : 1;
        }
        if ((float)this.mode != fog.startDistance) {
            return this.startDistance < fog.startDistance ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Fog fog) {
        if (fog == this) {
            return true;
        }
        return fog != null && this.mode == fog.mode && this.globalOnly == fog.globalOnly && this.enabled == fog.enabled && this.equalsColor3(this.color, fog.color) && this.density == fog.density && this.endDistance == fog.endDistance && this.startDistance == fog.startDistance;
    }

    private int compareColor3(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        return 0;
    }

    private boolean equalsColor3(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2];
    }
}

