/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Shader;
import org.j3d.aviatrix3d.ShaderArguments;
import org.j3d.aviatrix3d.ShaderProgram;
import org.j3d.util.IntHashMap;

public class GLSLangShader
extends Shader
implements Comparable {
    private IntHashMap idMap = new IntHashMap();
    private ShaderArguments arguments;
    private ShaderProgram program;
    private boolean validationRequired = false;
    private boolean programIsValid = true;

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.program != null) {
            this.program.setUpdateHandler(this.updateHandler);
        }
        if (this.arguments != null) {
            this.arguments.setUpdateHandler(this.updateHandler);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            if (this.program != null) {
                this.program.setLive(bl);
            }
            if (this.arguments != null) {
                this.arguments.setLive(bl);
            }
            super.setLive(bl);
        }
    }

    public void render(GL gL, GLU gLU) {
        Object object;
        int n;
        if (this.program == null || !this.program.isValid(gL)) {
            return;
        }
        this.program.render(gL, gLU);
        if (this.arguments != null) {
            n = this.program.getProgramId(gL);
            object = (Integer)this.idMap.get(n);
            if (object == null) {
                object = new Integer(n);
                this.idMap.put(n, object);
            }
            this.arguments.render(gL, gLU, object);
        }
        if (this.validationRequired) {
            n = this.program.getProgramId(gL);
            gL.glValidateProgramARB(n);
            object = new int[1];
            gL.glGetObjectParameterivARB(n, 35715, (int[])object);
            this.programIsValid = object[0] == true;
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (this.program == null || !this.program.isValid(gL)) {
            return;
        }
        this.program.postRender(gL, gLU);
        if (this.arguments != null) {
            int n = this.program.getProgramId(gL);
            Integer n2 = (Integer)this.idMap.get(n);
            this.arguments.postRender(gL, gLU, n2);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        GLSLangShader gLSLangShader = (GLSLangShader)object;
        return this.compareTo(gLSLangShader);
    }

    public boolean equals(Object object) {
        if (!(object instanceof GLSLangShader)) {
            return false;
        }
        return this.equals((GLSLangShader)object);
    }

    public void setShaderProgram(ShaderProgram shaderProgram) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.program != null) {
            this.program.setLive(false);
        }
        this.program = shaderProgram;
        if (this.program != null) {
            this.program.setLive(this.alive);
            this.program.setUpdateHandler(this.updateHandler);
        }
    }

    public ShaderProgram getShaderProgram() {
        return this.program;
    }

    public void setShaderArguments(ShaderArguments shaderArguments) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.arguments != null) {
            this.arguments.setLive(false);
        }
        this.arguments = shaderArguments;
        if (this.arguments != null) {
            this.arguments.setLive(this.alive);
            this.arguments.setUpdateHandler(this.updateHandler);
        }
    }

    public ShaderArguments getShaderArguments() {
        return this.arguments;
    }

    public void validate() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.validationRequired = true;
    }

    public boolean isValidated() {
        return this.programIsValid;
    }

    public int compareTo(GLSLangShader gLSLangShader) {
        int n;
        if (gLSLangShader == null) {
            return 1;
        }
        if (gLSLangShader == this) {
            return 0;
        }
        if (this.program != gLSLangShader.program) {
            if (this.program == null) {
                return -1;
            }
            if (gLSLangShader.program == null) {
                return 1;
            }
            n = this.program.compareTo(gLSLangShader.program);
            if (n != 0) {
                return n;
            }
        }
        if (this.arguments != gLSLangShader.arguments) {
            if (this.arguments == null) {
                return -1;
            }
            if (gLSLangShader.arguments == null) {
                return 1;
            }
            n = this.arguments.compareTo(gLSLangShader.arguments);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public boolean equals(GLSLangShader gLSLangShader) {
        if (gLSLangShader == this) {
            return true;
        }
        if (gLSLangShader == null) {
            return false;
        }
        if (!(this.program == gLSLangShader.program || this.program != null && this.program.equals(gLSLangShader.program))) {
            return false;
        }
        return this.arguments == gLSLangShader.arguments || this.arguments != null && this.arguments.equals(gLSLangShader.arguments);
    }
}

