/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.IndexedVertexGeometry;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NotPickableException;

public class IndexedQuadStripArray
extends IndexedVertexGeometry {
    private static final String MIN_COUNT_MSG = "A strip with less than 4 vertices is specified at index ";
    private static final String TOTAL_COUNT_MSG = "The total requested indexes in the strip is greater than the number of valid vertices provided.";
    private int[] stripCounts;
    private int numStrips;
    private int[][] stripIndices;

    public IndexedQuadStripArray() {
        this.initPolygonDetails(4);
    }

    public void render(GL gL, GLU gLU) {
        if (this.numStrips == 0 || (this.vertexFormat & 7) == 0) {
            return;
        }
        this.setVertexState(gL, gLU);
        for (int i = 0; i < this.numStrips; ++i) {
            gL.glDrawElements(8, this.stripCounts[i], 5125, this.stripIndices[i]);
        }
        this.clearVertexState(gL, gLU);
    }

    public void postRender(GL gL, GLU gLU) {
    }

    protected boolean isVisible() {
        return super.isVisible() && this.numStrips != 0;
    }

    public boolean pickLineSegment(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineSegment(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = fArray2[0];
        float f6 = fArray2[1];
        float f7 = fArray2[2];
        float f8 = fArray2[0] - fArray[0];
        float f9 = fArray2[1] - fArray[1];
        float f10 = fArray2[2] - fArray[2];
        float f11 = (float)Math.sqrt(f8 * f8 + f9 * f9 + f10 * f10);
        fArray2[0] = f8;
        fArray2[1] = f9;
        fArray2[2] = f10;
        int n2 = 0;
        for (int i = 0; i < this.numStrips; ++i) {
            int n3 = this.stripCounts[i] - 3;
            for (int j = 0; j < n3; ++j) {
                this.wkPolygon[0] = this.coordinates[this.indices[n2] * 3];
                this.wkPolygon[1] = this.coordinates[this.indices[n2] * 3 + 1];
                this.wkPolygon[2] = this.coordinates[this.indices[n2] * 3 + 2];
                this.wkPolygon[3] = this.coordinates[this.indices[n2 + 1] * 3];
                this.wkPolygon[4] = this.coordinates[this.indices[n2 + 1] * 3 + 1];
                this.wkPolygon[5] = this.coordinates[this.indices[n2 + 1] * 3 + 2];
                this.wkPolygon[6] = this.coordinates[this.indices[n2 + 2] * 3];
                this.wkPolygon[7] = this.coordinates[this.indices[n2 + 2] * 3 + 1];
                this.wkPolygon[8] = this.coordinates[this.indices[n2 + 2] * 3 + 2];
                this.wkPolygon[9] = this.coordinates[this.indices[n2 + 3] * 3];
                this.wkPolygon[10] = this.coordinates[this.indices[n2 + 3] * 3 + 1];
                this.wkPolygon[11] = this.coordinates[this.indices[n2 + 3] * 3 + 2];
                n2 += 2;
                if (!this.ray3DTriangleChecked(fArray, fArray2, f11, fArray3)) continue;
                bl2 = true;
                if (bl) break;
                float f12 = fArray[0] - fArray3[0];
                float f13 = fArray[1] - fArray3[1];
                float f14 = fArray[2] - fArray3[2];
                float f15 = f12 * f12 + f13 * f13 + f14 * f14;
                if (!(f15 < f)) continue;
                f = f15;
                f2 = fArray3[0];
                f3 = fArray3[1];
                f4 = fArray3[2];
            }
            n2 += 2;
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        fArray2[0] = f5;
        fArray2[1] = f6;
        fArray2[2] = f7;
        return bl2;
    }

    public boolean pickLineRay(float[] fArray, float[] fArray2, boolean bl, float[] fArray3, int n) throws NotPickableException {
        super.pickLineRay(fArray, fArray2, bl, fArray3, n);
        float f = Float.POSITIVE_INFINITY;
        boolean bl2 = false;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        int n2 = 0;
        for (int i = 0; i < this.numStrips; ++i) {
            int n3 = this.stripCounts[i] - 3;
            for (int j = 0; j < n3; ++j) {
                this.wkPolygon[0] = this.coordinates[this.indices[n2] * 3];
                this.wkPolygon[1] = this.coordinates[this.indices[n2] * 3 + 1];
                this.wkPolygon[2] = this.coordinates[this.indices[n2] * 3 + 2];
                this.wkPolygon[3] = this.coordinates[this.indices[n2 + 1] * 3];
                this.wkPolygon[4] = this.coordinates[this.indices[n2 + 1] * 3 + 1];
                this.wkPolygon[5] = this.coordinates[this.indices[n2 + 1] * 3 + 2];
                this.wkPolygon[6] = this.coordinates[this.indices[n2 + 2] * 3];
                this.wkPolygon[7] = this.coordinates[this.indices[n2 + 2] * 3 + 1];
                this.wkPolygon[8] = this.coordinates[this.indices[n2 + 2] * 3 + 2];
                this.wkPolygon[9] = this.coordinates[this.indices[n2 + 3] * 3];
                this.wkPolygon[10] = this.coordinates[this.indices[n2 + 3] * 3 + 1];
                this.wkPolygon[11] = this.coordinates[this.indices[n2 + 3] * 3 + 2];
                n2 += 2;
                if (!this.ray3DTriangleChecked(fArray, fArray2, 0.0f, fArray3)) continue;
                bl2 = true;
                if (bl) break;
                float f5 = fArray[0] - fArray3[0];
                float f6 = fArray[1] - fArray3[1];
                float f7 = fArray[2] - fArray3[2];
                float f8 = f5 * f5 + f6 * f6 + f7 * f7;
                if (!(f8 < f)) continue;
                f = f8;
                f2 = fArray3[0];
                f3 = fArray3[1];
                f4 = fArray3[2];
            }
            n2 += 2;
        }
        fArray3[0] = f2;
        fArray3[1] = f3;
        fArray3[2] = f4;
        return bl2;
    }

    public void setStripCount(int[] nArray, int n) throws InvalidWriteTimingException {
        int n2;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n3 = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            if (nArray[n2] < 4) {
                throw new IllegalArgumentException(MIN_COUNT_MSG + n2);
            }
            n3 += nArray[n2];
            if (n4 >= nArray[n2]) continue;
            n4 = nArray[n2];
        }
        if (this.stripCounts == null || this.stripCounts.length < n) {
            this.stripCounts = new int[n];
            this.stripIndices = new int[n][n4];
        }
        if (n4 > this.stripIndices[0].length) {
            this.stripIndices = new int[n][n4];
        }
        this.numStrips = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.stripCounts, 0, n);
            n2 = 0;
            for (int i = 0; i < this.numStrips; ++i) {
                System.arraycopy(this.indices, n2, this.stripIndices[i], 0, this.stripCounts[i]);
                n2 += this.stripCounts[i];
            }
        }
    }

    public int getValidStripCount() {
        return this.numStrips;
    }

    public void getStripCount(int[] nArray) {
        System.arraycopy(this.stripCounts, 0, nArray, 0, this.numStrips);
    }
}

