/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.VertexGeometry;

public abstract class IndexedVertexGeometry
extends VertexGeometry {
    private static final String MAX_INDEX_MSG = "The maximum index value provided is greater than the number of coordinates provided to this geometry object.";
    protected int[] indices;
    protected int numIndices;

    protected boolean isVisible() {
        return super.isVisible() && this.numIndices != 0;
    }

    public void setIndices(int[] nArray, int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        if (n2 + 1 > this.numCoords) {
            throw new IllegalArgumentException(MAX_INDEX_MSG);
        }
        this.numRequiredCoords = n2 + 1;
        if (this.indices == null || this.indices.length < n) {
            this.indices = new int[n];
        }
        this.numIndices = n;
        if (n > 0) {
            System.arraycopy(nArray, 0, this.indices, 0, n);
        }
    }

    public int getValidIndexCount() {
        return this.numIndices;
    }

    public void getIndices(int[] nArray) {
        System.arraycopy(this.indices, 0, nArray, 0, this.numIndices);
    }
}

