/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.RenderableObject;

public class Material
extends NodeComponent
implements RenderableObject,
Comparable {
    public static final int AMBIENT_TARGET = 4608;
    public static final int DIFFUSE_TARGET = 4609;
    public static final int SPECULAR_TARGET = 4610;
    public static final int EMISSIVE_TARGET = 5632;
    public static final int AMBIENT_AND_DIFFUSE_TARGET = 5634;
    private static final String COLOR_MATERIAL_TARGET_ERR = "The value provided for the color material target is invalid. It must be one of the *_TARGET values defined by this class.";
    private static final String NO_BACKFACE_WRITE_MSG = "The separate back-face material setting is not currently enabled. You are not permitted to write to this value.";
    private static final String NO_BACKFACE_READ_MSG = "The separate back-face material setting is not currently enabled. You are not permitted to read this value.";
    private static final float[] DEFAULT_DIFFUSE = new float[]{0.8f, 0.8f, 0.8f};
    private static final float[] DEFAULT_AMBIENT = new float[]{0.2f, 0.2f, 0.2f};
    private static final float[] DEFAULT_EMISSIVE = new float[]{0.0f, 0.0f, 0.0f};
    private static final float[] DEFAULT_SPECULAR = new float[]{0.0f, 0.0f, 0.0f};
    private static final float DEFAULT_SHININESS = 0.2f;
    private static final float DEFAULT_TRANSPARENCY = 1.0f;
    private boolean useLighting;
    private float[] diffuseColor = new float[4];
    private float[] backDiffuseColor;
    private float[] ambientColor;
    private float[] backAmbientColor;
    private float[] emissiveColor;
    private float[] backEmissiveColor;
    private float[] specularColor;
    private float[] backSpecularColor;
    private float shininess;
    private float backShininess;
    private boolean useColorMaterial;
    private int colorTarget;
    private int backColorTarget;
    private boolean separatedBackFace;
    private boolean useSeparateDiffuseAlpha;
    private boolean blendDiffuseAlpha;
    private HashMap displayListMap;
    private HashMap deletedDisplayListMap;

    public Material() {
        this(DEFAULT_AMBIENT, DEFAULT_EMISSIVE, DEFAULT_DIFFUSE, DEFAULT_SPECULAR, 0.2f, 1.0f);
    }

    public Material(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float f, float f2) {
        this.diffuseColor[0] = fArray3[0];
        this.diffuseColor[1] = fArray3[1];
        this.diffuseColor[2] = fArray3[2];
        this.diffuseColor[3] = f2;
        this.ambientColor = new float[4];
        this.ambientColor[0] = fArray[0];
        this.ambientColor[1] = fArray[1];
        this.ambientColor[2] = fArray[2];
        this.ambientColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.specularColor = new float[4];
        this.specularColor[0] = fArray4[0];
        this.specularColor[1] = fArray4[1];
        this.specularColor[2] = fArray4[2];
        this.specularColor[3] = fArray4.length > 3 ? fArray4[3] : 1.0f;
        this.emissiveColor = new float[4];
        this.emissiveColor[0] = fArray2[0];
        this.emissiveColor[1] = fArray2[1];
        this.emissiveColor[2] = fArray2[2];
        this.emissiveColor[3] = fArray2.length > 3 ? fArray2[3] : 1.0f;
        this.shininess = 128.0f * f;
        this.useLighting = true;
        this.separatedBackFace = false;
        this.blendDiffuseAlpha = false;
        this.useColorMaterial = false;
        this.colorTarget = 5634;
        this.backColorTarget = 5634;
        this.displayListMap = new HashMap(1);
        this.deletedDisplayListMap = new HashMap(1);
    }

    public void render(GL gL, GLU gLU) {
        Integer n;
        if (this.deletedDisplayListMap.size() != 0 && (n = (Integer)this.deletedDisplayListMap.remove(gL)) != null) {
            gL.glDeleteLists(n.intValue(), 1);
        }
        if ((n = (Integer)this.displayListMap.get(gL)) == null) {
            n = new Integer(gL.glGenLists(1));
            gL.glNewList(n.intValue(), 4865);
            if (this.useLighting) {
                gL.glEnable(2896);
            } else {
                gL.glDisable(2896);
            }
            if (this.useColorMaterial) {
                gL.glEnable(2903);
                if (this.separatedBackFace) {
                    gL.glColorMaterial(1028, this.colorTarget);
                    gL.glColorMaterial(1029, this.backColorTarget);
                } else {
                    gL.glColorMaterial(1032, this.colorTarget);
                }
                if (this.blendDiffuseAlpha) {
                    gL.glBlendColor(0.0f, 0.0f, 0.0f, this.diffuseColor[3]);
                    gL.glBlendFunc(770, 32772);
                }
            } else {
                gL.glDisable(2903);
            }
            if (this.separatedBackFace) {
                gL.glMaterialfv(1028, 4609, this.diffuseColor);
                gL.glMaterialfv(1028, 4608, this.ambientColor);
                gL.glMaterialfv(1028, 4610, this.specularColor);
                gL.glMaterialfv(1028, 5632, this.emissiveColor);
                gL.glMaterialf(1028, 5633, this.shininess);
                gL.glMaterialfv(1029, 4609, this.backDiffuseColor);
                gL.glMaterialfv(1029, 4608, this.backAmbientColor);
                gL.glMaterialfv(1029, 4610, this.backSpecularColor);
                gL.glMaterialfv(1029, 5632, this.backEmissiveColor);
                gL.glMaterialf(1029, 5633, this.backShininess);
            } else {
                gL.glMaterialfv(1032, 4609, this.diffuseColor);
                gL.glMaterialfv(1032, 4608, this.ambientColor);
                gL.glMaterialfv(1032, 4610, this.specularColor);
                gL.glMaterialfv(1032, 5632, this.emissiveColor);
                gL.glMaterialf(1032, 5633, this.shininess);
            }
            gL.glEndList();
            this.displayListMap.put(gL, n);
        } else {
            gL.glCallList(n.intValue());
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (this.useLighting) {
            gL.glDisable(2896);
        }
        if (this.useColorMaterial) {
            gL.glDisable(2903);
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        Material material = (Material)object;
        return this.compareTo(material);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Material)) {
            return false;
        }
        return this.equals((Material)object);
    }

    public void setShininess(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.shininess = 128.0f * f;
        this.clearActiveList();
    }

    public void setBackShininess(float f) throws InvalidWriteTimingException, IllegalStateException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        this.backShininess = 128.0f * f;
        this.clearActiveList();
    }

    public float getShininess() {
        return this.shininess / 128.0f;
    }

    public float getBackShininess() throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        return this.backShininess / 128.0f;
    }

    public void setDiffuseColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.diffuseColor[0] = fArray[0];
        this.diffuseColor[1] = fArray[1];
        this.diffuseColor[2] = fArray[2];
        this.clearActiveList();
    }

    public void setBackDiffuseColor(float[] fArray) throws InvalidWriteTimingException, IllegalStateException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        this.backDiffuseColor[0] = fArray[0];
        this.backDiffuseColor[1] = fArray[1];
        this.backDiffuseColor[2] = fArray[2];
        this.clearActiveList();
    }

    public void getDiffuseColor(float[] fArray) {
        fArray[0] = this.diffuseColor[0];
        fArray[1] = this.diffuseColor[1];
        fArray[2] = this.diffuseColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.diffuseColor[3];
        }
    }

    public void getBackDiffuseColor(float[] fArray) throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        fArray[0] = this.backDiffuseColor[0];
        fArray[1] = this.backDiffuseColor[1];
        fArray[2] = this.backDiffuseColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.backDiffuseColor[3];
        }
    }

    public void setSpecularColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.specularColor[0] = fArray[0];
        this.specularColor[1] = fArray[1];
        this.specularColor[2] = fArray[2];
        this.specularColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.clearActiveList();
    }

    public void setBackSpecularColor(float[] fArray) throws InvalidWriteTimingException, IllegalStateException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        this.backSpecularColor[0] = fArray[0];
        this.backSpecularColor[1] = fArray[1];
        this.backSpecularColor[2] = fArray[2];
        this.backSpecularColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.clearActiveList();
    }

    public void getSpecularColor(float[] fArray) {
        fArray[0] = this.specularColor[0];
        fArray[1] = this.specularColor[1];
        fArray[2] = this.specularColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.specularColor[3];
        }
    }

    public void getBackSpecularColor(float[] fArray) throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        fArray[0] = this.backSpecularColor[0];
        fArray[1] = this.backSpecularColor[1];
        fArray[2] = this.backSpecularColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.backSpecularColor[3];
        }
    }

    public void setEmissiveColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.emissiveColor[0] = fArray[0];
        this.emissiveColor[1] = fArray[1];
        this.emissiveColor[2] = fArray[2];
        this.emissiveColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.clearActiveList();
    }

    public void setBackEmissiveColor(float[] fArray) throws InvalidWriteTimingException, IllegalStateException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        this.backEmissiveColor[0] = fArray[0];
        this.backEmissiveColor[1] = fArray[1];
        this.backEmissiveColor[2] = fArray[2];
        this.backEmissiveColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.clearActiveList();
    }

    public void getEmissiveColor(float[] fArray) {
        fArray[0] = this.emissiveColor[0];
        fArray[1] = this.emissiveColor[1];
        fArray[2] = this.emissiveColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.emissiveColor[3];
        }
    }

    public void getBackEmissiveColor(float[] fArray) throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        fArray[0] = this.backEmissiveColor[0];
        fArray[1] = this.backEmissiveColor[1];
        fArray[2] = this.backEmissiveColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.backEmissiveColor[3];
        }
    }

    public void setAmbientColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.ambientColor[0] = fArray[0];
        this.ambientColor[1] = fArray[1];
        this.ambientColor[2] = fArray[2];
        this.ambientColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.clearActiveList();
    }

    public void setBackAmbientColor(float[] fArray) throws InvalidWriteTimingException, IllegalStateException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        this.backAmbientColor[0] = fArray[0];
        this.backAmbientColor[1] = fArray[1];
        this.backAmbientColor[2] = fArray[2];
        this.backAmbientColor[3] = fArray.length > 3 ? fArray[3] : 1.0f;
        this.clearActiveList();
    }

    public void getAmbientColor(float[] fArray) {
        fArray[0] = this.ambientColor[0];
        fArray[1] = this.ambientColor[1];
        fArray[2] = this.ambientColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.ambientColor[3];
        }
    }

    public void getBackAmbientColor(float[] fArray) throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        fArray[0] = this.backAmbientColor[0];
        fArray[1] = this.backAmbientColor[1];
        fArray[2] = this.backAmbientColor[2];
        if (fArray.length > 3) {
            fArray[3] = this.backAmbientColor[3];
        }
    }

    public void setTransparency(float f) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.diffuseColor[3] = f;
        this.blendDiffuseAlpha = this.useSeparateDiffuseAlpha && f != 0.0f && this.useColorMaterial && (this.colorTarget == 4609 || this.colorTarget == 5634);
        this.clearActiveList();
    }

    public void setBackTransparency(float f) throws InvalidWriteTimingException, IllegalStateException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        this.backDiffuseColor[3] = f;
        this.clearActiveList();
    }

    public float getTransparency() {
        return this.diffuseColor[3];
    }

    public float getBackTransparency() throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        return this.backDiffuseColor[3];
    }

    public void setLightingEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.useLighting != bl) {
            this.useLighting = bl;
            this.clearActiveList();
        }
    }

    public boolean isLightingEnabled() {
        return this.useLighting;
    }

    public void setSeparateTransparencyEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.useSeparateDiffuseAlpha != bl) {
            this.useSeparateDiffuseAlpha = bl;
            this.clearActiveList();
        }
        this.blendDiffuseAlpha = this.useSeparateDiffuseAlpha && this.diffuseColor[3] != 0.0f && this.useColorMaterial && (this.colorTarget == 4609 || this.colorTarget == 5634);
    }

    public boolean isSeparateTransparencyEnabled() {
        return this.useSeparateDiffuseAlpha;
    }

    public void setColorMaterialEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.useColorMaterial != bl) {
            this.useColorMaterial = bl;
            this.clearActiveList();
        }
        this.blendDiffuseAlpha = this.useSeparateDiffuseAlpha && this.diffuseColor[3] != 0.0f && this.useColorMaterial && (this.colorTarget == 4609 || this.colorTarget == 5634);
    }

    public boolean isColorMaterialEnabled() {
        return this.useColorMaterial;
    }

    public void setColorMaterialTarget(int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 4608: 
            case 4609: 
            case 4610: 
            case 5632: 
            case 5634: {
                break;
            }
            default: {
                throw new IllegalArgumentException(COLOR_MATERIAL_TARGET_ERR);
            }
        }
        this.colorTarget = n;
        this.blendDiffuseAlpha = this.useSeparateDiffuseAlpha && this.diffuseColor[3] != 0.0f && this.useColorMaterial && (this.colorTarget == 4609 || this.colorTarget == 5634);
        this.clearActiveList();
    }

    public void setBackColorMaterialTarget(int n) throws InvalidWriteTimingException, IllegalStateException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_WRITE_MSG);
        }
        switch (n) {
            case 4608: 
            case 4609: 
            case 4610: 
            case 5632: 
            case 5634: {
                break;
            }
            default: {
                throw new IllegalArgumentException(COLOR_MATERIAL_TARGET_ERR);
            }
        }
        this.backColorTarget = n;
        this.clearActiveList();
    }

    public int getColorMaterialTarget() {
        return this.colorTarget;
    }

    public int getBackColorMaterialTarget() throws IllegalStateException {
        if (!this.separatedBackFace) {
            throw new IllegalStateException(NO_BACKFACE_READ_MSG);
        }
        return this.backColorTarget;
    }

    public void setSeparateBackfaceEnabled(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.separatedBackFace != bl) {
            this.separatedBackFace = bl;
            this.clearActiveList();
            if (this.separatedBackFace) {
                if (this.backDiffuseColor == null) {
                    this.backDiffuseColor = new float[4];
                }
                this.backDiffuseColor[0] = this.diffuseColor[0];
                this.backDiffuseColor[1] = this.diffuseColor[1];
                this.backDiffuseColor[2] = this.diffuseColor[2];
                this.backDiffuseColor[3] = this.diffuseColor[3];
                if (this.backAmbientColor == null) {
                    this.backAmbientColor = new float[4];
                }
                this.backAmbientColor[0] = this.ambientColor[0];
                this.backAmbientColor[1] = this.ambientColor[1];
                this.backAmbientColor[2] = this.ambientColor[2];
                this.backAmbientColor[3] = this.ambientColor[3];
                if (this.backSpecularColor == null) {
                    this.backSpecularColor = new float[4];
                }
                this.backSpecularColor[0] = this.specularColor[0];
                this.backSpecularColor[1] = this.specularColor[1];
                this.backSpecularColor[2] = this.specularColor[2];
                this.backSpecularColor[3] = this.specularColor[3];
                if (this.backEmissiveColor == null) {
                    this.backEmissiveColor = new float[4];
                }
                this.backEmissiveColor[0] = this.emissiveColor[0];
                this.backEmissiveColor[1] = this.emissiveColor[1];
                this.backEmissiveColor[2] = this.emissiveColor[2];
                this.backEmissiveColor[3] = this.emissiveColor[3];
                this.backShininess = this.shininess;
            }
        }
    }

    public boolean isSeparateBackfaceEnabled() {
        return this.separatedBackFace;
    }

    public int compareTo(Material material) {
        if (material == this) {
            return 0;
        }
        if (material == null) {
            return 1;
        }
        if (this.useLighting != material.useLighting) {
            return !this.useLighting ? -1 : 1;
        }
        if (this.separatedBackFace != material.separatedBackFace) {
            return !this.separatedBackFace ? -1 : 1;
        }
        if (this.shininess != material.shininess) {
            return this.shininess > material.shininess ? 1 : -1;
        }
        int n = this.compareColor4(this.ambientColor, material.ambientColor);
        if (n != 0) {
            return n;
        }
        n = this.compareColor4(this.diffuseColor, material.diffuseColor);
        if (n != 0) {
            return n;
        }
        n = this.compareColor4(this.emissiveColor, material.emissiveColor);
        if (n != 0) {
            return n;
        }
        n = this.compareColor4(this.specularColor, material.specularColor);
        if (n != 0) {
            return n;
        }
        if (this.useColorMaterial != material.useColorMaterial) {
            return !this.useColorMaterial ? -1 : 1;
        }
        if (this.useColorMaterial) {
            if (this.colorTarget != material.colorTarget) {
                return this.colorTarget > material.colorTarget ? 1 : -1;
            }
            if (this.separatedBackFace && this.backColorTarget != material.backColorTarget) {
                return this.backColorTarget > material.backColorTarget ? 1 : -1;
            }
        }
        if (this.separatedBackFace) {
            if (this.backShininess != material.backShininess) {
                return this.backShininess > material.backShininess ? 1 : -1;
            }
            n = this.compareColor4(this.backAmbientColor, material.backAmbientColor);
            if (n != 0) {
                return n;
            }
            n = this.compareColor4(this.backDiffuseColor, material.backDiffuseColor);
            if (n != 0) {
                return n;
            }
            n = this.compareColor4(this.backEmissiveColor, material.backEmissiveColor);
            if (n != 0) {
                return n;
            }
            n = this.compareColor4(this.backSpecularColor, material.backSpecularColor);
            if (n != 0) {
                return n;
            }
        }
        return 0;
    }

    public boolean equals(Material material) {
        if (material == this) {
            return true;
        }
        if (!(material != null && this.useLighting == material.useLighting && this.shininess == material.shininess && this.separatedBackFace == material.separatedBackFace && this.useColorMaterial == material.useColorMaterial && this.equalsColor4(this.ambientColor, material.ambientColor) && this.equalsColor4(this.diffuseColor, material.diffuseColor) && this.equalsColor4(this.emissiveColor, material.emissiveColor) && this.equalsColor4(this.specularColor, material.specularColor))) {
            return false;
        }
        if (this.useColorMaterial && this.colorTarget != material.colorTarget || this.separatedBackFace && this.backColorTarget != material.backColorTarget) {
            return false;
        }
        return !this.separatedBackFace || this.backShininess == material.backShininess && this.equalsColor4(this.backAmbientColor, material.backAmbientColor) && this.equalsColor4(this.backDiffuseColor, material.backDiffuseColor) && this.equalsColor4(this.backEmissiveColor, material.backEmissiveColor) && this.equalsColor4(this.backSpecularColor, material.backSpecularColor);
    }

    private void clearActiveList() {
        if (this.displayListMap.size() == 0) {
            return;
        }
        this.deletedDisplayListMap.putAll(this.displayListMap);
        this.displayListMap.clear();
    }

    private int compareColor4(float[] fArray, float[] fArray2) {
        if (fArray[0] < fArray2[0]) {
            return -1;
        }
        if (fArray[0] > fArray2[0]) {
            return 1;
        }
        if (fArray[1] < fArray2[1]) {
            return -1;
        }
        if (fArray[1] > fArray2[1]) {
            return 1;
        }
        if (fArray[2] < fArray2[2]) {
            return -1;
        }
        if (fArray[2] > fArray2[2]) {
            return 1;
        }
        if (fArray[3] < fArray2[3]) {
            return -1;
        }
        if (fArray[3] > fArray2[3]) {
            return 1;
        }
        return 0;
    }

    private boolean equalsColor4(float[] fArray, float[] fArray2) {
        return fArray[0] == fArray2[0] && fArray[1] == fArray2[1] && fArray[2] == fArray2[2] && fArray[3] == fArray2[3];
    }
}

