/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.awt.Rectangle;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.MultipassRenderObserver;
import org.j3d.aviatrix3d.MultipassTextureSource;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.ViewEnvironment;

public class MultipassTextureComponent
extends NodeComponent
implements MultipassTextureSource {
    protected int format;
    protected Scene renderableObjects;
    protected float[] clearColor = new float[4];
    protected int numLevels;
    private boolean repaintNeeded;
    protected int[] formats;
    protected MultipassRenderObserver observer;
    protected int glBuffers = 16384;

    public MultipassRenderObserver getRenderObserver() {
        return this.observer;
    }

    public int getUsedBuffers() {
        return this.glBuffers;
    }

    public void setNumLevels(int n) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.numLevels = n;
    }

    public void setRenderedScene(Scene scene) throws CyclicSceneGraphStructureException {
        Group group;
        if (this.renderableObjects != null) {
            this.renderableObjects.setLive(false);
        }
        if (scene != null) {
            group = scene.getRenderedGeometry();
            group.checkForCyclicChild(this);
        }
        this.renderableObjects = scene;
        if (this.renderableObjects != null) {
            this.renderableObjects.setLive(this.alive);
            group = this.renderableObjects.getRenderedGeometry();
            if (group != null) {
                group.setUpdateHandler(this.updateHandler);
            }
        }
    }

    public Scene getRenderedScene() {
        return this.renderableObjects;
    }

    public int getHeight() {
        Rectangle rectangle;
        ViewEnvironment viewEnvironment;
        int n = 0;
        if (this.renderableObjects != null && (viewEnvironment = this.renderableObjects.getViewEnvironment()) != null && (rectangle = viewEnvironment.getViewport()) != null) {
            n = rectangle.height;
        }
        return n;
    }

    public boolean isRepaintRequired() {
        return this.repaintNeeded;
    }

    public void getClearColor(float[] fArray) {
        fArray[0] = this.clearColor[0];
        fArray[1] = this.clearColor[1];
        fArray[2] = this.clearColor[2];
        fArray[3] = this.clearColor[3];
    }

    public int getWidth() {
        Rectangle rectangle;
        ViewEnvironment viewEnvironment;
        int n = 0;
        if (this.renderableObjects != null && (viewEnvironment = this.renderableObjects.getViewEnvironment()) != null && (rectangle = viewEnvironment.getViewport()) != null) {
            n = rectangle.width;
        }
        return n;
    }

    public int getNumLevels() {
        return this.numLevels;
    }

    public int getFormat(int n) {
        return this.formats[n];
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws InvalidWriteTimingException, CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.renderableObjects != null) {
            Group group = this.renderableObjects.getRenderedGeometry();
            group.checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.renderableObjects != null) {
                this.renderableObjects.setLive(bl);
            }
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        Group group;
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.renderableObjects != null && (group = this.renderableObjects.getRenderedGeometry()) != null) {
            group.setUpdateHandler(this.updateHandler);
        }
    }

    public void setRenderObserver(MultipassRenderObserver multipassRenderObserver) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.observer = multipassRenderObserver;
    }

    public void setRepaintRequired(boolean bl) {
        this.repaintNeeded = bl;
    }

    public void setClearColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearColor[0] = f;
        this.clearColor[1] = f2;
        this.clearColor[2] = f3;
        this.clearColor[3] = f4;
    }

    public void setUsedBuffers(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.glBuffers = n;
    }
}

