/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InternalNodeUpdateListener;
import org.j3d.aviatrix3d.InvalidListenerSetTimingException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateListener;
import org.j3d.aviatrix3d.SceneGraphObject;

public abstract class Node
extends SceneGraphObject {
    private static final String CURRENT_PARENT_MSG = "Parent node currently set, and this node cannot have more than one at a time. Please remove this node from it's current parent first before adding it to another";
    protected static final BoundingVoid INVALID_BOUNDS = new BoundingVoid();
    protected Node parent;
    protected BoundingVolume bounds;
    protected boolean implicitBounds = true;
    private InternalUpdater internalUpdater = new InternalUpdater();

    protected Node() {
    }

    protected void checkForCyclicParent(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        super.checkForCyclicParent(sceneGraphObject);
        if (this.parent != null) {
            this.parent.checkForCyclicParent(sceneGraphObject);
        }
    }

    protected void setLive(boolean bl) {
        boolean bl2 = this.alive;
        super.setLive(bl);
        if (!bl2 && bl) {
            this.recomputeBounds();
        }
    }

    protected void setParent(Node node) throws AlreadyParentedException {
        if (node != null && this.parent != null) {
            throw new AlreadyParentedException(CURRENT_PARENT_MSG);
        }
        this.parent = node;
    }

    protected void removeParent(Node node) {
        this.parent = null;
    }

    public Node getParent() {
        return this.parent;
    }

    public void boundsChanged(NodeUpdateListener nodeUpdateListener) throws InvalidListenerSetTimingException {
        if (!this.isLive()) {
            throw new InvalidListenerSetTimingException("Attempting to set a listener to this node when it is not live. Listeners can only be set once the node is live. When it is not live just directly set the values.");
        }
        if (this.updateHandler == null) {
            return;
        }
        if (this.updateHandler.boundsChanged(nodeUpdateListener, this, this.internalUpdater)) {
            this.markBoundsDirty();
        }
    }

    public void setBounds(BoundingVolume boundingVolume) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.bounds = boundingVolume;
        this.implicitBounds = this.bounds == null;
    }

    public BoundingVolume getBounds() {
        if (this.implicitBounds && this.bounds == null) {
            this.recomputeBounds();
        }
        return this.bounds;
    }

    protected void updateBounds() {
    }

    protected void updateParentBounds() {
        if (this.parent != null) {
            this.parent.updateBounds();
        }
    }

    protected void recomputeBounds() {
        if (this.bounds == null) {
            this.bounds = INVALID_BOUNDS;
        }
    }

    protected void markBoundsDirty() {
        if (this.implicitBounds && this.parent != null) {
            this.parent.markBoundsDirty();
        }
    }

    private class InternalUpdater
    implements InternalNodeUpdateListener {
        private InternalUpdater() {
        }

        public void updateBoundsAndNotify() {
            Node.this.updateBounds();
        }
    }
}

