/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLPbuffer;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.PBufferTextureSource;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.Scene;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Texture;
import org.j3d.aviatrix3d.Texture2D;
import org.j3d.aviatrix3d.TextureSource;

public class OffscreenTexture2D
extends Texture
implements PBufferTextureSource,
RenderableObject {
    private int height;
    private int boundaryModeT;
    private Scene renderableObjects;
    private float[] clearColor;
    private boolean repaintNeeded;
    private final GLCapabilities capabilities;
    private HashMap displayListMap;

    public OffscreenTexture2D(GLCapabilities gLCapabilities, int n, int n2) {
        super(3553);
        if (gLCapabilities == null) {
            throw new IllegalArgumentException("Capabilities must be provided");
        }
        this.capabilities = gLCapabilities;
        this.numSources = 0;
        this.height = n2;
        this.width = n;
        this.clearColor = new float[4];
        this.boundaryModeT = 10496;
        this.displayListMap = new HashMap();
    }

    public void setSources(int n, int n2, TextureSource[] textureSourceArray, int n3) throws InvalidWriteTimingException {
    }

    public int getFormat(int n) {
        return this.format;
    }

    public int getNumLevels() {
        return 1;
    }

    public void render(GL gL, GLU gLU) {
        GLPbuffer gLPbuffer = (GLPbuffer)this.displayListMap.get(gL);
        if (gLPbuffer == null) {
            return;
        }
        if (!this.stateChanged.getState(gL)) {
            if (gLPbuffer.isInitialized()) {
                gLPbuffer.bindTexture();
            }
            return;
        }
        this.stateChanged.put(gL, false);
        gLPbuffer.bindTexture();
        gL.glTexParameteri(3553, 10242, this.boundaryModeS);
        gL.glTexParameteri(3553, 10243, this.boundaryModeT);
        int n = 0;
        switch (this.magFilter) {
            case 0: 
            case 2: {
                n = 9728;
                break;
            }
            case 1: 
            case 3: {
                n = 9729;
                break;
            }
            default: {
                System.out.println("Unknown mode in MagFilter: " + this.magFilter);
            }
        }
        gL.glTexParameteri(3553, 10240, n);
        switch (this.minFilter) {
            case 0: 
            case 2: {
                n = 9728;
                break;
            }
            case 3: {
                n = 9729;
                break;
            }
            case 5: {
                n = 9987;
                break;
            }
            case 4: {
                n = 9984;
                break;
            }
            case 1: {
                n = this.numSources > 1 ? 9987 : 9729;
                break;
            }
            default: {
                System.out.println("Unknown mode in MinFilter: " + this.minFilter);
            }
        }
        gL.glTexParameteri(3553, 10241, n);
        if (this.anisotropicMode != 0) {
            gL.glTexParameterf(3553, 34046, this.anisotropicDegree);
        }
        if (this.priority >= 0.0f) {
            gL.glTexParameterf(3553, 32870, this.priority);
        }
        if (this.borderColor != null) {
            gL.glTexParameterfv(3553, 4100, this.borderColor);
        }
        if (this.format == 6402) {
            gL.glTexParameterf(3553, 34891, (float)this.depthComponentMode);
            gL.glTexParameterf(3553, 34892, (float)this.compareMode);
            gL.glTexParameterf(3553, 34893, (float)this.compareFunction);
        }
    }

    public void postRender(GL gL, GLU gLU) {
        GLPbuffer gLPbuffer = (GLPbuffer)this.displayListMap.get(gL);
        if (gLPbuffer != null) {
            gLPbuffer.releaseTexture();
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws InvalidWriteTimingException, CyclicSceneGraphStructureException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.renderableObjects != null) {
            Group group = this.renderableObjects.getRenderedGeometry();
            group.checkForCyclicChild(sceneGraphObject);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.renderableObjects != null) {
                this.renderableObjects.setLive(bl);
            }
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        Group group;
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.renderableObjects != null && (group = this.renderableObjects.getRenderedGeometry()) != null) {
            group.setUpdateHandler(this.updateHandler);
        }
    }

    public GLCapabilities getGLSetup() {
        return this.capabilities;
    }

    public GLPbuffer getBuffer(Object object) {
        return (GLPbuffer)this.displayListMap.get(object);
    }

    public void registerBuffer(Object object, GLPbuffer gLPbuffer) {
        this.displayListMap.put(object, gLPbuffer);
    }

    public void unregisterBuffer(Object object) {
        this.displayListMap.remove(object);
    }

    public Scene getRenderedScene() {
        return this.renderableObjects;
    }

    public boolean isRepaintRequired() {
        return this.repaintNeeded;
    }

    public int getHeight() {
        return this.height;
    }

    public void setRenderedScene(Scene scene) throws CyclicSceneGraphStructureException {
        Group group;
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.renderableObjects != null) {
            this.renderableObjects.setLive(false);
        }
        if (scene != null) {
            group = scene.getRenderedGeometry();
            group.checkForCyclicChild(this);
        }
        this.renderableObjects = scene;
        if (this.renderableObjects != null) {
            this.renderableObjects.setLive(this.alive);
            group = this.renderableObjects.getRenderedGeometry();
            if (group != null) {
                group.setUpdateHandler(this.updateHandler);
            }
        }
    }

    public void getClearColor(float[] fArray) {
        fArray[0] = this.clearColor[0];
        fArray[1] = this.clearColor[1];
        fArray[2] = this.clearColor[2];
        fArray[3] = this.clearColor[3];
    }

    public void setRepaintRequired(boolean bl) {
        this.repaintNeeded = bl;
    }

    public void setBoundaryModeT(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.boundaryModeT = n;
        this.stateChanged.setAll(true);
    }

    public int getBoundaryModeT() {
        return this.boundaryModeT;
    }

    public void setClearColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.clearColor[0] = f;
        this.clearColor[1] = f2;
        this.clearColor[2] = f3;
        this.clearColor[3] = f4;
    }

    public int compareTo(Texture texture) {
        int n = super.compareTo(texture);
        if (n != 0) {
            return n;
        }
        OffscreenTexture2D offscreenTexture2D = (OffscreenTexture2D)texture;
        if (this.renderableObjects != offscreenTexture2D.renderableObjects) {
            int n2;
            if (this.renderableObjects == null) {
                return -1;
            }
            if (offscreenTexture2D.renderableObjects == null) {
                return 1;
            }
            int n3 = this.renderableObjects.hashCode();
            return n3 < (n2 = offscreenTexture2D.renderableObjects.hashCode()) ? -1 : 1;
        }
        if (this.repaintNeeded != offscreenTexture2D.repaintNeeded) {
            return this.repaintNeeded ? 1 : -1;
        }
        if (this.height != offscreenTexture2D.height) {
            return this.height < offscreenTexture2D.height ? -1 : 1;
        }
        if (this.boundaryModeS != offscreenTexture2D.boundaryModeS) {
            return this.boundaryModeS < offscreenTexture2D.boundaryModeS ? -1 : 1;
        }
        if (this.boundaryModeT != offscreenTexture2D.boundaryModeT) {
            return this.boundaryModeT < offscreenTexture2D.boundaryModeT ? -1 : 1;
        }
        if (this.clearColor[0] != offscreenTexture2D.clearColor[0]) {
            return this.clearColor[0] < offscreenTexture2D.clearColor[0] ? -1 : 1;
        }
        if (this.clearColor[1] != offscreenTexture2D.clearColor[1]) {
            return this.clearColor[1] < offscreenTexture2D.clearColor[1] ? -1 : 1;
        }
        if (this.clearColor[2] != offscreenTexture2D.clearColor[2]) {
            return this.clearColor[2] < offscreenTexture2D.clearColor[2] ? -1 : 1;
        }
        if (this.clearColor[3] != offscreenTexture2D.clearColor[3]) {
            return this.clearColor[3] < offscreenTexture2D.clearColor[3] ? -1 : 1;
        }
        return 0;
    }

    public boolean equals(Texture texture) {
        if (!super.equals(texture)) {
            return false;
        }
        if (!(texture instanceof Texture2D)) {
            return false;
        }
        OffscreenTexture2D offscreenTexture2D = (OffscreenTexture2D)texture;
        return this.height == offscreenTexture2D.height && this.boundaryModeS == offscreenTexture2D.boundaryModeS && this.boundaryModeT == offscreenTexture2D.boundaryModeT && this.renderableObjects == offscreenTexture2D.renderableObjects && this.repaintNeeded == offscreenTexture2D.repaintNeeded && this.clearColor[0] == offscreenTexture2D.clearColor[0] && this.clearColor[1] == offscreenTexture2D.clearColor[1] && this.clearColor[2] == offscreenTexture2D.clearColor[2] && this.clearColor[3] == offscreenTexture2D.clearColor[3];
    }
}

