/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.io.Serializable;
import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.RenderableObject;

public class PolygonAttributes
extends NodeComponent
implements RenderableObject,
Comparable {
    private static final String INVALID_DRAW_MSG = "An invalid draw mode was provided. It must be one of DRAW_POINT, DRAW_LINE or DRAW_FILLED";
    private static final String INVALID_CULL_MSG = "An invalid face cull mode was provided. It must be one of CULL_NONE, CULL_FRONT, CULL_BACK or CULL_BOTH";
    private static final String STIPPLE_SIZE_MSG = "The stipple pattern array must be at least 1024 items in size";
    public static final int CULL_NONE = 0;
    public static final int CULL_FRONT = 1028;
    public static final int CULL_BACK = 1029;
    public static final int CULL_BOTH = 1032;
    public static final int DRAW_POINT = 6912;
    public static final int DRAW_LINE = 6913;
    public static final int DRAW_FILLED = 6914;
    private int frontDrawMode = 6914;
    private int backDrawMode = 6914;
    private boolean isCCW = true;
    private int cullFace = 0;
    private float polyOffsetFactor = 0.0f;
    private float polyOffsetUnit = 1.0f;
    private boolean stateChanged = true;
    private boolean antialias = false;
    private boolean useTwoSidedLighting = false;
    private boolean useSeparateSpecular = false;
    private HashMap setDisplayListMap = new HashMap(1);
    private HashMap clearDisplayListMap = new HashMap(1);
    private byte[] stipple;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL, GLU gLU) {
        Serializable serializable;
        if (this.stateChanged) {
            serializable = this.setDisplayListMap;
            synchronized (serializable) {
                this.setDisplayListMap.clear();
                this.clearDisplayListMap.clear();
                this.stateChanged = false;
            }
        }
        if ((serializable = (Integer)this.setDisplayListMap.get(gL)) == null) {
            serializable = new Integer(gL.glGenLists(1));
            gL.glNewList(((Integer)serializable).intValue(), 4865);
            if (this.antialias) {
                gL.glEnable(2881);
            }
            if (!this.isCCW) {
                gL.glFrontFace(2304);
            }
            if (this.cullFace == 0) {
                gL.glDisable(2884);
            } else if (this.cullFace != 1029) {
                gL.glCullFace(this.cullFace);
            }
            if (this.useTwoSidedLighting) {
                gL.glLightModeli(2898, 1);
            }
            if (this.useSeparateSpecular) {
                gL.glLightModeli(33272, 33274);
            }
            if (this.polyOffsetFactor != 0.0f) {
                gL.glEnable(32823);
                gL.glPolygonOffset(this.polyOffsetFactor, this.polyOffsetUnit);
                gL.glPolygonMode(1028, this.frontDrawMode);
                gL.glPolygonMode(1029, this.backDrawMode);
            } else {
                if (this.frontDrawMode != 6914) {
                    gL.glPolygonMode(1028, this.frontDrawMode);
                }
                if (this.backDrawMode != 6914) {
                    gL.glPolygonMode(1029, this.backDrawMode);
                }
            }
            if (this.stipple != null) {
                gL.glEnable(2882);
                gL.glPixelStorei(5121, 1);
                gL.glPolygonStipple(this.stipple);
            }
            gL.glEndList();
            this.setDisplayListMap.put(gL, serializable);
        } else {
            gL.glCallList(((Integer)serializable).intValue());
        }
    }

    public void postRender(GL gL, GLU gLU) {
        Integer n = (Integer)this.clearDisplayListMap.get(gL);
        if (n == null) {
            n = new Integer(gL.glGenLists(1));
            gL.glNewList(n.intValue(), 4865);
            if (this.antialias) {
                gL.glDisable(2881);
            }
            if (this.polyOffsetFactor != 0.0f) {
                gL.glDisable(32823);
            } else {
                if (this.frontDrawMode != 6914) {
                    gL.glPolygonMode(1028, 6914);
                }
                if (this.backDrawMode != 6914) {
                    gL.glPolygonMode(1029, 6914);
                }
            }
            if (this.stipple != null) {
                gL.glDisable(2882);
            }
            if (this.useTwoSidedLighting) {
                gL.glLightModeli(2898, 0);
            }
            if (this.useSeparateSpecular) {
                gL.glLightModeli(33272, 33273);
            }
            if (!this.isCCW) {
                gL.glFrontFace(2305);
            }
            if (this.cullFace == 0) {
                gL.glEnable(2884);
            } else if (this.cullFace != 1029) {
                gL.glCullFace(1029);
            }
            gL.glEndList();
            this.clearDisplayListMap.put(gL, n);
        } else {
            gL.glCallList(n.intValue());
        }
    }

    public int compareTo(Object object) throws ClassCastException {
        PolygonAttributes polygonAttributes = (PolygonAttributes)object;
        return this.compareTo(polygonAttributes);
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolygonAttributes)) {
            return false;
        }
        return this.equals((PolygonAttributes)object);
    }

    public void setAntiAliased(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.antialias != bl) {
            this.antialias = bl;
            this.stateChanged = true;
        }
    }

    public boolean isAntiAliased() {
        return this.antialias;
    }

    public void setCCW(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.isCCW != bl) {
            this.isCCW = bl;
            this.stateChanged = true;
        }
    }

    public boolean isCCW() {
        return this.isCCW;
    }

    public void setTwoSidedLighting(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.useTwoSidedLighting != bl) {
            this.useTwoSidedLighting = bl;
            this.stateChanged = true;
        }
    }

    public boolean isTwoSidedLighting() {
        return this.useTwoSidedLighting;
    }

    public void setSeparateSpecular(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.useSeparateSpecular != bl) {
            this.useSeparateSpecular = bl;
            this.stateChanged = true;
        }
    }

    public boolean isSeparateSpecular() {
        return this.useSeparateSpecular;
    }

    public void setCulledFace(int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 0: 
            case 1028: 
            case 1029: 
            case 1032: {
                if (n == this.cullFace) break;
                this.cullFace = n;
                this.stateChanged = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_CULL_MSG);
            }
        }
    }

    public int getCulledFace() {
        return this.cullFace;
    }

    public void setDrawMode(boolean bl, int n) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        switch (n) {
            case 6912: 
            case 6913: 
            case 6914: {
                if (bl) {
                    if (n == this.frontDrawMode) break;
                    this.frontDrawMode = n;
                    this.stateChanged = true;
                    break;
                }
                if (n == this.backDrawMode) break;
                this.backDrawMode = n;
                this.stateChanged = true;
                break;
            }
            default: {
                throw new IllegalArgumentException(INVALID_DRAW_MSG);
            }
        }
    }

    public int getDrawMode(boolean bl) {
        return bl ? this.frontDrawMode : this.backDrawMode;
    }

    public void setPolygonOffset(float f, float f2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.polyOffsetFactor != f) {
            this.polyOffsetFactor = f;
            this.stateChanged = true;
        }
        if (this.polyOffsetUnit != f2) {
            this.polyOffsetUnit = f2;
            this.stateChanged = true;
        }
    }

    public void getPolygonOffset(float[] fArray) {
        fArray[0] = this.polyOffsetFactor;
        fArray[1] = this.polyOffsetUnit;
    }

    public void setStipplePattern(byte[] byArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (byArray != null) {
            if (byArray.length < 1024) {
                throw new IllegalArgumentException(STIPPLE_SIZE_MSG);
            }
            this.stipple = byArray;
        } else {
            this.stipple = null;
        }
    }

    public int compareTo(PolygonAttributes polygonAttributes) {
        if (polygonAttributes == null) {
            return 1;
        }
        if (polygonAttributes == this) {
            return 0;
        }
        if (this.antialias != polygonAttributes.antialias) {
            return this.antialias ? 1 : -1;
        }
        if (this.cullFace != polygonAttributes.cullFace) {
            return this.cullFace < polygonAttributes.cullFace ? -1 : 1;
        }
        if (this.isCCW != polygonAttributes.isCCW) {
            return this.isCCW ? 1 : -1;
        }
        if (this.useTwoSidedLighting != polygonAttributes.useTwoSidedLighting) {
            return this.useTwoSidedLighting ? 1 : -1;
        }
        if (this.useSeparateSpecular != polygonAttributes.useSeparateSpecular) {
            return this.useSeparateSpecular ? 1 : -1;
        }
        if (this.frontDrawMode != polygonAttributes.frontDrawMode) {
            return this.frontDrawMode < polygonAttributes.frontDrawMode ? -1 : 1;
        }
        if (this.backDrawMode != polygonAttributes.backDrawMode) {
            return this.backDrawMode < polygonAttributes.backDrawMode ? -1 : 1;
        }
        if (this.polyOffsetFactor != polygonAttributes.polyOffsetFactor) {
            return this.polyOffsetFactor < polygonAttributes.polyOffsetFactor ? -1 : 1;
        }
        if (this.polyOffsetUnit != polygonAttributes.polyOffsetUnit) {
            return this.polyOffsetUnit < polygonAttributes.polyOffsetUnit ? -1 : 1;
        }
        if (this.stipple != polygonAttributes.stipple) {
            if (this.stipple == null) {
                return -1;
            }
            if (polygonAttributes.stipple == null) {
                return 1;
            }
            for (int i = 0; i < 1024; ++i) {
                if (this.stipple[i] == polygonAttributes.stipple[i]) continue;
                return this.stipple[i] < polygonAttributes.stipple[i] ? -1 : 1;
            }
        }
        return 0;
    }

    public boolean equals(PolygonAttributes polygonAttributes) {
        if (polygonAttributes == this) {
            return true;
        }
        if (polygonAttributes == null || this.antialias != polygonAttributes.antialias || this.cullFace != polygonAttributes.cullFace || this.isCCW != polygonAttributes.isCCW || this.useTwoSidedLighting != polygonAttributes.useTwoSidedLighting || this.useSeparateSpecular != polygonAttributes.useSeparateSpecular || this.frontDrawMode != polygonAttributes.frontDrawMode || this.backDrawMode != polygonAttributes.backDrawMode || this.polyOffsetFactor != polygonAttributes.polyOffsetFactor || this.polyOffsetUnit != polygonAttributes.polyOffsetUnit) {
            return false;
        }
        if (this.stipple != polygonAttributes.stipple) {
            if (this.stipple == null || polygonAttributes.stipple == null) {
                return false;
            }
            for (int i = 0; i < 1024; ++i) {
                if (this.stipple[i] == polygonAttributes.stipple[i]) continue;
                return false;
            }
        }
        return true;
    }
}

