/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.Fog;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.RenderEffectsProcessor;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.ViewEnvironment;
import org.j3d.aviatrix3d.Viewpoint;

public class Scene
extends SceneGraphObject {
    private Object userData;
    private int liveCount = 0;
    private Group renderableObjects;
    private Viewpoint currentViewpoint;
    private Fog currentFog;
    private Background currentBackground;
    private ViewEnvironment viewEnvironment;
    private RenderEffectsProcessor processor;

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            super.setLive(bl);
            if (this.renderableObjects != null) {
                this.renderableObjects.setLive(bl);
            }
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(nodeUpdateHandler);
        }
    }

    public void setRenderEffectsProcessor(RenderEffectsProcessor renderEffectsProcessor) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.processor = renderEffectsProcessor;
    }

    public RenderEffectsProcessor getRenderEffectsProcessor() {
        return this.processor;
    }

    public void setUserData(Object object) {
        this.userData = object;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void setRenderedGeometry(Group group) throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(null);
            this.renderableObjects.setLive(false);
        }
        this.renderableObjects = group;
        if (this.renderableObjects != null) {
            this.renderableObjects.setUpdateHandler(this.updateHandler);
            this.renderableObjects.setLive(this.alive);
        }
    }

    public Group getRenderedGeometry() {
        return this.renderableObjects;
    }

    public void setActiveView(Viewpoint viewpoint) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.currentViewpoint = viewpoint;
    }

    public Viewpoint getActiveView() {
        return this.currentViewpoint;
    }

    public void setActiveFog(Fog fog) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.currentFog = fog;
    }

    public Fog getActiveFog() {
        return this.currentFog;
    }

    public void setActiveBackground(Background background) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.currentBackground = background;
    }

    public Background getActiveBackground() {
        return this.currentBackground;
    }

    public void setViewEnvironment(ViewEnvironment viewEnvironment) throws InvalidWriteTimingException, IllegalArgumentException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.viewEnvironment = viewEnvironment;
    }

    public ViewEnvironment getViewEnvironment() {
        return this.viewEnvironment;
    }
}

