/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import org.j3d.aviatrix3d.Node;

public class SceneGraphPath {
    private static final String TOO_SMALL_MSG = "The initial size is < 1";
    private static final String NON_LEAF_MSG = "The terminating node is not an instance of Leaf";
    private static final int DEFAULT_DEPTH = 32;
    private int numItems;
    private Node[] items;
    private float[] txMatrix;
    private float[] invTxMatrix;

    public SceneGraphPath() {
        this(32);
    }

    public SceneGraphPath(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(TOO_SMALL_MSG);
        }
        this.numItems = 0;
        this.items = new Node[n];
        this.txMatrix = new float[16];
        this.invTxMatrix = new float[16];
    }

    public SceneGraphPath(Node[] nodeArray, int n, Matrix4f matrix4f, Matrix4f matrix4f2) throws IllegalArgumentException {
        this(n);
        this.updatePath(nodeArray, n, matrix4f, matrix4f2);
    }

    public void updatePath(Node[] nodeArray, int n, Matrix4f matrix4f, Matrix4f matrix4f2) {
        if (this.items.length < n) {
            this.items = new Node[n];
        } else {
            for (int i = this.numItems; i < this.items.length; ++i) {
                this.items[i] = null;
            }
        }
        System.arraycopy(nodeArray, 0, this.items, 0, n);
        this.numItems = n;
        this.txMatrix[0] = matrix4f.m00;
        this.txMatrix[1] = matrix4f.m01;
        this.txMatrix[2] = matrix4f.m02;
        this.txMatrix[3] = matrix4f.m03;
        this.txMatrix[4] = matrix4f.m10;
        this.txMatrix[5] = matrix4f.m11;
        this.txMatrix[6] = matrix4f.m12;
        this.txMatrix[7] = matrix4f.m13;
        this.txMatrix[8] = matrix4f.m20;
        this.txMatrix[9] = matrix4f.m21;
        this.txMatrix[10] = matrix4f.m22;
        this.txMatrix[11] = matrix4f.m23;
        this.txMatrix[12] = matrix4f.m30;
        this.txMatrix[13] = matrix4f.m31;
        this.txMatrix[14] = matrix4f.m32;
        this.txMatrix[15] = matrix4f.m33;
        this.invTxMatrix[0] = matrix4f2.m00;
        this.invTxMatrix[1] = matrix4f2.m01;
        this.invTxMatrix[2] = matrix4f2.m02;
        this.invTxMatrix[3] = matrix4f2.m03;
        this.invTxMatrix[4] = matrix4f2.m10;
        this.invTxMatrix[5] = matrix4f2.m11;
        this.invTxMatrix[6] = matrix4f2.m12;
        this.invTxMatrix[7] = matrix4f2.m13;
        this.invTxMatrix[8] = matrix4f2.m20;
        this.invTxMatrix[9] = matrix4f2.m21;
        this.invTxMatrix[10] = matrix4f2.m22;
        this.invTxMatrix[11] = matrix4f2.m23;
        this.invTxMatrix[12] = matrix4f2.m30;
        this.invTxMatrix[13] = matrix4f2.m31;
        this.invTxMatrix[14] = matrix4f2.m32;
        this.invTxMatrix[15] = matrix4f2.m33;
    }

    public Node getTerminalNode() {
        return this.items[this.numItems - 1];
    }

    public Node getNode(int n) throws ArrayIndexOutOfBoundsException {
        if (n < 0) {
            throw new ArrayIndexOutOfBoundsException("Negative index not valid");
        }
        if (n >= this.numItems) {
            throw new ArrayIndexOutOfBoundsException("Index greater than valid count");
        }
        return this.items[n];
    }

    public Node[] getNodes() {
        return this.items;
    }

    public int getNodeCount() {
        return this.numItems;
    }

    public void getTransform(Matrix4f matrix4f) {
        matrix4f.m00 = this.txMatrix[0];
        matrix4f.m01 = this.txMatrix[1];
        matrix4f.m02 = this.txMatrix[2];
        matrix4f.m03 = this.txMatrix[3];
        matrix4f.m10 = this.txMatrix[4];
        matrix4f.m11 = this.txMatrix[5];
        matrix4f.m12 = this.txMatrix[6];
        matrix4f.m13 = this.txMatrix[7];
        matrix4f.m20 = this.txMatrix[8];
        matrix4f.m21 = this.txMatrix[9];
        matrix4f.m22 = this.txMatrix[10];
        matrix4f.m23 = this.txMatrix[11];
        matrix4f.m30 = this.txMatrix[12];
        matrix4f.m31 = this.txMatrix[13];
        matrix4f.m32 = this.txMatrix[14];
        matrix4f.m33 = this.txMatrix[15];
    }

    public void getInverseTransform(Matrix4f matrix4f) {
        matrix4f.m00 = this.invTxMatrix[0];
        matrix4f.m01 = this.invTxMatrix[1];
        matrix4f.m02 = this.invTxMatrix[2];
        matrix4f.m03 = this.invTxMatrix[3];
        matrix4f.m10 = this.invTxMatrix[4];
        matrix4f.m11 = this.invTxMatrix[5];
        matrix4f.m12 = this.invTxMatrix[6];
        matrix4f.m13 = this.invTxMatrix[7];
        matrix4f.m20 = this.invTxMatrix[8];
        matrix4f.m21 = this.invTxMatrix[9];
        matrix4f.m22 = this.invTxMatrix[10];
        matrix4f.m23 = this.invTxMatrix[11];
        matrix4f.m30 = this.invTxMatrix[12];
        matrix4f.m31 = this.invTxMatrix[13];
        matrix4f.m32 = this.invTxMatrix[14];
        matrix4f.m33 = this.invTxMatrix[15];
    }
}

