/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidDataTypeException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.RenderableComponent;
import org.j3d.aviatrix3d.ShaderArgumentValue;
import org.j3d.util.HashSet;

public class ShaderArguments
extends NodeComponent
implements Comparable,
RenderableComponent {
    private static final String INVALID_DATA_SIZE_MSG = "Data for uniform variables is required to have between 1 and 4 components. The value you provided is: ";
    private static final String INVALID_MATRIX_SIZE_MSG = "Data for uniform variables that represent matrix data types is required to have between 2 and 4 components. The value you provided is: ";
    private static final String INVALID_COUNT_MSG = "The number of items in the for the array is less than or equal to 0";
    private static final String NOT_INT_TYPE_MSG = "A float-based data type is defined for this uniform name, and you have called the int[] version of getUniform()";
    private static final String NOT_FLOAT_TYPE_MSG = "An int-based data type is defined for this uniform name, and you have called the float[] version of getUniform()";
    public static final int INT_UNIFORM_TYPE = 1;
    public static final int FLOAT_UNIFORM_TYPE = 2;
    public static final int MATRIX_UNIFORM_TYPE = 3;
    public static final int SAMPLER_UNIFORM_TYPE = 4;
    private HashMap values = new HashMap();
    private HashSet ignoredNames = new HashSet();
    private String[] varNames = new String[32];
    private int numVarNames = 0;

    public void render(GL gL, GLU gLU, Object object) {
        block23: for (int i = 0; i < this.numVarNames; ++i) {
            if (this.ignoredNames.contains((Object)this.varNames[i])) continue;
            ShaderArgumentValue shaderArgumentValue = (ShaderArgumentValue)this.values.get(this.varNames[i]);
            if (shaderArgumentValue.uniformLocation == -1 && !this.ignoredNames.contains((Object)this.varNames[i])) {
                shaderArgumentValue.uniformLocation = gL.glGetUniformLocationARB(((Integer)object).intValue(), this.varNames[i]);
                if (shaderArgumentValue.uniformLocation == -1) {
                    System.out.println("Can't find uniform \"" + this.varNames[i] + "\"");
                    this.ignoredNames.add((Object)this.varNames[i]);
                    continue;
                }
            }
            switch (shaderArgumentValue.dataType) {
                case 1: {
                    switch (shaderArgumentValue.size) {
                        case 1: {
                            gL.glUniform1ivARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.intData);
                            break;
                        }
                        case 2: {
                            gL.glUniform2ivARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.intData);
                            break;
                        }
                        case 3: {
                            gL.glUniform3ivARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.intData);
                            break;
                        }
                        case 4: {
                            gL.glUniform4ivARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.intData);
                        }
                    }
                    continue block23;
                }
                case 2: {
                    switch (shaderArgumentValue.size) {
                        case 1: {
                            gL.glUniform1fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.floatData);
                            break;
                        }
                        case 2: {
                            gL.glUniform2fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.floatData);
                            break;
                        }
                        case 3: {
                            gL.glUniform3fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.floatData);
                            break;
                        }
                        case 4: {
                            gL.glUniform4fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.floatData);
                        }
                    }
                    continue block23;
                }
                case 3: {
                    switch (shaderArgumentValue.size) {
                        case 2: {
                            gL.glUniformMatrix2fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.transposeMatrix, shaderArgumentValue.floatData);
                            break;
                        }
                        case 3: {
                            gL.glUniformMatrix3fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.transposeMatrix, shaderArgumentValue.floatData);
                            break;
                        }
                        case 4: {
                            gL.glUniformMatrix4fvARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.count, shaderArgumentValue.transposeMatrix, shaderArgumentValue.floatData);
                        }
                    }
                    continue block23;
                }
                case 4: {
                    gL.glUniform1iARB(shaderArgumentValue.uniformLocation, shaderArgumentValue.intData[0]);
                }
            }
        }
    }

    public void postRender(GL gL, GLU gLU, Object object) {
    }

    public int compareTo(Object object) throws ClassCastException {
        ShaderArguments shaderArguments = (ShaderArguments)object;
        return this.compareTo(shaderArguments);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShaderArguments)) {
            return false;
        }
        return this.equals((ShaderArguments)object);
    }

    public void setUniform(String string, int n, float[] fArray, int n2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException(INVALID_DATA_SIZE_MSG + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_COUNT_MSG);
        }
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        shaderArgumentValue.dataType = 2;
        shaderArgumentValue.size = n;
        shaderArgumentValue.count = n2;
        int n3 = n * n2;
        if (shaderArgumentValue.floatData == null || shaderArgumentValue.floatData.length < n3) {
            shaderArgumentValue.floatData = new float[n3];
        }
        System.arraycopy(fArray, 0, shaderArgumentValue.floatData, 0, n3);
    }

    public void setUniform(String string, int n, int[] nArray, int n2) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException(INVALID_DATA_SIZE_MSG + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_COUNT_MSG);
        }
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        shaderArgumentValue.dataType = 1;
        shaderArgumentValue.size = n;
        shaderArgumentValue.count = n2;
        int n3 = n * n2;
        if (shaderArgumentValue.intData == null || shaderArgumentValue.intData.length < n3) {
            shaderArgumentValue.intData = new int[n3];
        }
        System.arraycopy(nArray, 0, shaderArgumentValue.intData, 0, n3);
    }

    public void setUniformMatrix(String string, int n, float[] fArray, int n2, boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 2 || n > 4) {
            throw new IllegalArgumentException(INVALID_MATRIX_SIZE_MSG + n);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException(INVALID_COUNT_MSG);
        }
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        shaderArgumentValue.dataType = 3;
        shaderArgumentValue.size = n;
        shaderArgumentValue.count = n2;
        int n3 = n * n * n2;
        if (shaderArgumentValue.floatData == null || shaderArgumentValue.floatData.length < n3) {
            shaderArgumentValue.floatData = new float[n3];
        }
        System.arraycopy(fArray, 0, shaderArgumentValue.floatData, 0, n3);
        shaderArgumentValue.transposeMatrix = !bl;
    }

    public void setUniformSampler(String string, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        shaderArgumentValue.dataType = 4;
        shaderArgumentValue.size = 1;
        shaderArgumentValue.count = 1;
        if (shaderArgumentValue.intData == null) {
            shaderArgumentValue.intData = new int[4];
        }
        shaderArgumentValue.intData[0] = n;
    }

    public int getUniformType(String string) {
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        return shaderArgumentValue == null ? -1 : shaderArgumentValue.dataType;
    }

    public int getUniformSize(String string) {
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        return shaderArgumentValue == null ? -1 : shaderArgumentValue.size;
    }

    public int getUniformCount(String string) {
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        return shaderArgumentValue == null ? -1 : shaderArgumentValue.count;
    }

    public void getUniform(String string, float[] fArray) throws InvalidDataTypeException {
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        if (shaderArgumentValue == null) {
            return;
        }
        if (shaderArgumentValue.dataType == 1 || shaderArgumentValue.dataType == 4) {
            throw new InvalidDataTypeException(NOT_FLOAT_TYPE_MSG);
        }
        int n = shaderArgumentValue.size * shaderArgumentValue.count * (shaderArgumentValue.dataType == 3 ? shaderArgumentValue.size : 1);
        System.arraycopy(shaderArgumentValue.floatData, 0, fArray, 0, n);
    }

    public void getUniform(String string, int[] nArray) throws InvalidDataTypeException {
        ShaderArgumentValue shaderArgumentValue = this.getValue(string);
        if (shaderArgumentValue == null) {
            return;
        }
        if (shaderArgumentValue.dataType == 2 || shaderArgumentValue.dataType == 3) {
            throw new InvalidDataTypeException(NOT_INT_TYPE_MSG);
        }
        int n = shaderArgumentValue.size * shaderArgumentValue.count;
        System.arraycopy(shaderArgumentValue.intData, 0, nArray, 0, n);
    }

    public void removeUniform(String string) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.values.remove(string);
        for (int i = 0; i < this.numVarNames; ++i) {
            if (!this.varNames[i].equals(string)) continue;
            System.arraycopy(this.varNames, i + 1, this.varNames, i, this.numVarNames - i - 1);
            break;
        }
    }

    private ShaderArgumentValue getValue(String string) {
        ShaderArgumentValue shaderArgumentValue = (ShaderArgumentValue)this.values.get(string);
        if (shaderArgumentValue == null) {
            if (this.varNames.length == this.numVarNames) {
                int n = this.varNames.length + 16;
                String[] stringArray = new String[n];
                System.arraycopy(this.varNames, 0, stringArray, 0, this.varNames.length);
                this.varNames = stringArray;
            }
            this.varNames[this.numVarNames] = string;
            ++this.numVarNames;
            shaderArgumentValue = new ShaderArgumentValue();
            this.values.put(string, shaderArgumentValue);
        }
        return shaderArgumentValue;
    }

    public int compareTo(ShaderArguments shaderArguments) {
        if (shaderArguments == null) {
            return 1;
        }
        if (shaderArguments == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(ShaderArguments shaderArguments) {
        if (shaderArguments == this) {
            return true;
        }
        if (shaderArguments == null) {
            return false;
        }
        if (this.values.size() != shaderArguments.values.size()) {
            return false;
        }
        for (int i = 0; i < this.numVarNames; ++i) {
            ShaderArgumentValue shaderArgumentValue = (ShaderArgumentValue)shaderArguments.values.get(this.varNames[i]);
            if (shaderArgumentValue == null) {
                return false;
            }
            ShaderArgumentValue shaderArgumentValue2 = (ShaderArgumentValue)this.values.get(this.varNames[i]);
            if (shaderArgumentValue2.equals(shaderArgumentValue)) continue;
            return false;
        }
        return true;
    }
}

