/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;

public class ShaderObject
extends SceneGraphObject
implements ShaderSceneGraphObject {
    private String[] sourceStrings;
    private HashMap objectIdMap;
    private boolean vertexSource;
    private boolean compiled;
    private boolean compileRequested;
    private boolean confirmCompile;
    private boolean logRequested;
    private String infoString;

    public ShaderObject(boolean bl) {
        this.vertexSource = bl;
        this.logRequested = false;
        this.compiled = false;
        this.confirmCompile = false;
        this.compileRequested = false;
        this.objectIdMap = new HashMap();
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.compileRequested && this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, true);
        }
        if (this.logRequested && this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, true);
        }
    }

    public void initialize(GL gL, GLU gLU) {
        if (this.compiled && !this.compileRequested || this.sourceStrings == null) {
            return;
        }
        Integer n = (Integer)this.objectIdMap.get(gL);
        int n2 = 0;
        if (n == null) {
            int n3 = this.vertexSource ? 35633 : 35632;
            n2 = gL.glCreateShaderObjectARB(n3);
            this.objectIdMap.put(gL, new Integer(n2));
        } else {
            n2 = n;
        }
        gL.glShaderSourceARB(n2, this.sourceStrings.length, this.sourceStrings, (int[])null);
        gL.glCompileShaderARB(n2);
        if (this.confirmCompile) {
            int[] nArray = new int[1];
            gL.glGetObjectParameterivARB(n2, 35713, nArray);
            this.compiled = nArray[0] == 1;
        } else {
            this.compiled = true;
        }
        this.compileRequested = false;
    }

    public void fetchLogInfo(GL gL, GLU gLU) {
        Integer n = (Integer)this.objectIdMap.get(gL);
        if (n == null) {
            return;
        }
        int n2 = n;
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35716, nArray);
        byte[] byArray = new byte[nArray[0]];
        gL.glGetInfoLogARB(n2, byArray.length, nArray, byArray);
        this.infoString = new String(byArray, 0, nArray[0]);
        this.logRequested = false;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShaderObject)) {
            return false;
        }
        return this.equals((ShaderObject)object);
    }

    public boolean isVertexShader() {
        return this.vertexSource;
    }

    public void setSourceStrings(String[] stringArray, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (stringArray == null || stringArray.length == 0 || n == 0) {
            this.sourceStrings = null;
        } else {
            this.sourceStrings = new String[n];
            System.arraycopy(stringArray, 0, this.sourceStrings, 0, n);
        }
    }

    public String[] getSourceStrings() {
        return this.sourceStrings;
    }

    public void clearSourceStrings() {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.sourceStrings = null;
    }

    public void compile() {
        this.compileRequested = true;
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, false);
        }
    }

    public void requestInfoLog() throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, false);
        }
        this.logRequested = true;
    }

    public String getLastInfoLog() {
        return this.infoString;
    }

    public boolean isCompiled() {
        return this.compiled && !this.compileRequested;
    }

    public void markForDeletion() {
    }

    public void requestCompilationConfirmation(boolean bl) {
        this.confirmCompile = bl;
    }

    public boolean isCompilationConfirmed(boolean bl) {
        return this.confirmCompile;
    }

    protected int getShaderId(GL gL) {
        Integer n = (Integer)this.objectIdMap.get(gL);
        return n == null ? 0 : n;
    }

    public boolean equals(ShaderObject shaderObject) {
        if (shaderObject == this) {
            return true;
        }
        if (shaderObject == null) {
            return false;
        }
        if (this.sourceStrings != shaderObject.sourceStrings) {
            if (this.sourceStrings == null || shaderObject.sourceStrings == null) {
                return false;
            }
            for (int i = 0; i < this.sourceStrings.length; ++i) {
                if (this.sourceStrings[i].equals(shaderObject.sourceStrings[i])) continue;
                return false;
            }
        }
        return true;
    }
}

