/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeComponent;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.ShaderObject;
import org.j3d.aviatrix3d.ShaderSceneGraphObject;

public class ShaderProgram
extends NodeComponent
implements DeletableSceneGraphObject,
ShaderSceneGraphObject,
RenderableObject,
Comparable {
    private boolean logRequested = false;
    private boolean linkRequested = false;
    private boolean linked = false;
    private boolean confirmLink = false;
    private ArrayList pendingAdds;
    private ArrayList pendingDeletes;
    private ArrayList currentObjects = new ArrayList();
    private HashMap attributeNames = new HashMap();
    private HashMap programIdMap = new HashMap();
    private String infoString;

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        int n = this.currentObjects.size();
        for (int i = 0; i < n; ++i) {
            ShaderObject shaderObject = (ShaderObject)this.currentObjects.get(i);
            shaderObject.setUpdateHandler(this.updateHandler);
        }
        if (this.linkRequested && this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, true);
        }
        if (this.logRequested && this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, true);
        }
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            int n = this.currentObjects.size();
            for (int i = 0; i < n; ++i) {
                ShaderObject shaderObject = (ShaderObject)this.currentObjects.get(i);
                shaderObject.setLive(bl);
            }
            super.setLive(bl);
            if (!bl && this.updateHandler != null) {
                this.updateHandler.objectRemoved(this);
            }
        }
    }

    public void render(GL gL, GLU gLU) {
        if (!this.linked && !this.linkRequested) {
            return;
        }
        this.initialize(gL, gLU);
        Integer n = (Integer)this.programIdMap.get(gL);
        if (n == null) {
            return;
        }
        gL.glUseProgramObjectARB(n.intValue());
    }

    public void postRender(GL gL, GLU gLU) {
        gL.glUseProgramObjectARB(0);
    }

    public void initialize(GL gL, GLU gLU) {
        Object object;
        int n;
        int n2;
        if (this.linked && !this.linkRequested) {
            return;
        }
        boolean bl = false;
        Integer n3 = (Integer)this.programIdMap.get(gL);
        int n4 = 0;
        if (n3 == null) {
            n4 = gL.glCreateProgramObjectARB();
            this.programIdMap.put(gL, new Integer(n4));
            bl = true;
        } else {
            n4 = n3;
        }
        if (!bl && this.pendingDeletes != null) {
            n2 = this.pendingDeletes.size();
            for (n = 0; n < n2; ++n) {
                object = (ShaderObject)this.pendingDeletes.get(n);
                gL.glDetachObjectARB(n4, ((ShaderObject)object).getShaderId(gL));
            }
            this.pendingDeletes = null;
        }
        if (this.pendingAdds != null) {
            n2 = this.pendingAdds.size();
            for (n = 0; n < n2; ++n) {
                object = (ShaderObject)this.pendingAdds.get(n);
                if (!((ShaderObject)object).isCompiled()) {
                    ((ShaderObject)object).initialize(gL, gLU);
                }
                gL.glAttachObjectARB(n4, ((ShaderObject)object).getShaderId(gL));
            }
            this.pendingAdds = null;
        }
        if (this.attributeNames.size() != 0) {
            Set set = this.attributeNames.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                gL.glBindAttribLocationARB(n4, ((Integer)object.getValue()).intValue(), (String)object.getKey());
            }
        }
        gL.glLinkProgramARB(n4);
        if (this.confirmLink) {
            int[] nArray = new int[1];
            gL.glGetObjectParameterivARB(n4, 35714, nArray);
            this.linked = nArray[0] == 1;
        } else {
            this.linked = true;
        }
        this.linkRequested = false;
    }

    public void fetchLogInfo(GL gL, GLU gLU) {
        Integer n = (Integer)this.programIdMap.get(gL);
        if (n == null) {
            return;
        }
        int n2 = n;
        int[] nArray = new int[1];
        gL.glGetObjectParameterivARB(n2, 35716, nArray);
        byte[] byArray = new byte[nArray[0]];
        gL.glGetInfoLogARB(n2, byArray.length, nArray, byArray);
        this.infoString = new String(byArray, 0, nArray[0]);
        this.logRequested = false;
    }

    public void cleanup(GL gL, GLU gLU) {
        Integer n = (Integer)this.programIdMap.remove(gL);
        if (n == null) {
            return;
        }
        int n2 = n;
        gL.glDeleteObjectARB(n2);
        this.linked = false;
        this.linkRequested = false;
    }

    public int compareTo(Object object) throws ClassCastException {
        ShaderProgram shaderProgram = (ShaderProgram)object;
        return this.compareTo(shaderProgram);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShaderProgram)) {
            return false;
        }
        return this.equals((ShaderProgram)object);
    }

    public void addShaderObject(ShaderObject shaderObject) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (!this.currentObjects.contains(shaderObject)) {
            if (this.pendingAdds == null) {
                this.pendingAdds = new ArrayList();
            }
            this.currentObjects.add(shaderObject);
            this.pendingAdds.add(shaderObject);
        }
    }

    public void removeShaderObject(ShaderObject shaderObject) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.currentObjects.contains(shaderObject)) {
            if (this.pendingDeletes == null) {
                this.pendingDeletes = new ArrayList();
            }
            this.currentObjects.remove(shaderObject);
            this.pendingDeletes.add(shaderObject);
        }
    }

    public int getNumShaderObjects() {
        return this.currentObjects.size();
    }

    public void getShaderObjects(ShaderObject[] shaderObjectArray) {
        this.currentObjects.toArray(shaderObjectArray);
    }

    public void link() throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.linkRequested = true;
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresInit(this, false);
        }
    }

    public void requestInfoLog() throws InvalidWriteTimingException {
        if (this.updateHandler != null && !this.updateHandler.isPickingPermitted()) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.updateHandler != null) {
            this.updateHandler.shaderRequiresLogInfo(this, false);
        }
        this.logRequested = true;
    }

    public String getLastInfoLog() {
        return this.infoString;
    }

    public void bindAttributeName(String string, int n) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.attributeNames.put(string, new Integer(n));
    }

    public void requestLinkConfirmation(boolean bl) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.confirmLink = bl;
    }

    public boolean isLinkConfirmed() {
        return this.confirmLink;
    }

    public boolean isValid(GL gL) {
        Integer n = (Integer)this.programIdMap.get(gL);
        return n != null;
    }

    public int getProgramId(GL gL) {
        Integer n = (Integer)this.programIdMap.get(gL);
        return n == null ? 0 : n;
    }

    public int compareTo(ShaderProgram shaderProgram) {
        if (shaderProgram == null) {
            return 1;
        }
        if (shaderProgram == this) {
            return 0;
        }
        return 0;
    }

    public boolean equals(ShaderProgram shaderProgram) {
        if (shaderProgram == this) {
            return true;
        }
        if (shaderProgram == null) {
            return false;
        }
        if (this.currentObjects.size() != shaderProgram.currentObjects.size()) {
            return false;
        }
        return false;
    }
}

