/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.Appearance;
import org.j3d.aviatrix3d.BoundingBox;
import org.j3d.aviatrix3d.BoundingVoid;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Geometry;
import org.j3d.aviatrix3d.InvalidPickTimingException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.NotPickableException;
import org.j3d.aviatrix3d.PickRequest;
import org.j3d.aviatrix3d.PickableObject;
import org.j3d.aviatrix3d.PickingHandler;
import org.j3d.aviatrix3d.RenderableObject;
import org.j3d.aviatrix3d.SceneGraphObject;

public class Shape3D
extends Leaf
implements PickableObject,
RenderableObject {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private Geometry geom;
    private Appearance app;
    private int pickFlags = -1;

    protected void updateBounds() {
        this.recomputeBounds();
        if (this.parent != null) {
            this.parent.updateBounds();
        }
    }

    protected void markBoundsDirty() {
        if (this.parent != null) {
            this.parent.markBoundsDirty();
        }
    }

    protected void recomputeBounds() {
        if (!this.implicitBounds) {
            return;
        }
        if (this.geom == null) {
            this.bounds = INVALID_BOUNDS;
        } else {
            if (this.bounds == null || this.bounds == INVALID_BOUNDS) {
                this.bounds = new BoundingBox();
            }
            BoundingBox boundingBox = (BoundingBox)this.bounds;
            BoundingVolume boundingVolume = this.geom.getBounds();
            if (boundingVolume instanceof BoundingVoid) {
                this.bounds = INVALID_BOUNDS;
            } else {
                float[] fArray = new float[3];
                float[] fArray2 = new float[3];
                boundingVolume.getExtents(fArray, fArray2);
                boundingBox.setMinimum(fArray);
                boundingBox.setMaximum(fArray2);
            }
        }
    }

    public void requestBoundsUpdate() {
        if (this.alive || !this.implicitBounds || this.geom == null || this.geom.isLive()) {
            return;
        }
        this.geom.recomputeBounds();
        this.recomputeBounds();
    }

    protected void setLive(boolean bl) {
        if (this.geom != null) {
            this.geom.setLive(bl);
        }
        if (this.app != null) {
            this.app.setLive(bl);
        }
        super.setLive(bl);
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        if (this.app != null) {
            this.app.setUpdateHandler(this.updateHandler);
        }
        if (this.geom != null) {
            this.geom.setUpdateHandler(this.updateHandler);
        }
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        if (this.app != null) {
            this.app.checkForCyclicChild(sceneGraphObject);
        }
    }

    public void render(GL gL, GLU gLU) {
        if (this.app != null) {
            this.app.render(gL, gLU);
        }
        if (this.geom != null) {
            this.geom.render(gL, gLU);
        }
    }

    public void postRender(GL gL, GLU gLU) {
        if (this.app != null) {
            this.app.postRender(gL, gLU);
        }
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingHandler pickingHandler = this.updateHandler.getPickHandler();
        pickingHandler.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingHandler pickingHandler = this.updateHandler.getPickHandler();
        pickingHandler.pickSingle(this, pickRequest);
    }

    public boolean isVisible() {
        boolean bl = this.app != null ? this.app.isVisible() : true;
        boolean bl2 = this.geom != null ? this.geom.isVisible() : false;
        return bl2 && bl;
    }

    public Geometry getGeometry() {
        return this.geom;
    }

    public void setGeometry(Geometry geometry) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isBoundsWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.geom != null) {
            this.geom.setLive(false);
            this.geom.removeParent(this);
        }
        this.geom = geometry;
        if (this.geom != null) {
            this.geom.addParent(this);
            this.geom.setLive(this.alive);
            this.geom.setUpdateHandler(this.updateHandler);
        }
    }

    public Appearance getAppearance() {
        return this.app;
    }

    public void setAppearance(Appearance appearance) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (this.app != null) {
            this.app.setLive(false);
        }
        this.app = appearance;
        if (this.app != null) {
            this.app.setLive(this.alive);
            this.app.setUpdateHandler(this.updateHandler);
        }
    }
}

