/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.Shape3D;

public class ShapeBackground
extends Background {
    private float[] color = new float[4];
    private Shape3D[] geometry;
    private int numGeometry;

    public ShapeBackground() {
        this.color[3] = 1.0f;
        this.numGeometry = 0;
        this.geometry = new Shape3D[5];
    }

    public ShapeBackground(float[] fArray) {
        this();
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void render(GL gL, GLU gLU) {
        gL.glClearColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        gL.glClear(16384);
        for (int i = 0; i < this.numGeometry; ++i) {
            if (!this.geometry[i].isVisible()) continue;
            this.geometry[i].render(gL, gLU);
            this.geometry[i].postRender(gL, gLU);
        }
    }

    public void postRender(GL gL, GLU gLU) {
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
        for (int i = 0; i < this.numGeometry; ++i) {
            if (this.geometry[i] == null) continue;
            this.geometry[i].setUpdateHandler(nodeUpdateHandler);
        }
    }

    protected void setLive(boolean bl) {
        for (int i = 0; i < this.numGeometry; ++i) {
            if (this.geometry[i] == null) continue;
            this.geometry[i].setLive(bl);
        }
        super.setLive(bl);
    }

    public void setColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void setColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.color[0];
        fArray[1] = this.color[1];
        fArray[2] = this.color[2];
        fArray[3] = this.color[3];
    }

    public void addShape(Shape3D shape3D) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (shape3D == null) {
            return;
        }
        if (this.numGeometry == this.geometry.length) {
            Shape3D[] shape3DArray = new Shape3D[this.numGeometry + 5];
            System.arraycopy(this.geometry, 0, shape3DArray, 0, this.numGeometry);
            this.geometry = shape3DArray;
        }
        this.geometry[this.numGeometry++] = shape3D;
        if (shape3D.isLive() != this.alive) {
            shape3D.setLive(this.alive);
        }
        shape3D.setParent(this);
        shape3D.setUpdateHandler(this.updateHandler);
    }

    public Shape3D removeShape(int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (n < 0 || n >= this.numGeometry) {
            throw new IllegalArgumentException("idx Is out of bounds");
        }
        Shape3D shape3D = this.geometry[n];
        if (this.geometry[n] != null) {
            this.geometry[n].setLive(false);
            this.geometry[n].removeParent(this);
        }
        if (n == this.numGeometry - 1) {
            this.geometry[n] = null;
        } else {
            System.arraycopy(this.geometry, n, this.geometry, n + 1, this.numGeometry - n - 1);
        }
        --this.numGeometry;
        return shape3D;
    }

    public void setShape(Shape3D shape3D, int n) {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (shape3D == null) {
            throw new IllegalArgumentException("Null shape provided");
        }
        if (n < 0 || n >= this.numGeometry) {
            throw new IllegalArgumentException("idx Is out of bounds");
        }
        if (this.geometry[n] != null) {
            this.geometry[n].setLive(false);
            this.geometry[n].removeParent(this);
        }
        this.geometry[n] = shape3D;
        if (shape3D.isLive() != this.alive) {
            shape3D.setLive(this.alive);
        }
        shape3D.setParent(this);
        shape3D.setUpdateHandler(this.updateHandler);
    }

    public Shape3D getShape(int n) {
        if (n < 0 || n >= this.numGeometry) {
            throw new IllegalArgumentException("idx Is out of bounds");
        }
        return this.geometry[n];
    }
}

