/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import org.j3d.aviatrix3d.AlreadyParentedException;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.Group;
import org.j3d.aviatrix3d.InvalidNodeTypeException;
import org.j3d.aviatrix3d.InvalidPickTimingException;
import org.j3d.aviatrix3d.Node;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.NotPickableException;
import org.j3d.aviatrix3d.PickRequest;
import org.j3d.aviatrix3d.PickableObject;
import org.j3d.aviatrix3d.PickingHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.Shape3D;

public class SharedNode
extends Node
implements PickableObject {
    private static final String PICK_TIMING_MSG = "Picking not permitted right now. Picking is only permitted during the update observer callbacks.";
    private static final String PICKABLE_FALSE_MSG = "This node has been marked as not pickable by the user";
    private static final String NOT_GROUP_MSG = "Attempting to set a shared node into a node that is not a Group node or SharedNode instance";
    private static final int LIST_START_SIZE = 5;
    private static final int LIST_INCREMENT = 5;
    private Group[] parentList = new Group[5];
    private int lastParentList = 0;
    private int liveCount = 0;
    private Node sharedChild;
    private boolean boundsDirty = false;
    private int pickFlags = -1;

    protected void markBoundsDirty() {
        this.boundsDirty = true;
        if (this.implicitBounds) {
            for (int i = 0; i < this.lastParentList; ++i) {
                this.parentList[i].markBoundsDirty();
            }
        }
    }

    public void requestBoundsUpdate() {
        if (this.alive || !this.implicitBounds) {
            return;
        }
        if (this.sharedChild instanceof Group) {
            ((Group)this.sharedChild).requestBoundsUpdate();
        } else if (this.sharedChild instanceof Shape3D) {
            ((Shape3D)this.sharedChild).requestBoundsUpdate();
        } else if (this.sharedChild instanceof SharedNode) {
            ((SharedNode)this.sharedChild).requestBoundsUpdate();
        }
        this.recomputeBounds();
    }

    protected void recomputeBounds() {
        if (!this.alive || !this.implicitBounds) {
            return;
        }
        this.bounds = this.sharedChild == null ? INVALID_BOUNDS : this.sharedChild.getBounds();
    }

    protected void updateBounds() {
        if (!this.boundsDirty || !this.implicitBounds) {
            return;
        }
        this.boundsDirty = false;
        this.recomputeBounds();
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].updateBounds();
        }
    }

    protected void setParent(Node node) throws AlreadyParentedException, InvalidNodeTypeException {
        if (node != null && !(node instanceof Group) && !(node instanceof SharedNode)) {
            throw new InvalidNodeTypeException(NOT_GROUP_MSG);
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            return;
        }
        this.resizeList();
        this.parentList[this.lastParentList++] = (Group)node;
    }

    protected void removeParent(Node node) {
        for (int i = 0; i < this.lastParentList; ++i) {
            if (this.parentList[i] != node) continue;
            int n = this.lastParentList - i;
            if (n == 0) break;
            System.arraycopy(this.parentList, i, this.parentList, i + 1, n);
            break;
        }
    }

    public Node getParent() {
        return this.parentList[0];
    }

    public int numParents() {
        return this.lastParentList;
    }

    public void getParents(Node[] nodeArray) {
        if (nodeArray == null) {
            throw new NullPointerException("Parent array is null");
        }
        System.arraycopy(this.parentList, 0, nodeArray, 0, this.lastParentList);
    }

    protected void setLive(boolean bl) {
        if (bl) {
            ++this.liveCount;
        } else if (this.liveCount > 0) {
            --this.liveCount;
        }
        if (this.liveCount == 0 || !this.alive) {
            this.sharedChild.setLive(bl);
        }
        this.alive = bl;
        super.setLive(bl);
        if (bl) {
            this.recomputeBounds();
        }
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        this.updateHandler = nodeUpdateHandler;
        if (this.sharedChild != null) {
            this.sharedChild.setUpdateHandler(nodeUpdateHandler);
            this.bounds = this.sharedChild.getBounds();
        }
    }

    protected void checkForCyclicParent(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
        for (int i = 0; i < this.lastParentList; ++i) {
            this.parentList[i].checkForCyclicParent(sceneGraphObject);
        }
    }

    public void setPickMask(int n) {
        this.pickFlags = n;
    }

    public int getPickMask() {
        return this.pickFlags;
    }

    public void pickBatch(PickRequest[] pickRequestArray, int n) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingHandler pickingHandler = this.updateHandler.getPickHandler();
        pickingHandler.pickBatch(this, pickRequestArray, n);
    }

    public void pickSingle(PickRequest pickRequest) throws NotPickableException, InvalidPickTimingException {
        if (this.updateHandler == null || !this.updateHandler.isPickingPermitted()) {
            throw new InvalidPickTimingException(PICK_TIMING_MSG);
        }
        if (this.pickFlags == 0) {
            throw new NotPickableException(PICKABLE_FALSE_MSG);
        }
        PickingHandler pickingHandler = this.updateHandler.getPickHandler();
        pickingHandler.pickSingle(this, pickRequest);
    }

    public void setChild(Node node) {
        if (this.sharedChild != null) {
            this.sharedChild.setLive(false);
            this.sharedChild.removeParent(this);
        }
        this.sharedChild = node;
        if (this.sharedChild != null) {
            this.sharedChild.setParent(this);
            this.sharedChild.setLive(this.alive);
            this.sharedChild.setUpdateHandler(this.updateHandler);
        } else {
            this.bounds = INVALID_BOUNDS;
        }
    }

    public Node getChild() {
        return this.sharedChild;
    }

    private final void resizeList() {
        if (this.lastParentList + 1 == this.parentList.length) {
            int n = this.parentList.length;
            int n2 = n + 5;
            Group[] groupArray = new Group[n2];
            System.arraycopy(this.parentList, 0, groupArray, 0, n);
            this.parentList = groupArray;
        }
    }
}

