/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import javax.vecmath.Matrix4f;
import net.java.games.joal.AL;
import org.j3d.aviatrix3d.AudioComponent;
import org.j3d.aviatrix3d.AudioRenderable;
import org.j3d.aviatrix3d.BoundingVolume;
import org.j3d.aviatrix3d.CyclicSceneGraphStructureException;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Leaf;
import org.j3d.aviatrix3d.NodeUpdateHandler;
import org.j3d.aviatrix3d.SceneGraphObject;
import org.j3d.aviatrix3d.iutil.AudioUpdateListener;

public abstract class Sound
extends Leaf
implements AudioRenderable,
AudioUpdateListener {
    protected AudioComponent soundSource;
    protected int format;
    protected int freq;
    protected boolean loop;
    protected int buffer;
    protected float pitch;
    protected int seq;
    protected boolean dataChanged = false;
    protected boolean playChanged = false;
    protected boolean paramsChanged = false;
    protected boolean playing = false;
    protected boolean paused = false;

    public void setAudioSource(AudioComponent audioComponent) {
        if (this.alive && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.soundSource = audioComponent;
        this.format = audioComponent.getFormat();
        this.freq = audioComponent.getFrequency();
        this.loop = audioComponent.getLoop();
        this.pitch = audioComponent.getPitch();
        audioComponent.addUpdateListener(this);
        this.dataChanged = true;
    }

    public void audioUpdated(int n, int n2, int n3) {
        this.format = n;
        this.freq = n2;
        this.seq = n3;
        this.dataChanged = true;
    }

    public void paramsUpdated(boolean bl, float f) {
        this.pitch = f;
        this.loop = bl;
        this.paramsChanged = true;
    }

    public void startSound() {
        if (!this.playing || this.paused) {
            this.playChanged = true;
            this.playing = true;
            this.paused = false;
        }
    }

    public void stopSound() {
        if (this.playing) {
            this.playChanged = true;
            this.playing = false;
            this.paused = false;
        }
    }

    public void pauseSound() {
        if (this.playing && !this.paused) {
            this.playChanged = true;
            this.paused = true;
        }
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void render(AL aL, Matrix4f matrix4f) {
    }

    public void postRender(AL aL) {
    }

    protected void markBoundsDirty() {
    }

    protected void recomputeBounds() {
    }

    public void requestBoundsUpdate() {
    }

    public BoundingVolume getBounds() {
        return INVALID_BOUNDS;
    }

    public boolean isEnabled() {
        return false;
    }

    protected void setUpdateHandler(NodeUpdateHandler nodeUpdateHandler) {
        super.setUpdateHandler(nodeUpdateHandler);
    }

    protected void setLive(boolean bl) {
        super.setLive(bl);
    }

    protected void checkForCyclicChild(SceneGraphObject sceneGraphObject) throws CyclicSceneGraphStructureException {
        if (sceneGraphObject == this) {
            throw new CyclicSceneGraphStructureException();
        }
    }
}

