/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import java.io.Serializable;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.HashMap;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.Background;
import org.j3d.aviatrix3d.DeletableSceneGraphObject;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.TextureComponent2D;

public class SphereBackground
extends Background
implements DeletableSceneGraphObject {
    private static final int DEFAULT_NUM_FACETS = 32;
    private float[] color = new float[4];
    private TextureComponent2D texture;
    protected int width;
    protected int height;
    private int stripLength;
    private int numStrips;
    private FloatBuffer vertexBuffer;
    private FloatBuffer normalBuffer;
    private FloatBuffer textureBuffer;
    protected boolean stateChanged = false;
    protected HashMap textureIdMap = new HashMap();

    public SphereBackground() {
        this.generateSphereGeom(32);
    }

    public SphereBackground(float[] fArray) {
        this();
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void cleanup(GL gL, GLU gLU) {
        Integer n = (Integer)this.textureIdMap.get(gL);
        if (n != null) {
            int[] nArray = new int[]{n};
            gL.glDeleteTextures(1, nArray);
            this.textureIdMap.remove(gL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render(GL gL, GLU gLU) {
        Serializable serializable;
        gL.glClearColor(this.color[0], this.color[1], this.color[2], this.color[3]);
        gL.glClear(16384);
        if (this.texture == null) {
            return;
        }
        if (this.stateChanged) {
            serializable = this.textureIdMap;
            synchronized (serializable) {
                this.textureIdMap.clear();
                this.stateChanged = false;
            }
        }
        gL.glEnable(3553);
        gL.glActiveTexture(33984);
        gL.glTexEnvi(8960, 8704, 7681);
        serializable = (Integer)this.textureIdMap.get(gL);
        if (serializable != null) {
            gL.glBindTexture(3553, ((Integer)serializable).intValue());
        } else {
            int[] nArray = new int[1];
            gL.glGenTextures(1, nArray);
            this.textureIdMap.put(gL, new Integer(nArray[0]));
            gL.glBindTexture(3553, nArray[0]);
            gL.glPixelStorei(3317, 1);
            gL.glTexParameteri(3553, 10242, 33071);
            gL.glTexParameteri(3553, 10243, 33071);
            gL.glTexParameteri(3553, 10240, 9729);
            gL.glTexParameteri(3553, 10241, 9729);
            ByteBuffer byteBuffer = this.texture.getData(0);
            int n = this.texture.getFormat(0);
            int n2 = 6407;
            int n3 = 6407;
            switch (n) {
                case 1: {
                    n2 = 6407;
                    n3 = 6407;
                    break;
                }
                case 2: {
                    n2 = 6408;
                    n3 = 6408;
                    break;
                }
                case 3: {
                    n2 = 32992;
                    n3 = 32992;
                    break;
                }
                case 4: {
                    n2 = 32993;
                    n3 = 32993;
                    break;
                }
                case 5: {
                    n2 = 6410;
                    n3 = 6410;
                    break;
                }
                case 6: {
                    n2 = 6409;
                    n3 = 6409;
                    break;
                }
            }
            gL.glTexImage2D(3553, 0, n2, this.width, this.height, 0, n3, 5121, (Buffer)byteBuffer);
        }
        gL.glEnableClientState(32884);
        gL.glEnableClientState(32885);
        gL.glEnableClientState(32888);
        gL.glVertexPointer(3, 5126, 0, (Buffer)this.vertexBuffer);
        gL.glNormalPointer(5126, 0, (Buffer)this.normalBuffer);
        gL.glTexCoordPointer(2, 5126, 0, (Buffer)this.textureBuffer);
        int n = 0;
        for (int i = 0; i < this.numStrips; ++i) {
            gL.glDrawArrays(5, n, this.stripLength);
            n += this.stripLength;
        }
        gL.glDisableClientState(32888);
        gL.glDisableClientState(32885);
        gL.glDisableClientState(32884);
    }

    public void postRender(GL gL, GLU gLU) {
        gL.glDisable(3553);
    }

    public void setColor(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = fArray[0];
        this.color[1] = fArray[1];
        this.color[2] = fArray[2];
        this.color[3] = fArray[3];
    }

    public void setColor(float f, float f2, float f3, float f4) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.color[0] = f;
        this.color[1] = f2;
        this.color[2] = f3;
        this.color[3] = f4;
    }

    public void getColor(float[] fArray) {
        fArray[0] = this.color[0];
        fArray[1] = this.color[1];
        fArray[2] = this.color[2];
        fArray[3] = this.color[3];
    }

    public void setTexture(TextureComponent2D textureComponent2D) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (textureComponent2D == null) {
            this.width = -1;
            this.height = -1;
        } else {
            this.width = textureComponent2D.getWidth();
            this.height = textureComponent2D.getHeight();
        }
        this.texture = textureComponent2D;
        this.stateChanged = true;
    }

    public TextureComponent2D getTexture() {
        return this.texture;
    }

    private void generateSphereGeom(int n) {
        int n2;
        this.stripLength = n + 1 << 1;
        this.numStrips = n >> 1;
        int n3 = (n + 1) * n;
        this.vertexBuffer = this.createBuffer(n3 * 3);
        this.normalBuffer = this.createBuffer(n3 * 3);
        this.textureBuffer = this.createBuffer(n3 * 2);
        double d = Math.PI * 2 / (double)n;
        float f = 1.0f / (float)n;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        for (n2 = 0; n2 < n; ++n2) {
            fArray2[n2] = (float)Math.cos(d * (double)n2);
            fArray3[n2] = (float)Math.sin(d * (double)n2);
            fArray[n2] = (float)n2 * f;
        }
        n2 = n / 2;
        for (int i = 0; i < n2; ++i) {
            float f2;
            float f3;
            float f4;
            float f5 = (float)Math.cos(d * (double)i);
            float f6 = (float)Math.sin(d * (double)i);
            float f7 = (float)Math.cos(d * (double)(i + 1));
            float f8 = (float)Math.sin(d * (double)(i + 1));
            for (int j = 0; j < n; ++j) {
                f4 = -fArray3[j] * f6;
                f3 = f5;
                f2 = fArray2[j] * f6;
                this.vertexBuffer.put(f4);
                this.vertexBuffer.put(f3);
                this.vertexBuffer.put(f2);
                this.normalBuffer.put(-f4);
                this.normalBuffer.put(-f3);
                this.normalBuffer.put(-f2);
                this.textureBuffer.put((float)j * f);
                this.textureBuffer.put((f3 + 1.0f) * 0.5f);
                f4 = -fArray3[j] * f8;
                f3 = f7;
                f2 = fArray2[j] * f8;
                this.vertexBuffer.put(f4);
                this.vertexBuffer.put(f3);
                this.vertexBuffer.put(f2);
                this.normalBuffer.put(-f4);
                this.normalBuffer.put(-f3);
                this.normalBuffer.put(-f2);
                this.textureBuffer.put((float)j * f);
                this.textureBuffer.put((f3 + 1.0f) * 0.5f);
            }
            f4 = -fArray3[0] * f6;
            f3 = f5;
            f2 = fArray2[0] * f6;
            this.vertexBuffer.put(f4);
            this.vertexBuffer.put(f3);
            this.vertexBuffer.put(f2);
            this.normalBuffer.put(-f4);
            this.normalBuffer.put(-f3);
            this.normalBuffer.put(-f2);
            this.textureBuffer.put(1.0f);
            this.textureBuffer.put((f3 + 1.0f) * 0.5f);
            f4 = -fArray3[0] * f8;
            f3 = f7;
            f2 = fArray2[0] * f8;
            this.vertexBuffer.put(f4);
            this.vertexBuffer.put(f3);
            this.vertexBuffer.put(f2);
            this.normalBuffer.put(-f4);
            this.normalBuffer.put(-f3);
            this.normalBuffer.put(-f2);
            this.textureBuffer.put(1.0f);
            this.textureBuffer.put((f3 + 1.0f) * 0.5f);
        }
        this.vertexBuffer.rewind();
        this.normalBuffer.rewind();
        this.textureBuffer.rewind();
    }

    private FloatBuffer createBuffer(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n * 4);
        byteBuffer.order(ByteOrder.nativeOrder());
        FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
        return floatBuffer;
    }
}

