/*
 * Decompiled with CFR 0.152.
 */
package org.j3d.aviatrix3d;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLU;
import org.j3d.aviatrix3d.InvalidWriteTimingException;
import org.j3d.aviatrix3d.Light;

public class SpotLight
extends Light {
    private static final String ANGLE_RANGE_MSG = "The angle provided is outside the allowed range of 0 to 90 degrees";
    private static final String NEG_EXP_MSG = "The exponent value provided is negative. Must be >= 0";
    private float[] direction;
    private float[] position;
    private float cutOffAngle;
    private float dropOffRate;
    private float cAttenuation;
    private float lAttenuation;
    private float qAttenuation;

    public SpotLight() {
        super(1);
        this.direction = new float[3];
        this.position = new float[4];
        this.cAttenuation = 1.0f;
        this.cutOffAngle = 45.0f;
        this.dropOffRate = 0.0f;
        this.direction[2] = -1.0f;
        this.position[3] = 1.0f;
    }

    public SpotLight(float[] fArray) throws IllegalArgumentException {
        super(1, fArray);
        this.direction = new float[3];
        this.position = new float[3];
        this.cAttenuation = 1.0f;
        this.cutOffAngle = 45.0f;
        this.dropOffRate = 0.0f;
        this.direction[2] = -1.0f;
        this.position[3] = 1.0f;
    }

    public SpotLight(float[] fArray, float[] fArray2, float[] fArray3) throws IllegalArgumentException {
        super(1, fArray);
        this.direction = new float[]{fArray3[0], fArray3[1], fArray3[2]};
        this.position = new float[]{fArray2[0], fArray2[1], fArray2[2], 1.0f};
        this.cAttenuation = 1.0f;
        this.cutOffAngle = 45.0f;
        this.dropOffRate = 0.0f;
    }

    public void render(GL gL, GLU gLU, Object object) {
        int n = (Integer)object;
        gL.glLightfv(n, 4608, this.ambientColor);
        gL.glLightfv(n, 4611, this.position);
        gL.glLightfv(n, 4612, this.direction);
        gL.glLightfv(n, 4609, this.diffuseColor);
        gL.glLightfv(n, 4610, this.specularColor);
        gL.glLightf(n, 4613, this.dropOffRate);
        gL.glLightf(n, 4614, this.cutOffAngle);
        gL.glLightf(n, 4615, this.cAttenuation);
        gL.glLightf(n, 4616, this.lAttenuation);
        gL.glLightf(n, 4617, this.qAttenuation);
        gL.glEnable(n);
    }

    public void postRender(GL gL, GLU gLU, Object object) {
        int n = (Integer)object;
        gL.glLightf(n, 4614, 180.0f);
        gL.glDisable(n);
    }

    public void setCutOffAngle(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f || f > 90.0f) {
            throw new IllegalArgumentException(ANGLE_RANGE_MSG);
        }
        this.cutOffAngle = f;
    }

    public float getCutOffAngle() {
        return this.cutOffAngle;
    }

    public void setDropOffRateExponent(float f) throws IllegalArgumentException, InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        if (f < 0.0f) {
            throw new IllegalArgumentException(NEG_EXP_MSG);
        }
        this.dropOffRate = f;
    }

    public float getDropOffRateExponent() {
        return this.dropOffRate;
    }

    public void setDirection(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.direction[0] = fArray[0];
        this.direction[1] = fArray[1];
        this.direction[2] = fArray[2];
    }

    public void setDirection(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.direction[0] = f;
        this.direction[1] = f2;
        this.direction[2] = f3;
    }

    public void getDirection(float[] fArray) {
        fArray[0] = this.direction[0];
        fArray[1] = this.direction[1];
        fArray[2] = this.direction[2];
    }

    public void setPosition(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.position[0] = fArray[0];
        this.position[1] = fArray[1];
        this.position[2] = fArray[2];
    }

    public void setPosition(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.position[0] = f;
        this.position[1] = f2;
        this.position[2] = f3;
    }

    public void getPosition(float[] fArray) {
        fArray[0] = this.position[0];
        fArray[1] = this.position[1];
        fArray[2] = this.position[2];
    }

    public void setAttenuation(float f, float f2, float f3) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.cAttenuation = f;
        this.lAttenuation = f2;
        this.qAttenuation = f3;
    }

    public void setAttenuation(float[] fArray) throws InvalidWriteTimingException {
        if (this.isLive() && this.updateHandler != null && !this.updateHandler.isDataWritePermitted(this)) {
            throw new InvalidWriteTimingException("Writing is not permitted right now. Changing scene graph object values is only permitted during the update observer callbacks.");
        }
        this.cAttenuation = fArray[0];
        this.lAttenuation = fArray[1];
        this.qAttenuation = fArray[2];
    }

    public void getAttenuation(float[] fArray) {
        fArray[0] = this.cAttenuation;
        fArray[1] = this.lAttenuation;
        fArray[2] = this.qAttenuation;
    }

    public int compareTo(Light light) {
        int n = super.compareTo(light);
        if (n != 0) {
            return n;
        }
        SpotLight spotLight = (SpotLight)light;
        if (this.cAttenuation != spotLight.cAttenuation) {
            return this.cAttenuation < spotLight.cAttenuation ? -1 : 1;
        }
        if (this.lAttenuation != spotLight.lAttenuation) {
            return this.lAttenuation < spotLight.lAttenuation ? -1 : 1;
        }
        if (this.qAttenuation != spotLight.qAttenuation) {
            return this.qAttenuation < spotLight.qAttenuation ? -1 : 1;
        }
        if (this.cutOffAngle != spotLight.cutOffAngle) {
            return this.cutOffAngle < spotLight.cutOffAngle ? -1 : 1;
        }
        if (this.dropOffRate != spotLight.dropOffRate) {
            return this.dropOffRate < spotLight.dropOffRate ? -1 : 1;
        }
        n = this.compareColor3(this.direction, spotLight.direction);
        if (n != 0) {
            return n;
        }
        return this.compareColor3(this.position, spotLight.position);
    }
}

